/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command.mq;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgNameWithHashInfo;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgCommandResultHandler;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgPatchReferenceValidator;

public class HgQRenameCommand {
    private static final Logger LOG = Logger.getInstance(HgQRenameCommand.class);
    @NotNull
    private final HgRepository myRepository;

    public HgQRenameCommand(@NotNull HgRepository repository) {
        if (repository == null) {
            HgQRenameCommand.$$$reportNull$$$0(0);
        }
        this.myRepository = repository;
    }

    public void execute(@NotNull Hash patchHash) {
        if (patchHash == null) {
            HgQRenameCommand.$$$reportNull$$$0(1);
        }
        Project project = this.myRepository.getProject();
        HgNameWithHashInfo patchInfo = (HgNameWithHashInfo)ContainerUtil.find(this.myRepository.getMQAppliedPatches(), info -> {
            if (patchHash == null) {
                HgQRenameCommand.$$$reportNull$$$0(5);
            }
            return info.getHash().equals(patchHash);
        });
        if (patchInfo == null) {
            LOG.error("Could not find patch " + patchHash.toString());
            return;
        }
        String oldName = patchInfo.getName();
        String newName = Messages.showInputDialog((Project)project, (String)String.format("Enter a new name for %s patch:", oldName), (String)"Rename Patch", (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)new HgPatchReferenceValidator(this.myRepository));
        if (newName != null) {
            HgQRenameCommand.performPatchRename(this.myRepository, oldName, newName);
        }
    }

    public static void performPatchRename(final @NotNull HgRepository repository, final @NotNull String oldName, final @NotNull String newName) {
        if (repository == null) {
            HgQRenameCommand.$$$reportNull$$$0(2);
        }
        if (oldName == null) {
            HgQRenameCommand.$$$reportNull$$$0(3);
        }
        if (newName == null) {
            HgQRenameCommand.$$$reportNull$$$0(4);
        }
        if (oldName.equals(newName)) {
            return;
        }
        final Project project = repository.getProject();
        new HgCommandExecutor(project).execute(repository.getRoot(), "qrename", Arrays.asList(oldName, newName), new HgCommandResultHandler(){

            @Override
            public void process(@Nullable HgCommandResult result) {
                if (HgErrorUtil.hasErrorsInCommandExecution(result)) {
                    new HgCommandResultNotifier(project).notifyError(result, "Qrename command failed", "Could not rename patch " + oldName + " to " + newName);
                }
                repository.update();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchHash";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        objectArray2[1] = "org/zmlx/hg4idea/command/mq/HgQRenameCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "performPatchRename";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$execute$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

