/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.aQute.bnd.build;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.internal.impldep.aQute.bnd.build.Project;
import org.gradle.internal.impldep.aQute.bnd.build.ProjectLauncher;
import org.gradle.internal.impldep.aQute.lib.io.IO;

public abstract class ProjectTester {
    private final Project project;
    private final ProjectLauncher launcher;
    private final List<String> tests = new ArrayList<String>();
    private File reportDir;
    private boolean continuous = true;

    public ProjectTester(Project project) throws Exception {
        this.project = project;
        this.launcher = project.getProjectLauncher();
        this.launcher.addRunVM("-ea");
        this.continuous = project.is("-testcontinuous");
        this.reportDir = new File(project.getTarget(), project.getProperty("test-reports", "test-reports"));
    }

    public ProjectLauncher getProjectLauncher() {
        return this.launcher;
    }

    public void addTest(String test) {
        this.tests.add(test);
    }

    public Collection<String> getTests() {
        return this.tests;
    }

    public Collection<File> getReports() {
        ArrayList<File> reports = new ArrayList<File>();
        for (File report : this.reportDir.listFiles()) {
            if (!report.isFile()) continue;
            reports.add(report);
        }
        return reports;
    }

    public File getReportDir() {
        return this.reportDir;
    }

    public void setReportDir(File reportDir) {
        this.reportDir = reportDir;
    }

    public Project getProject() {
        return this.project;
    }

    public boolean getContinuous() {
        return this.continuous;
    }

    public void setContinuous(boolean b) {
        this.continuous = b;
    }

    public File getCwd() {
        return this.launcher.getCwd();
    }

    public void setCwd(File dir2) {
        this.launcher.setCwd(dir2);
    }

    public boolean prepare() throws Exception {
        IO.mkdirs(this.reportDir);
        return true;
    }

    public abstract int test() throws Exception;
}

