/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.amazonaws.services.s3.transfer.internal;

import java.io.File;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gradle.internal.impldep.com.amazonaws.SdkClientException;
import org.gradle.internal.impldep.com.amazonaws.services.s3.AmazonS3;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.GetObjectRequest;

public class DownloadPartCallable
implements Callable<File> {
    private static final Log LOG = LogFactory.getLog(DownloadPartCallable.class);
    private static final String TEMP_FILE_MIDDLE_NAME = ".part.";
    private final AmazonS3 s3;
    private final GetObjectRequest getPartRequest;
    private final File destinationFile;
    private final String destinationFilePath;
    private File partFile;

    public DownloadPartCallable(AmazonS3 s3, GetObjectRequest getPartRequest, File destinationFile) {
        this.s3 = s3;
        this.getPartRequest = getPartRequest;
        this.destinationFile = destinationFile;
        this.destinationFilePath = destinationFile.getAbsolutePath();
    }

    @Override
    public File call() throws Exception {
        this.partFile = File.createTempFile(this.destinationFile.getName() + "-tmp", TEMP_FILE_MIDDLE_NAME + this.getPartRequest.getPartNumber().toString(), new File(this.destinationFilePath.substring(0, this.destinationFilePath.lastIndexOf(File.separator))));
        try {
            this.partFile.deleteOnExit();
        }
        catch (SecurityException exception) {
            LOG.warn((Object)("SecurityException denied delete access to file " + this.partFile.getAbsolutePath()));
        }
        if (this.s3.getObject(this.getPartRequest, this.partFile) == null) {
            throw new SdkClientException("There is no object in S3 satisfying this request. The getObject method returned null");
        }
        return this.partFile;
    }
}

