/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.plugins.lock;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.HashMap;
import java.util.Map;
import org.gradle.internal.impldep.org.apache.ivy.plugins.lock.AbstractLockStrategy;
import org.gradle.internal.impldep.org.apache.ivy.util.Message;

public abstract class FileBasedLockStrategy
extends AbstractLockStrategy {
    private static final int SLEEP_TIME = 100;
    private static final long DEFAULT_TIMEOUT = 120000L;
    private FileLocker locker;
    private long timeout = 120000L;
    private Map currentLockCounters = new HashMap();

    protected FileBasedLockStrategy() {
        this(new CreateFileLocker(false), false);
    }

    protected FileBasedLockStrategy(boolean debugLocking) {
        this(new CreateFileLocker(debugLocking), debugLocking);
    }

    protected FileBasedLockStrategy(FileLocker locker, boolean debugLocking) {
        super(debugLocking);
        this.locker = locker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean acquireLock(File file) throws InterruptedException {
        if (this.isDebugLocking()) {
            FileBasedLockStrategy.debugLocking("acquiring lock on " + file);
        }
        long start = System.currentTimeMillis();
        do {
            FileBasedLockStrategy fileBasedLockStrategy = this;
            synchronized (fileBasedLockStrategy) {
                if (this.hasLock(file)) {
                    int holdLocks = this.incrementLock(file);
                    if (this.isDebugLocking()) {
                        FileBasedLockStrategy.debugLocking("reentrant lock acquired on " + file + " in " + (System.currentTimeMillis() - start) + "ms" + " - hold locks = " + holdLocks);
                    }
                    return true;
                }
                if (this.locker.tryLock(file)) {
                    if (this.isDebugLocking()) {
                        FileBasedLockStrategy.debugLocking("lock acquired on " + file + " in " + (System.currentTimeMillis() - start) + "ms");
                    }
                    this.incrementLock(file);
                    return true;
                }
            }
            Thread.sleep(100L);
        } while (System.currentTimeMillis() - start < this.timeout);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseLock(File file) {
        FileBasedLockStrategy fileBasedLockStrategy = this;
        synchronized (fileBasedLockStrategy) {
            int holdLocks = this.decrementLock(file);
            if (holdLocks == 0) {
                this.locker.unlock(file);
                if (this.isDebugLocking()) {
                    FileBasedLockStrategy.debugLocking("lock released on " + file);
                }
            } else if (this.isDebugLocking()) {
                FileBasedLockStrategy.debugLocking("reentrant lock released on " + file + " - hold locks = " + holdLocks);
            }
        }
    }

    private static void debugLocking(String msg) {
        Message.info(Thread.currentThread() + " " + System.currentTimeMillis() + " " + msg);
    }

    private boolean hasLock(File file) {
        Integer c = (Integer)this.currentLockCounters.get(file);
        return c != null && c > 0;
    }

    private int incrementLock(File file) {
        Integer c = (Integer)this.currentLockCounters.get(file);
        int holdLocks = c == null ? 1 : c + 1;
        this.currentLockCounters.put(file, new Integer(holdLocks));
        return holdLocks;
    }

    private int decrementLock(File file) {
        Integer c = (Integer)this.currentLockCounters.get(file);
        int dc = c == null ? 0 : c - 1;
        this.currentLockCounters.put(file, new Integer(dc));
        return dc;
    }

    public static class NIOFileLocker
    implements FileLocker {
        private Map locks = new HashMap();
        private boolean debugLocking;

        public NIOFileLocker(boolean debugLocking) {
            this.debugLocking = debugLocking;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean tryLock(File file) {
            try {
                if (!file.getParentFile().exists()) {
                    if (!file.getParentFile().mkdirs()) return false;
                }
                RandomAccessFile raf = new RandomAccessFile(file, "rw");
                FileChannel channel = raf.getChannel();
                try {
                    FileLock l = channel.tryLock();
                    if (l != null) {
                        NIOFileLocker nIOFileLocker = this;
                        synchronized (nIOFileLocker) {
                            this.locks.put(file, l);
                        }
                        boolean bl = true;
                        return bl;
                    }
                    if (!this.debugLocking) return false;
                    FileBasedLockStrategy.debugLocking("failed to acquire lock on " + file);
                    return false;
                }
                finally {
                    raf.close();
                }
            }
            catch (IOException e) {
                Message.verbose("file lock failed due to an exception: " + e.getMessage() + " (" + file + ")");
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlock(File file) {
            NIOFileLocker nIOFileLocker = this;
            synchronized (nIOFileLocker) {
                FileLock l = (FileLock)this.locks.get(file);
                if (l == null) {
                    throw new IllegalArgumentException("file not previously locked: " + file);
                }
                try {
                    l.release();
                }
                catch (IOException e) {
                    Message.error("problem while releasing lock on " + file + ": " + e.getMessage());
                }
            }
        }
    }

    public static class CreateFileLocker
    implements FileLocker {
        private boolean debugLocking;

        public CreateFileLocker(boolean debugLocking) {
            this.debugLocking = debugLocking;
        }

        public boolean tryLock(File file) {
            try {
                if (file.getParentFile().exists() || file.getParentFile().mkdirs()) {
                    if (file.createNewFile()) {
                        return true;
                    }
                    if (this.debugLocking) {
                        FileBasedLockStrategy.debugLocking("file creation failed " + file);
                    }
                }
            }
            catch (IOException e) {
                Message.verbose("file creation failed due to an exception: " + e.getMessage() + " (" + file + ")");
            }
            return false;
        }

        public void unlock(File file) {
            file.delete();
        }
    }

    public static interface FileLocker {
        public boolean tryLock(File var1);

        public void unlock(File var1);
    }
}

