/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven.plugin.prefix;

import java.util.List;
import org.gradle.internal.impldep.org.sonatype.aether.repository.LocalRepository;
import org.gradle.internal.impldep.org.sonatype.aether.repository.RemoteRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoPluginFoundForPrefixException
extends Exception {
    public NoPluginFoundForPrefixException(String prefix, List<String> pluginGroups, LocalRepository localRepository, List<RemoteRepository> remoteRepositories) {
        super("No plugin found for prefix '" + prefix + "' in the current project and in the plugin groups " + pluginGroups + " available from the repositories " + NoPluginFoundForPrefixException.format(localRepository, remoteRepositories));
    }

    private static String format(LocalRepository localRepository, List<RemoteRepository> remoteRepositories) {
        String repos = "[";
        if (localRepository != null) {
            repos = repos + localRepository.getId() + " (" + localRepository.getBasedir() + ")";
        }
        if (remoteRepositories != null && !remoteRepositories.isEmpty()) {
            for (RemoteRepository repository : remoteRepositories) {
                repos = repos + ", ";
                if (repository == null) continue;
                repos = repos + repository.getId() + " (" + repository.getUrl() + ")";
            }
        }
        repos = repos + "]";
        return repos;
    }
}

