/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven.repository.metadata;

import org.gradle.internal.impldep.org.apache.maven.artifact.ArtifactScopeEnum;
import org.gradle.internal.impldep.org.apache.maven.repository.metadata.MetadataGraphVertex;

public class MetadataGraphEdge {
    String version;
    ArtifactScopeEnum scope;
    int depth = -1;
    int pomOrder = -1;
    boolean resolved = true;
    String artifactUri;
    MetadataGraphVertex source;
    MetadataGraphVertex target;

    public MetadataGraphEdge(String version, boolean resolved, ArtifactScopeEnum scope, String artifactUri, int depth, int pomOrder) {
        this.version = version;
        this.scope = scope;
        this.artifactUri = artifactUri;
        this.depth = depth;
        this.resolved = resolved;
        this.pomOrder = pomOrder;
    }

    private static boolean objectsEqual(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null && o2 != null || o1 != null && o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public boolean equals(Object o) {
        if (o instanceof MetadataGraphEdge) {
            MetadataGraphEdge e = (MetadataGraphEdge)o;
            return MetadataGraphEdge.objectsEqual(this.version, e.version) && ArtifactScopeEnum.checkScope(this.scope).getScope().equals(ArtifactScopeEnum.checkScope(e.scope).getScope()) && this.depth == e.depth;
        }
        return false;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ArtifactScopeEnum getScope() {
        return this.scope;
    }

    public void setScope(ArtifactScopeEnum scope) {
        this.scope = scope;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    public int getPomOrder() {
        return this.pomOrder;
    }

    public void setPomOrder(int pomOrder) {
        this.pomOrder = pomOrder;
    }

    public String getArtifactUri() {
        return this.artifactUri;
    }

    public void setArtifactUri(String artifactUri) {
        this.artifactUri = artifactUri;
    }

    public MetadataGraphVertex getSource() {
        return this.source;
    }

    public void setSource(MetadataGraphVertex source) {
        this.source = source;
    }

    public MetadataGraphVertex getTarget() {
        return this.target;
    }

    public void setTarget(MetadataGraphVertex target) {
        this.target = target;
    }

    public String toString() {
        return "[ FROM:(" + (this.source == null ? "no source" : (this.source.md == null ? "no source MD" : this.source.md.toString())) + ") " + "TO:(" + (this.target == null ? "no target" : (this.target.md == null ? "no target MD" : this.target.md.toString())) + ") " + "version=" + this.version + ", scope=" + (this.scope == null ? "null" : this.scope.getScope()) + ", depth=" + this.depth + "]";
    }
}

