/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.codehaus.plexus.util.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import org.gradle.internal.impldep.org.codehaus.plexus.util.IOUtil;
import org.gradle.internal.impldep.org.codehaus.plexus.util.cli.AbstractStreamHandler;
import org.gradle.internal.impldep.org.codehaus.plexus.util.cli.StreamConsumer;

public class StreamPumper
extends AbstractStreamHandler {
    private final BufferedReader in;
    private final StreamConsumer consumer;
    private final PrintWriter out;
    private volatile Exception exception = null;
    private static final int SIZE = 1024;

    public StreamPumper(InputStream in) {
        this(in, (StreamConsumer)null);
    }

    public StreamPumper(InputStream in, StreamConsumer consumer) {
        this(in, null, consumer);
    }

    public StreamPumper(InputStream in, PrintWriter writer) {
        this(in, writer, null);
    }

    public StreamPumper(InputStream in, PrintWriter writer, StreamConsumer consumer) {
        this.in = new BufferedReader(new InputStreamReader(in), 1024);
        this.out = writer;
        this.consumer = consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Object line = this.in.readLine();
            while (line != null) {
                try {
                    if (this.exception == null) {
                        this.consumeLine((String)line);
                    }
                }
                catch (Exception t) {
                    this.exception = t;
                }
                if (this.out != null) {
                    this.out.println((String)line);
                    this.out.flush();
                }
                line = this.in.readLine();
            }
        }
        catch (IOException e) {
            this.exception = e;
        }
        finally {
            IOUtil.close(this.in);
            StreamPumper streamPumper = this;
            synchronized (streamPumper) {
                this.setDone();
                this.notifyAll();
            }
        }
    }

    public void flush() {
        if (this.out != null) {
            this.out.flush();
        }
    }

    public void close() {
        IOUtil.close(this.out);
    }

    public Exception getException() {
        return this.exception;
    }

    private void consumeLine(String line) {
        if (this.consumer != null && !this.isDisabled()) {
            this.consumer.consumeLine(line);
        }
    }
}

