/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.engine.discovery;

import org.gradle.internal.impldep.org.apiguardian.api.API;
import org.gradle.internal.impldep.org.junit.platform.commons.util.PreconditionViolationException;
import org.gradle.internal.impldep.org.junit.platform.commons.util.ReflectionUtils;
import org.gradle.internal.impldep.org.junit.platform.commons.util.ToStringBuilder;
import org.gradle.internal.impldep.org.junit.platform.engine.DiscoverySelector;

@API(status=API.Status.STABLE, since="1.0")
public class ClassSelector
implements DiscoverySelector {
    private final String className;
    private Class<?> javaClass;

    ClassSelector(String className) {
        this.className = className;
    }

    ClassSelector(Class<?> javaClass) {
        this.className = javaClass.getName();
        this.javaClass = javaClass;
    }

    public String getClassName() {
        return this.className;
    }

    public Class<?> getJavaClass() {
        if (this.javaClass == null) {
            this.javaClass = ReflectionUtils.loadClass(this.className).orElseThrow(() -> new PreconditionViolationException("Could not load class with name: " + this.className));
        }
        return this.javaClass;
    }

    public String toString() {
        return new ToStringBuilder(this).append("className", this.className).toString();
    }
}

