/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrIfThenElseImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0014\u001a\u00020\u0015*\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LateinitLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "generateParameterNameInAssertion", "", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Z)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "throwErrorFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "irBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "throwUninitializedPropertyAccessException", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "backingField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "ir.backend.common"})
public final class LateinitLowering
implements FileLoweringPass {
    private final IrSimpleFunction throwErrorFunction;
    @NotNull
    private final CommonBackendContext context;
    private final boolean generateParameterNameInAssertion;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new IrElementTransformerVoid(this){
            final /* synthetic */ LateinitLowering this$0;

            @NotNull
            public IrStatement visitProperty(@NotNull IrProperty declaration2) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                if (declaration2.isLateinit() && Intrinsics.areEqual((Object)declaration2.getOrigin(), (Object)IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE) ^ true) {
                    IrField irField = declaration2.getBackingField();
                    if (irField == null) {
                        Intrinsics.throwNpe();
                    }
                    IrSimpleFunction irSimpleFunction = declaration2.getGetter();
                    if (irSimpleFunction == null) {
                        Intrinsics.throwNpe();
                    }
                    this.transformGetter(irField, irSimpleFunction);
                }
                return declaration2;
            }

            private final void transformGetter(IrField backingField2, IrFunction getter2) {
                IrGetValueImpl irGetValueImpl;
                DeclarationIrBuilder irBuilder;
                DeclarationIrBuilder declarationIrBuilder;
                boolean bl;
                IrType type2 = backingField2.getType();
                boolean bl2 = bl = !IrTypePredicatesKt.isPrimitiveType(type2);
                if (_Assertions.ENABLED && !bl) {
                    String string = "'lateinit' modifier is not allowed on primitive types";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                int startOffset = getter2.getStartOffset();
                int endOffset = getter2.getEndOffset();
                DeclarationIrBuilder $receiver = declarationIrBuilder = (irBuilder = LowerUtilsKt.createIrBuilder(this.this$0.getContext(), getter2.getSymbol(), startOffset, endOffset));
                IrBlock block = LateinitLowering.access$irBlock(this.this$0, $receiver, type2);
                Scope scope2 = $receiver.getScope();
                IrBuilderWithScope irBuilderWithScope = $receiver;
                IrValueParameter irValueParameter = getter2.getDispatchReceiverParameter();
                if (irValueParameter != null) {
                    IrValueParameter irValueParameter2 = irValueParameter;
                    IrBuilderWithScope irBuilderWithScope2 = irBuilderWithScope;
                    Scope scope3 = scope2;
                    IrValueParameter it = irValueParameter2;
                    IrGetValueImpl irGetValueImpl2 = ExpressionHelpersKt.irGet($receiver, it);
                    scope2 = scope3;
                    irBuilderWithScope = irBuilderWithScope2;
                    irGetValueImpl = irGetValueImpl2;
                } else {
                    irGetValueImpl = null;
                }
                IrVariable resultVar = Scope.createTemporaryVariable$default(scope2, ExpressionHelpersKt.irGetField(irBuilderWithScope, irGetValueImpl, backingField2), null, false, null, null, 30, null);
                block.getStatements().add(resultVar);
                IrIfThenElseImpl throwIfNull = ExpressionHelpersKt.irIfThenElse($receiver, $receiver.getContext().getIrBuiltIns().getNothingType(), ExpressionHelpersKt.irNotEquals($receiver, ExpressionHelpersKt.irGet($receiver, resultVar), ExpressionHelpersKt.irNull($receiver)), ExpressionHelpersKt.irReturn($receiver, ExpressionHelpersKt.irGet($receiver, resultVar)), LateinitLowering.access$throwUninitializedPropertyAccessException(this.this$0, $receiver, backingField2));
                block.getStatements().add(throwIfNull);
                getter2.setBody(new IrExpressionBodyImpl(startOffset, endOffset, block));
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final IrCall throwUninitializedPropertyAccessException(@NotNull IrBuilderWithScope $receiver, IrField backingField2) {
        IrCall irCall;
        IrCall $receiver2 = irCall = ExpressionHelpersKt.irCall($receiver, this.throwErrorFunction);
        if (this.generateParameterNameInAssertion) {
            IrType irType = $receiver.getContext().getIrBuiltIns().getStringType();
            String string = backingField2.getName().asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"backingField.name.asString()");
            $receiver2.putValueArgument(0, IrConstImpl.Companion.string(-1, -1, irType, string));
        }
        return irCall;
    }

    private final IrBlock irBlock(@NotNull IrBuilderWithScope $receiver, IrType type2) {
        return new IrBlockImpl($receiver.getStartOffset(), $receiver.getEndOffset(), type2, null, 8, null);
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    public LateinitLowering(@NotNull CommonBackendContext context, boolean generateParameterNameInAssertion) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.generateParameterNameInAssertion = generateParameterNameInAssertion;
        this.throwErrorFunction = (IrSimpleFunction)this.context.getIr().getSymbols().getThrowUninitializedPropertyAccessException().getOwner();
    }

    public /* synthetic */ LateinitLowering(CommonBackendContext commonBackendContext, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(commonBackendContext, bl);
    }

    @NotNull
    public static final /* synthetic */ IrBlock access$irBlock(LateinitLowering $this, @NotNull IrBuilderWithScope $receiver, @NotNull IrType type2) {
        return $this.irBlock($receiver, type2);
    }

    @NotNull
    public static final /* synthetic */ IrCall access$throwUninitializedPropertyAccessException(LateinitLowering $this, @NotNull IrBuilderWithScope $receiver, @NotNull IrField backingField2) {
        return $this.throwUninitializedPropertyAccessException($receiver, backingField2);
    }
}

