/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.impl.IrFieldImpl;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrFieldSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J(\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001eH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ObjectClassLowering;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "pendingTransformations", "", "Lkotlin/Function0;", "", "createFieldWithCustomInitializer", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "fieldSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFieldSymbol;", "instanceInitializer", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "instanceOwner", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationContainer;", "objectType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "createInstanceFieldWithInitializer", "constructor", "Lorg/jetbrains/kotlin/descriptors/ClassConstructorDescriptor;", "lower", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "process", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitClassNew", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "backend"})
public final class ObjectClassLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    private List<Function0<Unit>> pendingTransformations;
    @NotNull
    private final JvmBackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        irFile.accept(this, null);
        Iterable $receiver$iv = this.pendingTransformations;
        for (Object element$iv : $receiver$iv) {
            Function0 it = (Function0)element$iv;
            it.invoke();
        }
    }

    @Override
    @NotNull
    public IrStatement visitClassNew(@NotNull IrClass declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        this.process(declaration2);
        return super.visitClassNew(declaration2);
    }

    private final void process(IrClass irClass) {
        IrDeclarationContainer publicInstanceOwner;
        IrDeclarationContainer irDeclarationContainer;
        if (!IrUtilsKt.isObject(irClass)) {
            return;
        }
        IrField publicInstanceField = this.context.getDeclarationFactory().getFieldForObjectInstance(irClass);
        ClassConstructorDescriptor classConstructorDescriptor = irClass.getDescriptor().getUnsubstitutedPrimaryConstructor();
        if (classConstructorDescriptor == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Object should have a primary constructor: " + irClass.getDescriptor())));
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)classConstructorDescriptor, (String)"irClass.descriptor.unsub\u2026: ${irClass.descriptor}\")");
        ClassConstructorDescriptor constructor2 = classConstructorDescriptor;
        if (irClass.getDescriptor().isCompanionObject()) {
            ScopeWithIr scopeWithIr = this.getParentScope();
            if (scopeWithIr == null) {
                Intrinsics.throwNpe();
            }
            IrElement irElement = scopeWithIr.getIrElement();
            if (irElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer");
            }
            irDeclarationContainer = (IrDeclarationContainer)((Object)irElement);
        } else {
            irDeclarationContainer = publicInstanceOwner = (IrDeclarationContainer)irClass;
        }
        if (JvmCodegenUtil.isCompanionObjectInInterfaceNotIntrinsic(irClass.getDescriptor())) {
            CallableMemberDescriptor callableMemberDescriptor = publicInstanceField.getDescriptor().copy(irClass.getDescriptor(), Modality.FINAL, Visibilities.PROTECTED, CallableMemberDescriptor.Kind.SYNTHESIZED, false);
            if (callableMemberDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyDescriptor");
            }
            PropertyDescriptor privateInstance = (PropertyDescriptor)callableMemberDescriptor;
            privateInstance.getName();
            IrField field2 = this.createInstanceFieldWithInitializer(new IrFieldSymbolImpl(privateInstance), constructor2, irClass, IrUtilsKt.getDefaultType(irClass));
            publicInstanceField.setInitializer(new IrExpressionBodyImpl(new IrGetFieldImpl(-1, -1, (IrFieldSymbol)field2.getSymbol(), IrUtilsKt.getDefaultType(irClass), null, null, 48, null)));
        } else {
            IrCallImpl constructorCall = new IrCallImpl(-1, -1, IrUtilsKt.getDefaultType(irClass), constructor2, 0, null, null, 96, null);
            publicInstanceField.setInitializer(new IrExpressionBodyImpl(constructorCall));
        }
        publicInstanceField.setParent(publicInstanceOwner);
        this.pendingTransformations.add(new Function0<Unit>(publicInstanceOwner, publicInstanceField){
            final /* synthetic */ IrDeclarationContainer $publicInstanceOwner;
            final /* synthetic */ IrField $publicInstanceField;

            public final void invoke() {
                this.$publicInstanceOwner.getDeclarations().add(this.$publicInstanceField);
            }
            {
                this.$publicInstanceOwner = irDeclarationContainer;
                this.$publicInstanceField = irField;
                super(0);
            }
        });
    }

    private final IrField createInstanceFieldWithInitializer(IrFieldSymbol fieldSymbol, ClassConstructorDescriptor constructor2, IrDeclarationContainer instanceOwner, IrType objectType) {
        return this.createFieldWithCustomInitializer(fieldSymbol, new IrCallImpl(-1, -1, objectType, constructor2, 0, null, null, 96, null), instanceOwner, objectType);
    }

    private final IrField createFieldWithCustomInitializer(IrFieldSymbol fieldSymbol, IrExpression instanceInitializer, IrDeclarationContainer instanceOwner, IrType objectType) {
        IrFieldImpl irFieldImpl;
        IrFieldImpl it = irFieldImpl = new IrFieldImpl(-1, -1, (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.FIELD_FOR_OBJECT_INSTANCE.INSTANCE, fieldSymbol, objectType);
        it.setInitializer(new IrExpressionBodyImpl(instanceInitializer));
        it.setParent(instanceOwner);
        this.pendingTransformations.add(new Function0<Unit>(it, this, instanceInitializer, instanceOwner){
            final /* synthetic */ IrFieldImpl $it;
            final /* synthetic */ ObjectClassLowering this$0;
            final /* synthetic */ IrExpression $instanceInitializer$inlined;
            final /* synthetic */ IrDeclarationContainer $instanceOwner$inlined;
            {
                this.$it = irFieldImpl;
                this.this$0 = objectClassLowering;
                this.$instanceInitializer$inlined = irExpression;
                this.$instanceOwner$inlined = irDeclarationContainer;
                super(0);
            }

            public final void invoke() {
                this.$instanceOwner$inlined.getDeclarations().add(this.$it);
            }
        });
        return irFieldImpl;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public ObjectClassLowering(@NotNull JvmBackendContext context) {
        List list2;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        ObjectClassLowering objectClassLowering = this;
        objectClassLowering.pendingTransformations = list2 = (List)new ArrayList();
    }
}

