/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.CompanionObjectMapping;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.org.objectweb.asm.Type;

public class FieldInfo {
    private final Type fieldType;
    private final KotlinType fieldKotlinType;
    private final Type ownerType;
    private final String fieldName;
    private final boolean isStatic;

    @NotNull
    public static FieldInfo createForSingleton(@NotNull ClassDescriptor classDescriptor2, @NotNull KotlinTypeMapper typeMapper) {
        if (!classDescriptor2.getKind().isSingleton() || DescriptorUtils.isEnumEntry(classDescriptor2)) {
            throw new UnsupportedOperationException("Can't create singleton field for class: " + classDescriptor2);
        }
        if (DescriptorUtils.isNonCompanionObject(classDescriptor2) || CompanionObjectMapping.INSTANCE.isMappedIntrinsicCompanionObject(classDescriptor2)) {
            return FieldInfo.createSingletonViaInstance(classDescriptor2, typeMapper, "INSTANCE");
        }
        ClassDescriptor ownerDescriptor = DescriptorUtils.getParentOfType(classDescriptor2, ClassDescriptor.class);
        assert (ownerDescriptor != null) : "Owner not found for class: " + classDescriptor2;
        Type ownerType = typeMapper.mapClass(ownerDescriptor);
        SimpleType fieldKotlinType = classDescriptor2.getDefaultType();
        Type fieldType = typeMapper.mapType(fieldKotlinType);
        return new FieldInfo(ownerType, fieldType, fieldKotlinType, classDescriptor2.getName().asString(), true);
    }

    @NotNull
    public static FieldInfo createSingletonViaInstance(@NotNull ClassDescriptor classDescriptor2, @NotNull KotlinTypeMapper typeMapper, @NotNull String name2) {
        Type owner = typeMapper.mapClass(classDescriptor2);
        SimpleType fieldKotlinType = classDescriptor2.getDefaultType();
        Type fieldType = typeMapper.mapType(fieldKotlinType);
        return new FieldInfo(owner, fieldType, fieldKotlinType, name2, true);
    }

    @NotNull
    public static FieldInfo createForHiddenField(@NotNull Type owner, @NotNull Type fieldType, @NotNull String fieldName) {
        return FieldInfo.createForHiddenField(owner, fieldType, null, fieldName);
    }

    @NotNull
    public static FieldInfo createForHiddenField(@NotNull Type owner, @NotNull Type fieldType, @Nullable KotlinType fieldKotlinType, @NotNull String fieldName) {
        return new FieldInfo(owner, fieldType, fieldKotlinType, fieldName, false);
    }

    private FieldInfo(@NotNull Type ownerType, @NotNull Type fieldType, @Nullable KotlinType fieldKotlinType, @NotNull String fieldName, boolean isStatic) {
        this.ownerType = ownerType;
        this.fieldType = fieldType;
        this.fieldKotlinType = fieldKotlinType;
        this.fieldName = fieldName;
        this.isStatic = isStatic;
    }

    @NotNull
    public Type getFieldType() {
        return this.fieldType;
    }

    @Nullable
    public KotlinType getFieldKotlinType() {
        return this.fieldKotlinType;
    }

    @NotNull
    public Type getOwnerType() {
        return this.ownerType;
    }

    @NotNull
    public String getOwnerInternalName() {
        return this.ownerType.getInternalName();
    }

    @NotNull
    public String getFieldName() {
        return this.fieldName;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public String toString() {
        return String.format("%s %s.%s : %s", this.isStatic ? "GETSTATIC" : "GETFIELD", this.ownerType.getInternalName(), this.fieldName, this.fieldType);
    }
}

