/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactoryWithPsiElement;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;

public abstract class AbstractDiagnostic<E extends PsiElement>
implements ParametrizedDiagnostic<E> {
    private final E psiElement;
    private final DiagnosticFactoryWithPsiElement<E, ?> factory;
    private final Severity severity;

    public AbstractDiagnostic(@NotNull E psiElement2, @NotNull DiagnosticFactoryWithPsiElement<E, ?> factory2, @NotNull Severity severity) {
        this.psiElement = psiElement2;
        this.factory = factory2;
        this.severity = severity;
    }

    @NotNull
    public DiagnosticFactoryWithPsiElement<E, ?> getFactory() {
        return this.factory;
    }

    @Override
    @NotNull
    public PsiFile getPsiFile() {
        return this.psiElement.getContainingFile();
    }

    @Override
    @NotNull
    public Severity getSeverity() {
        return this.severity;
    }

    @Override
    @NotNull
    public E getPsiElement() {
        return this.psiElement;
    }

    @Override
    @NotNull
    public List<TextRange> getTextRanges() {
        return ((DiagnosticFactoryWithPsiElement)this.getFactory()).getTextRanges(this);
    }

    @Override
    public boolean isValid() {
        return ((DiagnosticFactoryWithPsiElement)this.getFactory()).isValid(this);
    }
}

