/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions.generate;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.actions.generate.KotlinGenerateEqualsAndHashcodeAction;
import org.jetbrains.kotlin.idea.actions.generate.KotlinGenerateEqualsAndHashcodeActionKt;
import org.jetbrains.kotlin.idea.actions.generate.KotlinGenerateEqualsWizard;
import org.jetbrains.kotlin.idea.actions.generate.KotlinGenerateMemberActionBase;
import org.jetbrains.kotlin.idea.actions.generate.UtilsKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.core.CollectingNameValidator;
import org.jetbrains.kotlin.idea.core.GenerateUtilKt;
import org.jetbrains.kotlin.idea.core.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.js.resolve.JsPlatform;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002&'B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002J(\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\"\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\"\u0010\u0018\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0017\u001a\u00020\u0002H\u0014J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u001f\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010 \u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020!H\u0002J$\u0010\"\u001a\u0004\u0018\u00010\u00022\u0006\u0010#\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0014J\f\u0010$\u001a\u00020\t*\u00020%H\u0002\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/idea/actions/generate/KotlinGenerateEqualsAndHashcodeAction;", "Lorg/jetbrains/kotlin/idea/actions/generate/KotlinGenerateMemberActionBase;", "Lorg/jetbrains/kotlin/idea/actions/generate/KotlinGenerateEqualsAndHashcodeAction$Info;", "()V", "generateArrayHashCodeCall", "", "variable", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "canUseContentFunctions", "", "argument", "generateArraysEqualsCall", "arg1", "arg2", "generateClassLiteral", "targetClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "generateClassLiteralsNotEqual", "paramName", "generateEquals", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "project", "Lcom/intellij/openapi/project/Project;", "info", "generateHashCode", "generateMembers", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isNestedArray", "isValidForClass", "isValidForDataClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "prepareMembersInfo", "klass", "canUseArrayContentFunctions", "Lorg/jetbrains/kotlin/psi/KtElement;", "Companion", "Info", "idea"})
public final class KotlinGenerateEqualsAndHashcodeAction
extends KotlinGenerateMemberActionBase<Info> {
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    protected boolean isValidForClass(@NotNull KtClassOrObject targetClass) {
        Intrinsics.checkParameterIsNotNull((Object)targetClass, (String)"targetClass");
        return targetClass instanceof KtClass && !(targetClass instanceof KtEnumEntry) && !((KtClass)targetClass).isEnum() && !targetClass.isAnnotation() && !((KtClass)targetClass).isInterface() && (!((KtClass)targetClass).isData() || this.isValidForDataClass((KtClass)targetClass));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValidForDataClass(KtClass targetClass) {
        boolean bl;
        KtPrimaryConstructor ktPrimaryConstructor = targetClass.getPrimaryConstructor();
        if (ktPrimaryConstructor == null) return false;
        KtPrimaryConstructor constructor2 = ktPrimaryConstructor;
        BindingContext context = ResolutionUtils.analyze(constructor2, BodyResolveMode.PARTIAL);
        Iterable $receiver$iv = constructor2.getValueParameters();
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            KtParameter parameter = (KtParameter)element$iv;
            if (parameter.hasValOrVar()) {
                boolean bl2;
                ReadOnlySlice readOnlySlice = BindingContext.TYPE;
                KtParameter ktParameter = parameter;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"parameter");
                if ((KotlinType)context.get(readOnlySlice, ktParameter.getTypeReference()) != null) {
                    KotlinType kotlinType;
                    KotlinType type2 = kotlinType;
                    if (KotlinBuiltIns.isArray(type2)) return true;
                    if (KotlinBuiltIns.isPrimitiveArray(type2)) {
                        return true;
                    }
                    bl2 = false;
                } else {
                    bl2 = false;
                }
                if (bl2) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected Info prepareMembersInfo(@NotNull KtClassOrObject klass2, @NotNull Project project, @Nullable Editor editor) {
        Object object;
        KtNamedDeclaration it;
        Collection<VariableDescriptor> collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        List<KtNamedDeclaration> properties2;
        void needHashCode;
        void needEquals;
        ClassDescriptor classDescriptor2;
        BindingContext context;
        block17: {
            void $receiver$iv$iv2;
            Iterable $receiver$iv2;
            block16: {
                Intrinsics.checkParameterIsNotNull((Object)klass2, (String)"klass");
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                if (!(klass2 instanceof KtClass)) {
                    throw (Throwable)((Object)new AssertionError((Object)("Not a class: " + PsiUtilsKt.getElementTextWithContext(klass2))));
                }
                context = ResolutionUtils.analyzeWithContent(klass2);
                ClassDescriptor classDescriptor3 = (ClassDescriptor)context.get(BindingContext.CLASS, klass2);
                if (classDescriptor3 == null) {
                    return null;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor3, (String)"context.get(BindingConte\u2026SS, klass) ?: return null");
                classDescriptor2 = classDescriptor3;
                FunctionDescriptor equalsDescriptor = KotlinGenerateEqualsAndHashcodeActionKt.findDeclaredEquals(classDescriptor2, false);
                FunctionDescriptor hashCodeDescriptor = KotlinGenerateEqualsAndHashcodeActionKt.findDeclaredHashCode(classDescriptor2, false);
                Ref.BooleanRef booleanRef = new Ref.BooleanRef();
                booleanRef.element = equalsDescriptor == null;
                Ref.BooleanRef booleanRef2 = new Ref.BooleanRef();
                boolean bl = booleanRef2.element = hashCodeDescriptor == null;
                if (!needEquals.element && !needHashCode.element) {
                    KtClass ktClass2 = (KtClass)klass2;
                    FunctionDescriptor[] functionDescriptorArray = new FunctionDescriptor[2];
                    FunctionDescriptor functionDescriptor2 = equalsDescriptor;
                    if (functionDescriptor2 == null) {
                        Intrinsics.throwNpe();
                    }
                    functionDescriptorArray[0] = functionDescriptor2;
                    FunctionDescriptor functionDescriptor3 = hashCodeDescriptor;
                    if (functionDescriptor3 == null) {
                        Intrinsics.throwNpe();
                    }
                    functionDescriptorArray[1] = functionDescriptor3;
                    if (!UtilsKt.confirmMemberRewrite(ktClass2, functionDescriptorArray)) {
                        return null;
                    }
                    ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(equalsDescriptor, hashCodeDescriptor, (Ref.BooleanRef)needEquals, (Ref.BooleanRef)needHashCode){
                        final /* synthetic */ FunctionDescriptor $equalsDescriptor;
                        final /* synthetic */ FunctionDescriptor $hashCodeDescriptor;
                        final /* synthetic */ Ref.BooleanRef $needEquals;
                        final /* synthetic */ Ref.BooleanRef $needHashCode;

                        public final void invoke() {
                            try {
                                SourceElement sourceElement = this.$equalsDescriptor.getSource();
                                Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"equalsDescriptor.source");
                                PsiElement psiElement2 = KotlinSourceElementKt.getPsi(sourceElement);
                                if (psiElement2 != null) {
                                    psiElement2.delete();
                                }
                                SourceElement sourceElement2 = this.$hashCodeDescriptor.getSource();
                                Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement2, (String)"hashCodeDescriptor.source");
                                PsiElement psiElement3 = KotlinSourceElementKt.getPsi(sourceElement2);
                                if (psiElement3 != null) {
                                    psiElement3.delete();
                                }
                                this.$needEquals.element = true;
                                this.$needHashCode.element = true;
                            }
                            catch (IncorrectOperationException e) {
                                KotlinGenerateEqualsAndHashcodeAction.access$getLOG$cp().error((Throwable)e);
                            }
                        }
                        {
                            this.$equalsDescriptor = functionDescriptor2;
                            this.$hashCodeDescriptor = functionDescriptor3;
                            this.$needEquals = booleanRef;
                            this.$needHashCode = booleanRef2;
                            super(0);
                        }
                    });
                }
                if ((properties2 = UtilsKt.getPropertiesToUseInGeneratedMember(klass2)).isEmpty()) break block16;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (!application.isUnitTestMode()) break block17;
            }
            Iterable iterable = $receiver$iv2 = (Iterable)properties2;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void it2;
                KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                DeclarationDescriptor declarationDescriptor = context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, it2);
                if (declarationDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.VariableDescriptor");
                }
                VariableDescriptor variableDescriptor = (VariableDescriptor)declarationDescriptor;
                collection2.add(variableDescriptor);
            }
            List descriptors2 = (List)destination$iv$iv;
            return new Info(needEquals.element, needHashCode.element, classDescriptor2, descriptors2, descriptors2);
        }
        KotlinGenerateEqualsWizard kotlinGenerateEqualsWizard = new KotlinGenerateEqualsWizard(project, (KtClass)klass2, properties2, needEquals.element, needHashCode.element);
        KotlinGenerateEqualsWizard $receiver = kotlinGenerateEqualsWizard;
        if (!$receiver.showAndGet()) {
            return null;
        }
        Iterable $receiver$iv$iv2 = $receiver.getPropertiesForEquals();
        ClassDescriptor classDescriptor4 = classDescriptor2;
        boolean bl = needHashCode.element;
        boolean bl2 = needEquals.element;
        void $i$f$mapTo = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)item$iv$iv;
            collection = destination$iv$iv;
            DeclarationDescriptor declarationDescriptor = context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, it);
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.VariableDescriptor");
            }
            object = (VariableDescriptor)declarationDescriptor;
            collection.add((VariableDescriptor)object);
        }
        collection = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv = (Iterable)$receiver.getPropertiesForHashCode();
        destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (KtNamedDeclaration)item$iv$iv;
            object = destination$iv$iv;
            DeclarationDescriptor declarationDescriptor = context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, it);
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.VariableDescriptor");
            }
            VariableDescriptor variableDescriptor = (VariableDescriptor)declarationDescriptor;
            object.add(variableDescriptor);
        }
        Object object2 = object = (List)destination$iv$iv;
        Collection<VariableDescriptor> collection3 = collection;
        ClassDescriptor classDescriptor5 = classDescriptor4;
        boolean bl3 = bl;
        boolean bl4 = bl2;
        return new Info(bl4, bl3, classDescriptor5, (List<? extends VariableDescriptor>)collection3, (List<? extends VariableDescriptor>)object2);
    }

    private final String generateClassLiteralsNotEqual(String paramName, KtClassOrObject targetClass) {
        String defaultExpression = "javaClass != " + paramName + "?.javaClass";
        if (!PlatformKt.getLanguageVersionSettings(targetClass).supportsFeature(LanguageFeature.BoundCallableReferences)) {
            return defaultExpression;
        }
        TargetPlatform targetPlatform = PlatformKt.getPlatform(targetClass);
        return targetPlatform instanceof JsPlatform ? "other == null || this::class.js != " + paramName + "::class.js" : (targetPlatform instanceof TargetPlatform.Common ? "other == null || this::class != " + paramName + "::class" : defaultExpression);
    }

    private final String generateClassLiteral(KtClassOrObject targetClass) {
        String defaultExpression = "javaClass";
        if (!PlatformKt.getLanguageVersionSettings(targetClass).supportsFeature(LanguageFeature.BoundCallableReferences)) {
            return defaultExpression;
        }
        TargetPlatform targetPlatform = PlatformKt.getPlatform(targetClass);
        return targetPlatform instanceof JsPlatform ? "this::class.js" : (targetPlatform instanceof TargetPlatform.Common ? "this::class" : defaultExpression);
    }

    private final boolean isNestedArray(VariableDescriptor variable2) {
        return KotlinBuiltIns.isArrayOrPrimitiveArray(DescriptorUtilsKt.getBuiltIns(variable2).getArrayElementType(variable2.getType()));
    }

    private final boolean canUseArrayContentFunctions(@NotNull KtElement $receiver) {
        return PlatformKt.getLanguageVersionSettings($receiver).getApiVersion().compareTo(ApiVersion.KOTLIN_1_1) >= 0;
    }

    private final String generateArraysEqualsCall(VariableDescriptor variable2, boolean canUseContentFunctions, String arg1, String arg2) {
        String string;
        if (canUseContentFunctions) {
            String methodName = this.isNestedArray(variable2) ? "contentDeepEquals" : "contentEquals";
            string = arg1 + '.' + methodName + '(' + arg2 + ')';
        } else {
            String methodName = this.isNestedArray(variable2) ? "deepEquals" : "equals";
            string = "java.util.Arrays." + methodName + '(' + arg1 + ", " + arg2 + ')';
        }
        return string;
    }

    private final String generateArrayHashCodeCall(VariableDescriptor variable2, boolean canUseContentFunctions, String argument2) {
        String string;
        if (canUseContentFunctions) {
            String methodName = this.isNestedArray(variable2) ? "contentDeepHashCode" : "contentHashCode";
            String dot = TypeUtils.isNullableType(variable2.getType()) ? "?." : ".";
            string = argument2 + dot + methodName + "()";
        } else {
            String methodName = this.isNestedArray(variable2) ? "deepHashCode" : "hashCode";
            string = "java.util.Arrays." + methodName + '(' + argument2 + ')';
        }
        return string;
    }

    private final KtNamedFunction generateEquals(Project project, Info info, KtClassOrObject targetClass) {
        Collection collection;
        StringBuilder stringBuilder;
        boolean useIsCheck;
        Info $receiver = info;
        if (!$receiver.getNeedEquals()) {
            return null;
        }
        FunctionDescriptor functionDescriptor2 = KotlinGenerateEqualsAndHashcodeActionKt.findDeclaredEquals(DescriptorUtilsKt.getSuperClassOrAny($receiver.getClassDescriptor()), true);
        if (functionDescriptor2 == null) {
            Intrinsics.throwNpe();
        }
        FunctionDescriptor superEquals = functionDescriptor2;
        KtNamedFunction equalsFun = UtilsKt.generateFunctionSkeleton(superEquals, targetClass);
        List<KtParameter> list2 = equalsFun.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"equalsFun.valueParameters");
        Object object = kotlin.collections.CollectionsKt.first(list2);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"equalsFun.valueParameters.first()");
        String string = ((KtParameter)object).getName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"equalsFun.valueParameters.first().name!!");
        String paramName = KtPsiUtilKt.quoteIfNeeded(string);
        String typeForCast = IdeDescriptorRenderers.SOURCE_CODE.renderClassifierName($receiver.getClassDescriptor());
        List<TypeParameterDescriptor> list3 = $receiver.getClassDescriptor().getDeclaredTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"classDescriptor.declaredTypeParameters");
        List<TypeParameterDescriptor> typeParams = list3;
        Collection collection2 = typeParams;
        if (!collection2.isEmpty()) {
            typeForCast = typeForCast + kotlin.collections.CollectionsKt.joinToString$default((Iterable)typeParams, null, (CharSequence)"<", (CharSequence)">", (int)0, null, (Function1)generateEquals.1.1.INSTANCE, (int)25, null);
        }
        String isNotInstanceCondition = (useIsCheck = CodeInsightSettings.getInstance().USE_INSTANCEOF_ON_EQUALS_PARAMETER) ? paramName + " !is " + typeForCast : this.generateClassLiteralsNotEqual(paramName, targetClass);
        StringBuilder $receiver2 = stringBuilder = new StringBuilder();
        $receiver2.append("if (this === " + paramName + ") return true\n");
        $receiver2.append("if (" + isNotInstanceCondition + ") return false\n");
        KotlinBuiltIns builtIns = DescriptorUtilsKt.getBuiltIns(superEquals);
        if (!builtIns.isMemberOfAny(superEquals)) {
            $receiver2.append("if (!super.equals(" + paramName + ")) return false\n");
        }
        if (!(collection = (Collection)$receiver.getVariablesForEquals()).isEmpty()) {
            if (!useIsCheck) {
                $receiver2.append('\n' + paramName + " as " + typeForCast + '\n');
            }
            $receiver2.append('\n');
            Iterable $receiver$iv = $receiver.getVariablesForEquals();
            for (Object element$iv : $receiver$iv) {
                String string2;
                VariableDescriptor it = (VariableDescriptor)element$iv;
                boolean isNullable2 = TypeUtils.isNullableType(it.getType());
                boolean isArray = KotlinBuiltIns.isArrayOrPrimitiveArray(it.getType());
                boolean canUseArrayContentFunctions = this.canUseArrayContentFunctions(targetClass);
                PsiElement psiElement2 = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project, it);
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiNameIdentifierOwner");
                }
                PsiElement psiElement3 = ((PsiNameIdentifierOwner)psiElement2).getNameIdentifier();
                if (psiElement3 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"(DescriptorToSourceUtils\u2026erOwner).nameIdentifier!!");
                String propName = psiElement3.getText();
                if (isArray) {
                    StringBuilder stringBuilder2 = new StringBuilder().append('!');
                    String string3 = propName;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"propName");
                    string2 = stringBuilder2.append(this.generateArraysEqualsCall(it, canUseArrayContentFunctions, string3, paramName + '.' + propName)).toString();
                } else {
                    string2 = propName + " != " + paramName + '.' + propName;
                }
                String notEquals = string2;
                String equalsCheck = "if (" + notEquals + ") return false\n";
                if (isArray && isNullable2 && canUseArrayContentFunctions) {
                    $receiver2.append("if (" + propName + " != null) {\n");
                    $receiver2.append("if (" + paramName + '.' + propName + " == null) return false\n");
                    $receiver2.append(equalsCheck);
                    $receiver2.append("} else if (" + paramName + '.' + propName + " != null) return false\n");
                    continue;
                }
                $receiver2.append(equalsCheck);
            }
            $receiver2.append('\n');
        }
        $receiver2.append("return true");
        String string4 = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
        String bodyText = string4;
        KtExpression ktExpression = equalsFun.getBodyExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        ktExpression.replace((PsiElement)new KtPsiFactory(project, false, 2, null).createBlock(bodyText));
        return equalsFun;
    }

    /*
     * WARNING - void declaration
     */
    private final KtNamedFunction generateHashCode(Project project, Info info, KtClassOrObject targetClass) {
        String string;
        String initialValue;
        Function2<VariableDescriptor, Boolean, String> genVariableHashCode$ = new Function2<VariableDescriptor, Boolean, String>(this, project, targetClass){
            final /* synthetic */ KotlinGenerateEqualsAndHashcodeAction this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ KtClassOrObject $targetClass;

            @NotNull
            public final String invoke(@NotNull VariableDescriptor $receiver, boolean parenthesesNeeded) {
                String text2;
                String string;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                PsiElement psiElement2 = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(this.$project, $receiver);
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiNameIdentifierOwner");
                }
                PsiElement psiElement3 = ((PsiNameIdentifierOwner)psiElement2).getNameIdentifier();
                if (psiElement3 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"(DescriptorToSourceUtils\u2026erOwner).nameIdentifier!!");
                String ref = psiElement3.getText();
                boolean isNullable2 = TypeUtils.isNullableType($receiver.getType());
                KotlinBuiltIns builtIns = DescriptorUtilsKt.getBuiltIns($receiver);
                ClassifierDescriptor typeClass = $receiver.getType().getConstructor().getDeclarationDescriptor();
                if (Intrinsics.areEqual((Object)typeClass, (Object)builtIns.getByte()) || Intrinsics.areEqual((Object)typeClass, (Object)builtIns.getShort()) || Intrinsics.areEqual((Object)typeClass, (Object)builtIns.getInt())) {
                    string = ref;
                } else if (KotlinBuiltIns.isArrayOrPrimitiveArray($receiver.getType())) {
                    String hashCodeArg;
                    boolean canUseArrayContentFunctions = KotlinGenerateEqualsAndHashcodeAction.access$canUseArrayContentFunctions(this.this$0, this.$targetClass);
                    boolean shouldWrapInLet = isNullable2 && !canUseArrayContentFunctions;
                    String string2 = hashCodeArg = shouldWrapInLet ? "it" : ref;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"hashCodeArg");
                    String hashCodeCall = KotlinGenerateEqualsAndHashcodeAction.access$generateArrayHashCodeCall(this.this$0, $receiver, canUseArrayContentFunctions, string2);
                    string = shouldWrapInLet ? ref + "?.let { " + hashCodeCall + " }" : hashCodeCall;
                } else {
                    string = text2 = isNullable2 ? ref + "?.hashCode()" : ref + ".hashCode()";
                }
                if (isNullable2) {
                    text2 = text2 + " ?: 0";
                    if (parenthesesNeeded) {
                        text2 = '(' + text2 + ')';
                    }
                }
                String string3 = text2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"text");
                return string3;
            }
            {
                this.this$0 = kotlinGenerateEqualsAndHashcodeAction;
                this.$project = project;
                this.$targetClass = ktClassOrObject;
                super(2);
            }
        };
        Info $receiver = info;
        if (!$receiver.getNeedHashCode()) {
            return null;
        }
        FunctionDescriptor functionDescriptor2 = KotlinGenerateEqualsAndHashcodeActionKt.findDeclaredHashCode(DescriptorUtilsKt.getSuperClassOrAny($receiver.getClassDescriptor()), true);
        if (functionDescriptor2 == null) {
            Intrinsics.throwNpe();
        }
        FunctionDescriptor superHashCode = functionDescriptor2;
        KtNamedFunction hashCodeFun = UtilsKt.generateFunctionSkeleton(superHashCode, targetClass);
        KotlinBuiltIns builtins = DescriptorUtilsKt.getBuiltIns(superHashCode);
        Iterator<VariableDescriptor> propertyIterator = $receiver.getVariablesForHashCode().iterator();
        String string2 = !builtins.isMemberOfAny(superHashCode) ? "super.hashCode()" : (initialValue = propertyIterator.hasNext() ? genVariableHashCode$.invoke(propertyIterator.next(), false) : this.generateClassLiteral(targetClass) + ".hashCode()");
        if (propertyIterator.hasNext()) {
            Iterator<VariableDescriptor> $receiver$iv;
            Collection<String> collection;
            Object object;
            void $receiver$iv$iv;
            Iterable $receiver$iv2 = $receiver.getVariablesForEquals();
            Object object2 = $receiver$iv2;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                object = (VariableDescriptor)item$iv$iv;
                collection = destination$iv$iv;
                String string3 = it.getName().asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it.name.asString()");
                String string4 = KtPsiUtilKt.quoteIfNeeded(string3);
                collection.add(string4);
            }
            collection = (List)destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 2;
            Function1 function1 = null;
            Collection collection2 = collection;
            CollectingNameValidator validator2 = new CollectingNameValidator(collection2, function1, n, defaultConstructorMarker);
            String resultVarName = KotlinNameSuggester.INSTANCE.suggestNameByName("result", (Function1<? super String, Boolean>)((Function1)validator2));
            Object $receiver2 = object2 = new StringBuilder();
            ((StringBuilder)$receiver2).append("var " + resultVarName + " = " + initialValue + '\n');
            Iterator<VariableDescriptor> iterator2 = $receiver$iv = propertyIterator;
            object = iterator2;
            while (object.hasNext()) {
                Object element$iv = object.next();
                VariableDescriptor it = (VariableDescriptor)element$iv;
                ((StringBuilder)$receiver2).append(resultVarName + " = 31 * " + resultVarName + " + " + genVariableHashCode$.invoke(it, true) + '\n');
            }
            ((StringBuilder)$receiver2).append("return " + resultVarName);
            string = ((StringBuilder)object2).toString();
        } else {
            string = "return " + initialValue;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"if (propertyIterator.has\u2026se \"return $initialValue\"");
        String bodyText = string;
        KtExpression ktExpression = hashCodeFun.getBodyExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        ktExpression.replace((PsiElement)new KtPsiFactory(project, false, 2, null).createBlock(bodyText));
        return hashCodeFun;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<KtDeclaration> generateMembers(@NotNull Project project, @Nullable Editor editor, @NotNull Info info) {
        Object v2;
        List<KtDeclaration> $receiver;
        ArrayList prototypes2;
        KtClass targetClass;
        block6: {
            Iterable $receiver$iv;
            List<KtDeclaration> list2;
            ArrayList arrayList;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
            SourceElement sourceElement = info.getClassDescriptor().getSource();
            Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"info.classDescriptor.source");
            PsiElement psiElement2 = KotlinSourceElementKt.getPsi(sourceElement);
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClass");
            }
            targetClass = (KtClass)psiElement2;
            ArrayList $receiver2 = arrayList = new ArrayList(2);
            CollectionsKt.addIfNotNull($receiver2, this.generateEquals(project, info, targetClass));
            CollectionsKt.addIfNotNull($receiver2, this.generateHashCode(project, info, targetClass));
            prototypes2 = arrayList;
            $receiver = list2 = targetClass.getDeclarations();
            Iterable iterable = $receiver$iv = (Iterable)$receiver;
            if (iterable instanceof List) {
                int n = ((Collection)$receiver$iv).size();
                --n;
                boolean bl = false;
                while (n >= 0) {
                    void i$iv;
                    Object element$iv = ((List)$receiver$iv).get((int)i$iv);
                    if (element$iv instanceof KtNamedFunction) {
                        v2 = element$iv;
                        break block6;
                    }
                    --i$iv;
                }
                v2 = null;
            } else {
                Iterable $receiver$iv$iv = kotlin.collections.CollectionsKt.reversed((Iterable)$receiver$iv);
                for (Object element$iv$iv : $receiver$iv$iv) {
                    if (!(element$iv$iv instanceof KtNamedFunction)) continue;
                    v2 = element$iv$iv;
                    break block6;
                }
                v2 = null;
            }
        }
        KtNamedFunction ktNamedFunction = v2;
        KtDeclaration anchor2 = ktNamedFunction != null ? (KtDeclaration)ktNamedFunction : (KtDeclaration)kotlin.collections.CollectionsKt.lastOrNull($receiver);
        return GenerateUtilKt.insertMembersAfter(editor, targetClass, prototypes2, anchor2);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(KotlinGenerateEqualsAndHashcodeAction.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Kotli\u2026shcodeAction::class.java)");
        LOG = logger;
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ boolean access$canUseArrayContentFunctions(KotlinGenerateEqualsAndHashcodeAction $this, @NotNull KtElement $receiver) {
        return $this.canUseArrayContentFunctions($receiver);
    }

    @NotNull
    public static final /* synthetic */ String access$generateArrayHashCodeCall(KotlinGenerateEqualsAndHashcodeAction $this, @NotNull VariableDescriptor variable2, boolean canUseContentFunctions, @NotNull String argument2) {
        return $this.generateArrayHashCodeCall(variable2, canUseContentFunctions, argument2);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/actions/generate/KotlinGenerateEqualsAndHashcodeAction$Info;", "", "needEquals", "", "needHashCode", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "variablesForEquals", "", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "variablesForHashCode", "(ZZLorg/jetbrains/kotlin/descriptors/ClassDescriptor;Ljava/util/List;Ljava/util/List;)V", "getClassDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getNeedEquals", "()Z", "getNeedHashCode", "getVariablesForEquals", "()Ljava/util/List;", "getVariablesForHashCode", "idea"})
    public static final class Info {
        private final boolean needEquals;
        private final boolean needHashCode;
        @NotNull
        private final ClassDescriptor classDescriptor;
        @NotNull
        private final List<VariableDescriptor> variablesForEquals;
        @NotNull
        private final List<VariableDescriptor> variablesForHashCode;

        public final boolean getNeedEquals() {
            return this.needEquals;
        }

        public final boolean getNeedHashCode() {
            return this.needHashCode;
        }

        @NotNull
        public final ClassDescriptor getClassDescriptor() {
            return this.classDescriptor;
        }

        @NotNull
        public final List<VariableDescriptor> getVariablesForEquals() {
            return this.variablesForEquals;
        }

        @NotNull
        public final List<VariableDescriptor> getVariablesForHashCode() {
            return this.variablesForHashCode;
        }

        public Info(boolean needEquals, boolean needHashCode, @NotNull ClassDescriptor classDescriptor2, @NotNull List<? extends VariableDescriptor> variablesForEquals, @NotNull List<? extends VariableDescriptor> variablesForHashCode) {
            Intrinsics.checkParameterIsNotNull((Object)classDescriptor2, (String)"classDescriptor");
            Intrinsics.checkParameterIsNotNull(variablesForEquals, (String)"variablesForEquals");
            Intrinsics.checkParameterIsNotNull(variablesForHashCode, (String)"variablesForHashCode");
            this.needEquals = needEquals;
            this.needHashCode = needHashCode;
            this.classDescriptor = classDescriptor2;
            this.variablesForEquals = variablesForEquals;
            this.variablesForHashCode = variablesForHashCode;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/actions/generate/KotlinGenerateEqualsAndHashcodeAction$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

