/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions.internal;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J!\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ)\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\u001e\u0010\u0015\u001a\u00020\u00062\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\f\u0010\u001e\u001a\u00020\u001a*\u00020\u001fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/actions/internal/FindImplicitNothingAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "allFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "filesOrDirs", "", "([Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/util/Collection;", "allKotlinFiles", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/psi/KtFile;", "project", "Lcom/intellij/openapi/project/Project;", "([Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;)Lkotlin/sequences/Sequence;", "find", "files", "selectedKotlinFiles", "update", "hasExplicitNothing", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isNothingOrNothingFunctionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "idea"})
public final class FindImplicitNothingAction
extends AnAction {
    private final Logger LOG;

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        List selectedFiles = SequencesKt.toList(this.selectedKotlinFiles(e));
        Object object = CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"CommonDataKeys.PROJECT.getData(e.dataContext)!!");
        Project project = (Project)object;
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(this, selectedFiles, project){
            final /* synthetic */ FindImplicitNothingAction this$0;
            final /* synthetic */ List $selectedFiles;
            final /* synthetic */ Project $project;

            public final void run() {
                FindImplicitNothingAction.access$find(this.this$0, this.$selectedFiles, this.$project);
            }
            {
                this.this$0 = findImplicitNothingAction;
                this.$selectedFiles = list2;
                this.$project = project;
            }
        }, "Finding Implicit Nothing's", true, project);
    }

    /*
     * WARNING - void declaration
     */
    private final void find(Collection<? extends KtFile> files2, Project project) {
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
        ProgressIndicator progressIndicator = ApplicationUtilsKt.getProgressIndicatorNullable(progressManager);
        ArrayList found2 = new ArrayList();
        boolean bl = false;
        for (KtFile file : (Iterable)files2) {
            void i2;
            ProgressIndicator progressIndicator2 = progressIndicator;
            if (progressIndicator2 != null) {
                progressIndicator2.setText("Scanning files: " + (int)i2 + " of " + files2.size() + " file. " + found2.size() + " occurences found");
            }
            ProgressIndicator progressIndicator3 = progressIndicator;
            if (progressIndicator3 != null) {
                VirtualFile virtualFile = file.getVirtualFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file.virtualFile");
                progressIndicator3.setText2(virtualFile.getPath());
            }
            ResolutionFacade resolutionFacade = ResolutionUtils.getResolutionFacade(file);
            file.acceptChildren(new KtVisitorVoid(this, resolutionFacade, found2){
                final /* synthetic */ FindImplicitNothingAction this$0;
                final /* synthetic */ ResolutionFacade $resolutionFacade;
                final /* synthetic */ ArrayList $found;

                public void visitKtElement(@NotNull KtElement element3) {
                    Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                    ProgressManager.checkCanceled();
                    element3.acceptChildren(this);
                }

                public void visitCallExpression(@NotNull KtCallExpression expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    expression2.acceptChildren(this);
                    try {
                        BindingContext bindingContext2 = ResolutionFacade.DefaultImpls.analyze$default(this.$resolutionFacade, expression2, null, 2, null);
                        KotlinType kotlinType = bindingContext2.getType(expression2);
                        if (kotlinType == null) {
                            return;
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"bindingContext.getType(expression) ?: return");
                        KotlinType type2 = kotlinType;
                        if (KotlinBuiltIns.isNothing(type2) && !FindImplicitNothingAction.access$hasExplicitNothing(this.this$0, expression2, bindingContext2)) {
                            this.$found.add(expression2);
                        }
                    }
                    catch (ProcessCanceledException e) {
                        throw (Throwable)e;
                    }
                    catch (Throwable t) {
                        FindImplicitNothingAction.access$getLOG$p(this.this$0).error(t);
                    }
                }
                {
                    this.this$0 = $outer;
                    this.$resolutionFacade = $captured_local_variable$1;
                    this.$found = $captured_local_variable$2;
                }
            });
            ProgressIndicator progressIndicator4 = progressIndicator;
            if (progressIndicator4 != null) {
                progressIndicator4.setFraction((double)(i2 + true) / (double)files2.size());
            }
            ++i2;
        }
        SwingUtilities.invokeLater(new Runnable(found2, project, files2){
            final /* synthetic */ ArrayList $found;
            final /* synthetic */ Project $project;
            final /* synthetic */ Collection $files;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                Collection collection = this.$found;
                if (!collection.isEmpty()) {
                    void $receiver$iv$iv;
                    Iterable $receiver$iv;
                    Iterable iterable = $receiver$iv = (Iterable)this.$found;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        void it;
                        KtCallExpression ktCallExpression = (KtCallExpression)item$iv$iv;
                        Collection collection2 = destination$iv$iv;
                        UsageInfo2UsageAdapter usageInfo2UsageAdapter = new UsageInfo2UsageAdapter(new UsageInfo((PsiElement)it));
                        collection2.add(usageInfo2UsageAdapter);
                    }
                    $receiver$iv = (List)destination$iv$iv;
                    Iterable thisCollection$iv = $receiver$iv;
                    UsageInfo2UsageAdapter[] usageInfo2UsageAdapterArray = thisCollection$iv.toArray(new UsageInfo2UsageAdapter[0]);
                    if (usageInfo2UsageAdapterArray == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    UsageInfo2UsageAdapter[] usages2 = usageInfo2UsageAdapterArray;
                    UsageViewPresentation presentation = new UsageViewPresentation();
                    presentation.setTabName("Implicit Nothing's");
                    Intrinsics.checkExpressionValueIsNotNull((Object)UsageViewManager.getInstance((Project)this.$project).showUsages(new UsageTarget[0], (Usage[])usages2, presentation), (String)"UsageViewManager.getInst\u2026(), usages, presentation)");
                } else {
                    Messages.showInfoMessage((Project)this.$project, (String)("Not found in " + this.$files.size() + " file(s)"), (String)"Not Found");
                }
            }
            {
                this.$found = arrayList;
                this.$project = project;
                this.$files = collection;
            }
        });
    }

    private final boolean hasExplicitNothing(@NotNull KtExpression $receiver, BindingContext bindingContext2) {
        KtExpression callee;
        KtExpression ktExpression = CallUtilKt.getCalleeExpressionIfAny($receiver);
        if (ktExpression == null) {
            return false;
        }
        KtExpression ktExpression2 = callee = ktExpression;
        if (ktExpression2 instanceof KtSimpleNameExpression) {
            KtCallableDeclaration declaration2;
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)bindingContext2.get(BindingContext.REFERENCE_TARGET, callee);
            if (declarationDescriptor == null) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"bindingContext[BindingCo\u2026, callee] ?: return false");
            DeclarationDescriptor target = declarationDescriptor;
            DeclarationDescriptor declarationDescriptor2 = target;
            if (!(declarationDescriptor2 instanceof CallableDescriptor)) {
                declarationDescriptor2 = null;
            }
            CallableDescriptor callableDescriptor = (CallableDescriptor)declarationDescriptor2;
            if (callableDescriptor == null) {
                return false;
            }
            CallableDescriptor callableDescriptor2 = callableDescriptor.getOriginal();
            Intrinsics.checkExpressionValueIsNotNull((Object)callableDescriptor2, (String)"(target as? CallableDesc\u2026?: return false).original");
            CallableDescriptor callableDescriptor3 = callableDescriptor2;
            PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(callableDescriptor3);
            if (!(psiElement2 instanceof KtCallableDeclaration)) {
                psiElement2 = null;
            }
            if ((declaration2 = (KtCallableDeclaration)psiElement2) != null && declaration2.getTypeReference() == null) {
                return false;
            }
            KotlinType kotlinType = callableDescriptor3.getReturnType();
            if (kotlinType == null) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"callableDescriptor.returnType ?: return false");
            KotlinType type2 = kotlinType;
            return this.isNothingOrNothingFunctionType(type2);
        }
        return this.hasExplicitNothing(callee, bindingContext2);
    }

    private final boolean isNothingOrNothingFunctionType(@NotNull KotlinType $receiver) {
        return KotlinBuiltIns.isNothing($receiver) || FunctionTypesKt.isFunctionType($receiver) && this.isNothingOrNothingFunctionType(FunctionTypesKt.getReturnTypeFromFunctionType($receiver));
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isInternal()) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            presentation.setVisible(false);
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"e.presentation");
            presentation2.setEnabled(false);
        } else {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            presentation.setVisible(true);
            Presentation presentation3 = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation3, (String)"e.presentation");
            presentation3.setEnabled(SequencesKt.any(this.selectedKotlinFiles(e)));
        }
    }

    private final Sequence<KtFile> selectedKotlinFiles(AnActionEvent e) {
        VirtualFile[] virtualFileArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (virtualFileArray == null) {
            return SequencesKt.sequenceOf((Object[])new KtFile[0]);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"e.getData(CommonDataKeys\u2026Y) ?: return sequenceOf()");
        VirtualFile[] virtualFiles = virtualFileArray;
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            return SequencesKt.sequenceOf((Object[])new KtFile[0]);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"CommonDataKeys.PROJECT.g\u2026t) ?: return sequenceOf()");
        Project project2 = project;
        return this.allKotlinFiles(virtualFiles, project2);
    }

    private final Sequence<KtFile> allKotlinFiles(VirtualFile[] filesOrDirs, Project project) {
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"PsiManager.getInstance(project)");
        PsiManager manager = psiManager;
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.allFiles(filesOrDirs)), (Function1)((Function1)new Function1<VirtualFile, KtFile>(manager){
            final /* synthetic */ PsiManager $manager;

            @Nullable
            public final KtFile invoke(@NotNull VirtualFile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                PsiFile psiFile = this.$manager.findFile(it);
                if (!(psiFile instanceof KtFile)) {
                    psiFile = null;
                }
                return (KtFile)psiFile;
            }
            {
                this.$manager = psiManager;
                super(1);
            }
        }));
    }

    private final Collection<VirtualFile> allFiles(VirtualFile[] filesOrDirs) {
        ArrayList result2 = new ArrayList();
        for (VirtualFile file : filesOrDirs) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Unit>(result2, new VirtualFileVisitor.Option[0]){
                final /* synthetic */ ArrayList $result;

                public boolean visitFile(@NotNull VirtualFile file) {
                    Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                    this.$result.add(file);
                    return true;
                }
                {
                    this.$result = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            }));
        }
        return result2;
    }

    public FindImplicitNothingAction() {
        Logger logger = Logger.getInstance((String)"#org.jetbrains.kotlin.idea.actions.internal.FindImplicitNothingAction");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(\"#org\u2026ndImplicitNothingAction\")");
        this.LOG = logger;
    }

    public static final /* synthetic */ void access$find(FindImplicitNothingAction $this, @NotNull Collection files2, @NotNull Project project) {
        $this.find(files2, project);
    }

    public static final /* synthetic */ boolean access$hasExplicitNothing(FindImplicitNothingAction $this, @NotNull KtExpression $receiver, @NotNull BindingContext bindingContext2) {
        return $this.hasExplicitNothing($receiver, bindingContext2);
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLOG$p(FindImplicitNothingAction $this) {
        return $this.LOG;
    }
}

