/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.surroundWith.expression;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.expression.KotlinExpressionSurrounder;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

public class KotlinWhenSurrounder
extends KotlinExpressionSurrounder {
    public String getTemplateDescription() {
        return KotlinBundle.message("surround.with.when.template", new Object[0]);
    }

    @Override
    @Nullable
    public TextRange surroundExpression(@NotNull Project project, @NotNull Editor editor, @NotNull KtExpression expression2) {
        if (project == null) {
            KotlinWhenSurrounder.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            KotlinWhenSurrounder.$$$reportNull$$$0(1);
        }
        if (expression2 == null) {
            KotlinWhenSurrounder.$$$reportNull$$$0(2);
        }
        KtWhenExpression whenExpression2 = (KtWhenExpression)KtPsiFactoryKt.KtPsiFactory((PsiElement)expression2).createExpression(this.getCodeTemplate(expression2));
        KtExpression subjectExpression = whenExpression2.getSubjectExpression();
        assert (subjectExpression != null) : "JetExpression should exists for " + whenExpression2.getText() + " expression";
        subjectExpression.replace((PsiElement)expression2);
        expression2 = (KtExpression)expression2.replace((PsiElement)whenExpression2);
        CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement((PsiElement)expression2);
        KtWhenEntry whenEntry = ((KtWhenExpression)expression2).getEntries().get(0);
        KtWhenCondition whenEntryCondition = whenEntry.getConditions()[0];
        assert (whenEntryCondition != null) : "JetExpression for first entry should exists: " + expression2.getText();
        TextRange whenRange = whenEntryCondition.getTextRange();
        editor.getDocument().deleteString(whenRange.getStartOffset(), whenRange.getEndOffset());
        int offset2 = whenRange.getStartOffset();
        return new TextRange(offset2, offset2);
    }

    private String getCodeTemplate(KtExpression expression2) {
        ClassifierDescriptor descriptor2;
        KotlinType type2 = ResolutionUtils.analyze(expression2, BodyResolveMode.PARTIAL).getType(expression2);
        if (type2 != null && (descriptor2 = type2.getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor && ((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_CLASS) {
            return "when(a) { \nb -> {}\n}";
        }
        return "when(a) { \nb -> {}\n else -> {}\n}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "expression";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/idea/codeInsight/surroundWith/expression/KotlinWhenSurrounder";
        objectArray[2] = "surroundExpression";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

