/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmSuppressWildcards;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.CoroutineSupport;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinStatus;
import org.jetbrains.kotlin.idea.configuration.Gradle;
import org.jetbrains.kotlin.idea.configuration.GradleBuildScriptManipulator;
import org.jetbrains.kotlin.idea.configuration.GroovyBuildScriptManipulator;
import org.jetbrains.kotlin.idea.configuration.KotlinBuildScriptManipulator;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollectorKt;
import org.jetbrains.kotlin.idea.facet.KotlinVersionInfoProviderKt;
import org.jetbrains.kotlin.idea.framework.ui.ConfigureDialogWithModulesAndVersion;
import org.jetbrains.kotlin.idea.quickfix.ChangeCoroutineSupportFix;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.idea.versions.LibraryJarDescriptor;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 F2\u00020\u0001:\u0001FB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0004H\u0014J.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u0018\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J(\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\bH\u0016J\u001e\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100#H\u0017J(\u0010$\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&H\u0002J>\u0010'\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\n0)H\u0016J\u0018\u0010*\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0004H\u0004J$\u0010+\u001a\u00020&2\u0006\u0010 \u001a\u00020!2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00100\u00162\u0006\u0010\f\u001a\u00020\u0004J2\u0010-\u001a\b\u0012\u0004\u0012\u00020\n0.2\u0006\u0010 \u001a\u00020!2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00100\u00162\u0006\u00100\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&J\u001c\u00101\u001a\u0004\u0018\u00010\u00042\b\u00102\u001a\u0004\u0018\u0001032\u0006\u0010\f\u001a\u00020\u0004H\u0014J\u0010\u00104\u001a\u00020\u00042\u0006\u00105\u001a\u00020\bH$J\b\u00106\u001a\u00020\u0004H\u0014J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0016J\u001a\u0010;\u001a\u00020\u00042\b\u00102\u001a\u0004\u0018\u0001032\u0006\u0010\f\u001a\u00020\u0004H\u0014J\u0010\u0010<\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010=\u001a\u00020\b2\u0006\u0010>\u001a\u00020\nH\u0002J4\u0010?\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010@\u001a\u0004\u0018\u00010\u00042\b\u0010A\u001a\u0004\u0018\u00010\u00042\u0006\u0010B\u001a\u00020C2\u0006\u0010\u001e\u001a\u00020\bH\u0016J\f\u0010D\u001a\u00020\b*\u00020\nH\u0002J\f\u0010E\u001a\u00020\b*\u00020\nH\u0004R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006G"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "()V", "kotlinPluginName", "", "getKotlinPluginName", "()Ljava/lang/String;", "addElementsToFile", "", "file", "Lcom/intellij/psi/PsiFile;", "isTopLevelProjectFile", "version", "addLibraryDependency", "", "module", "Lcom/intellij/openapi/module/Module;", "element", "Lcom/intellij/psi/PsiElement;", "library", "Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;", "libraryJarDescriptors", "", "Lorg/jetbrains/kotlin/idea/versions/LibraryJarDescriptor;", "changeCoroutineConfiguration", "state", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "changeGeneralFeatureConfiguration", "feature", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "forTests", "configure", "project", "Lcom/intellij/openapi/project/Project;", "excludeModules", "", "configureBuildScript", "collector", "Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "configureModule", "filesToOpen", "", "configureModuleBuildScript", "configureSilently", "modules", "configureWithVersion", "Ljava/util/HashSet;", "modulesToConfigure", "kotlinVersion", "getJvmTarget", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "getKotlinPluginExpression", "forKotlinDsl", "getMinimumSupportedVersion", "getStatus", "Lorg/jetbrains/kotlin/idea/configuration/ConfigureKotlinStatus;", "moduleSourceRootGroup", "Lorg/jetbrains/kotlin/idea/configuration/ModuleSourceRootGroup;", "getStdlibArtifactName", "isApplicable", "isFileConfigured", "buildScript", "updateLanguageVersion", "languageVersion", "apiVersion", "requiredStdlibVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "isConfiguredByAnyGradleConfigurator", "isKtDsl", "Companion", "idea-gradle"})
public abstract class KotlinWithGradleConfigurator
implements KotlinProjectConfigurator {
    @NotNull
    private static final String GROUP_ID = "org.jetbrains.kotlin";
    @NotNull
    private static final String GRADLE_PLUGIN_ID = "kotlin-gradle-plugin";
    @NotNull
    private static final String CLASSPATH = "classpath \"org.jetbrains.kotlin:kotlin-gradle-plugin:$kotlin_version\"";
    private static final String KOTLIN_BUILD_SCRIPT_NAME = "build.gradle.kts";
    private static final String KOTLIN_SETTINGS_SCRIPT_NAME = "settings.gradle.kts";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public ConfigureKotlinStatus getStatus(@NotNull ModuleSourceRootGroup moduleSourceRootGroup) {
        boolean bl;
        block11: {
            boolean bl2;
            Module module;
            block10: {
                Intrinsics.checkParameterIsNotNull((Object)moduleSourceRootGroup, (String)"moduleSourceRootGroup");
                module = moduleSourceRootGroup.getBaseModule();
                if (!this.isApplicable(module)) {
                    return ConfigureKotlinStatus.NON_APPLICABLE;
                }
                Iterable $receiver$iv = moduleSourceRootGroup.getSourceRootModules();
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        Module p1 = (Module)element$iv;
                        if (ConfigureKotlinInProjectUtilsKt.hasAnyKotlinRuntimeInScope((Module)p1)) continue;
                        bl2 = false;
                        break block10;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                return ConfigureKotlinStatus.CONFIGURED;
            }
            List buildFiles2 = (List)ApplicationUtilsKt.runReadAction((Function0)new Function0<List<? extends PsiFile>>(module){
                final /* synthetic */ Module $module;

                @NotNull
                public final List<PsiFile> invoke() {
                    Object[] objectArray = new PsiFile[2];
                    objectArray[0] = org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion.access$getBuildScriptPsiFile(KotlinWithGradleConfigurator.Companion, this.$module);
                    Project project = this.$module.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
                    objectArray[1] = org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion.access$getTopLevelBuildScriptPsiFile(KotlinWithGradleConfigurator.Companion, project);
                    return CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf((Object[])objectArray));
                }
                {
                    this.$module = module;
                    super(0);
                }
            });
            if (buildFiles2.isEmpty()) {
                return ConfigureKotlinStatus.NON_APPLICABLE;
            }
            Iterable $receiver$iv = buildFiles2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    PsiFile it = (PsiFile)element$iv;
                    if (!this.isConfiguredByAnyGradleConfigurator(it)) continue;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
        }
        if (bl) {
            return ConfigureKotlinStatus.CAN_BE_CONFIGURED;
        }
        return ConfigureKotlinStatus.BROKEN;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isConfiguredByAnyGradleConfigurator(@NotNull PsiFile $receiver) {
        boolean bl;
        block4: {
            void $receiver$iv$iv;
            Object[] objectArray = Extensions.getExtensions((ExtensionPointName)KotlinProjectConfigurator.Companion.getEP_NAME());
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"Extensions.getExtensions\u2026jectConfigurator.EP_NAME)");
            Object $receiver$iv = objectArray;
            Object object = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (void element$iv$iv : $receiver$iv$iv) {
                if (!(element$iv$iv instanceof KotlinWithGradleConfigurator)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                object = $receiver$iv.iterator();
                while (object.hasNext()) {
                    Object element$iv = object.next();
                    KotlinWithGradleConfigurator it = (KotlinWithGradleConfigurator)element$iv;
                    if (!it.isFileConfigured($receiver)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    protected boolean isApplicable(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return Intrinsics.areEqual((Object)BuildSystemTypeKt.getBuildSystemType(module), (Object)Gradle.INSTANCE);
    }

    @NotNull
    protected String getMinimumSupportedVersion() {
        return "1.0.0";
    }

    protected final boolean isKtDsl(@NotNull PsiFile $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return $receiver instanceof KtFile;
    }

    private final boolean isFileConfigured(PsiFile buildScript) {
        GradleBuildScriptManipulator gradleBuildScriptManipulator = org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion.getManipulator$default(Companion, buildScript, false, 2, null);
        GradleBuildScriptManipulator $receiver = gradleBuildScriptManipulator;
        return $receiver.isConfiguredWithOldSyntax(this.getKotlinPluginName()) || $receiver.isConfigured(this.getKotlinPluginExpression(this.isKtDsl(buildScript)));
    }

    @JvmSuppressWildcards
    public void configure(@NotNull Project project, @NotNull Collection<Module> excludeModules) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(excludeModules, (String)"excludeModules");
        ConfigureDialogWithModulesAndVersion dialog2 = new ConfigureDialogWithModulesAndVersion(project, (KotlinProjectConfigurator)this, excludeModules, this.getMinimumSupportedVersion());
        dialog2.show();
        if (!dialog2.isOK()) {
            return;
        }
        List list2 = dialog2.getModulesToConfigure();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"dialog.modulesToConfigure");
        String string = dialog2.getKotlinVersion();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dialog.kotlinVersion");
        NotificationMessageCollector collector2 = this.configureSilently(project, list2, string);
        collector2.showNotification();
    }

    @NotNull
    public final NotificationMessageCollector configureSilently(@NotNull Project project, @NotNull List<? extends Module> modules, @NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(modules, (String)"modules");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return (NotificationMessageCollector)ApplicationUtilsKt.executeCommand$default(project, "Configure Kotlin", null, (Function0)new Function0<NotificationMessageCollector>(this, project, modules, version){
            final /* synthetic */ KotlinWithGradleConfigurator this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ List $modules;
            final /* synthetic */ String $version;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final NotificationMessageCollector invoke() {
                void var1_1;
                NotificationMessageCollector collector2 = NotificationMessageCollectorKt.createConfigureKotlinNotificationCollector((Project)this.$project);
                HashSet<PsiFile> changedFiles = this.this$0.configureWithVersion(this.$project, this.$modules, this.$version, collector2);
                Iterator<PsiFile> iterator2 = changedFiles.iterator();
                while (iterator2.hasNext()) {
                    PsiFile file;
                    PsiFile psiFile = file = iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"file");
                    OpenFileAction.openFile((VirtualFile)psiFile.getVirtualFile(), (Project)this.$project);
                }
                return var1_1;
            }
            {
                this.this$0 = kotlinWithGradleConfigurator;
                this.$project = project;
                this.$modules = list2;
                this.$version = string;
                super(0);
            }
        }, 2, null);
    }

    @NotNull
    public final HashSet<PsiFile> configureWithVersion(@NotNull Project project, @NotNull List<? extends Module> modulesToConfigure, @NotNull String kotlinVersion, @NotNull NotificationMessageCollector collector2) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(modulesToConfigure, (String)"modulesToConfigure");
        Intrinsics.checkParameterIsNotNull((Object)kotlinVersion, (String)"kotlinVersion");
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        HashSet<PsiFile> filesToOpen = new HashSet<PsiFile>();
        PsiFile buildScript = KotlinWithGradleConfigurator.Companion.getTopLevelBuildScriptPsiFile(project);
        if (buildScript != null && KotlinWithGradleConfigurator.Companion.canConfigureFile(buildScript) && (bl = this.configureBuildScript(buildScript, true, kotlinVersion, collector2))) {
            filesToOpen.add(buildScript);
        }
        for (Module module : modulesToConfigure) {
            PsiFile file = KotlinWithGradleConfigurator.Companion.getBuildScriptPsiFile(module);
            if (file != null && KotlinWithGradleConfigurator.Companion.canConfigureFile(file)) {
                this.configureModule(module, file, false, kotlinVersion, collector2, (Collection<PsiFile>)filesToOpen);
                continue;
            }
            KotlinWithGradleConfigurator.Companion.showErrorMessage(project, "Cannot find build.gradle file for module " + module.getName());
        }
        return filesToOpen;
    }

    public void configureModule(@NotNull Module module, @NotNull PsiFile file, boolean isTopLevelProjectFile, @NotNull String version, @NotNull NotificationMessageCollector collector2, @NotNull Collection<PsiFile> filesToOpen) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        Intrinsics.checkParameterIsNotNull(filesToOpen, (String)"filesToOpen");
        boolean isModified2 = this.configureBuildScript(file, isTopLevelProjectFile, version, collector2);
        if (isModified2) {
            filesToOpen.add(file);
        }
    }

    protected final boolean configureModuleBuildScript(@NotNull PsiFile file, @NotNull String version) {
        Sdk sdk2;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)file));
        if (module != null) {
            Module module2;
            Module it = module2 = module;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)it);
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(it)");
            sdk2 = moduleRootManager.getSdk();
        } else {
            sdk2 = null;
        }
        Sdk sdk3 = sdk2;
        String jvmTarget = this.getJvmTarget(sdk3, version);
        return org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion.getManipulator$default(Companion, file, false, 2, null).configureModuleBuildScript(this.getKotlinPluginName(), this.getKotlinPluginExpression(this.isKtDsl(file)), this.getStdlibArtifactName(sdk3, version), version, jvmTarget);
    }

    @NotNull
    protected String getStdlibArtifactName(@Nullable Sdk sdk2, @NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return KotlinRuntimeLibraryUtilKt.getStdlibArtifactId(sdk2, version);
    }

    @Nullable
    protected String getJvmTarget(@Nullable Sdk sdk2, @NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return null;
    }

    @NotNull
    protected abstract String getKotlinPluginName();

    @NotNull
    protected abstract String getKotlinPluginExpression(boolean var1);

    protected boolean addElementsToFile(@NotNull PsiFile file, boolean isTopLevelProjectFile, @NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        if (!isTopLevelProjectFile) {
            boolean wasModified = org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion.getManipulator$default(Companion, file, false, 2, null).configureProjectBuildScript(this.getKotlinPluginName(), version);
            return wasModified |= this.configureModuleBuildScript(file, version);
        }
        return false;
    }

    private final boolean configureBuildScript(PsiFile file, boolean isTopLevelProjectFile, String version, NotificationMessageCollector collector2) {
        Project project = file.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
        boolean isModified2 = (Boolean)ApplicationUtilsKt.executeWriteCommand(project, "Configure " + file.getName(), null, (Function0)new Function0<Boolean>(this, file, isTopLevelProjectFile, version){
            final /* synthetic */ KotlinWithGradleConfigurator this$0;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ boolean $isTopLevelProjectFile;
            final /* synthetic */ String $version;

            /*
             * WARNING - void declaration
             */
            public final boolean invoke() {
                void var1_1;
                boolean isModified2 = this.this$0.addElementsToFile(this.$file, this.$isTopLevelProjectFile, this.$version);
                CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)((PsiElement)this.$file));
                return (boolean)var1_1;
            }
            {
                this.this$0 = kotlinWithGradleConfigurator;
                this.$file = psiFile;
                this.$isTopLevelProjectFile = bl;
                this.$version = string;
                super(0);
            }
        });
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null && isModified2) {
            collector2.addMessage(virtualFile.getPath() + " was modified");
        }
        return isModified2;
    }

    public void updateLanguageVersion(@NotNull Module module, @Nullable String languageVersion, @Nullable String apiVersion, @NotNull ApiVersion requiredStdlibVersion, boolean forTests) {
        block1: {
            PsiElement psiElement2;
            PsiElement element3;
            boolean runtimeUpdateRequired;
            Object runtimeVersion;
            Object object;
            String it;
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Intrinsics.checkParameterIsNotNull((Object)requiredStdlibVersion, (String)"requiredStdlibVersion");
            Object object2 = KotlinVersionInfoProviderKt.getRuntimeLibraryVersion(module);
            boolean bl = object2 != null && (object2 = ApiVersion.Companion.parse(it = (object = object2))) != null ? ((ApiVersion)(runtimeVersion = (object = object2))).compareTo(requiredStdlibVersion) < 0 : (runtimeUpdateRequired = false);
            if (runtimeUpdateRequired) {
                Messages.showErrorDialog((Project)module.getProject(), (String)("This language feature requires version " + requiredStdlibVersion + " or later of the Kotlin runtime library. " + "Please update the version in your build script."), (String)"Update Language Version");
                return;
            }
            PsiElement psiElement3 = element3 = Companion.changeLanguageVersion(module, languageVersion, apiVersion, forTests);
            if (psiElement3 == null) break block1;
            PsiElement it2 = psiElement2 = psiElement3;
            Project project = module.getProject();
            PsiFile psiFile = it2.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"it.containingFile");
            VirtualFile virtualFile = psiFile.getVirtualFile();
            TextRange textRange = it2.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"it.textRange");
            new OpenFileDescriptor(project, virtualFile, textRange.getStartOffset()).navigate(true);
        }
    }

    public void changeCoroutineConfiguration(@NotNull Module module, @NotNull LanguageFeature.State state) {
        boolean runtimeUpdateRequired;
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        boolean bl = runtimeUpdateRequired = state != LanguageFeature.State.DISABLED && Intrinsics.areEqual((Object)KotlinVersionInfoProviderKt.toApiVersion(KotlinVersionInfoProviderKt.getRuntimeLibraryVersion(module)), (Object)ApiVersion.KOTLIN_1_0);
        if (runtimeUpdateRequired) {
            Messages.showErrorDialog((Project)module.getProject(), (String)"Coroutines support requires version 1.1 or later of the Kotlin runtime library. Please update the version in your build script.", (String)ChangeCoroutineSupportFix.Companion.getFixText(state));
            return;
        }
        PsiElement element3 = Companion.changeCoroutineConfiguration(module, CoroutineSupport.INSTANCE.getCompilerArgument(state));
        if (element3 != null) {
            Project project = module.getProject();
            PsiFile psiFile = element3.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"element.containingFile");
            VirtualFile virtualFile = psiFile.getVirtualFile();
            TextRange textRange = element3.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"element.textRange");
            new OpenFileDescriptor(project, virtualFile, textRange.getStartOffset()).navigate(true);
        }
    }

    public void changeGeneralFeatureConfiguration(@NotNull Module module, @NotNull LanguageFeature feature, @NotNull LanguageFeature.State state, boolean forTests) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)((Object)feature), (String)"feature");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        ApiVersion sinceVersion = feature.getSinceApiVersion();
        if (state != LanguageFeature.State.DISABLED && KotlinVersionInfoProviderKt.toApiVersion(KotlinVersionInfoProviderKt.getRuntimeLibraryVersion(module)).compareTo(sinceVersion) < 0) {
            Messages.showErrorDialog((Project)module.getProject(), (String)(feature.getPresentableName() + " support requires version " + sinceVersion + " or later of the Kotlin runtime library. " + "Please update the version in your build script."), (String)ChangeCoroutineSupportFix.Companion.getFixText(state));
            return;
        }
        PsiElement element3 = Companion.changeFeatureConfiguration(module, feature, state, forTests);
        if (element3 != null) {
            Project project = module.getProject();
            PsiFile psiFile = element3.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"element.containingFile");
            VirtualFile virtualFile = psiFile.getVirtualFile();
            TextRange textRange = element3.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"element.textRange");
            new OpenFileDescriptor(project, virtualFile, textRange.getStartOffset()).navigate(true);
        }
    }

    public void addLibraryDependency(@NotNull Module module, @NotNull PsiElement element3, @NotNull ExternalLibraryDescriptor library, @NotNull List<? extends LibraryJarDescriptor> libraryJarDescriptors) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
        Intrinsics.checkParameterIsNotNull(libraryJarDescriptors, (String)"libraryJarDescriptors");
        DependencyScope dependencyScope = OrderEntryFix.suggestScopeByLocation((Module)module, (PsiElement)element3);
        Intrinsics.checkExpressionValueIsNotNull((Object)dependencyScope, (String)"OrderEntryFix.suggestSco\u2026Location(module, element)");
        DependencyScope scope2 = dependencyScope;
        Companion.addKotlinLibraryToModule(module, scope2, library);
    }

    static {
        GROUP_ID = GROUP_ID;
        GRADLE_PLUGIN_ID = GRADLE_PLUGIN_ID;
        CLASSPATH = "classpath \"" + GROUP_ID + ':' + GRADLE_PLUGIN_ID + ":$kotlin_version\"";
        KOTLIN_BUILD_SCRIPT_NAME = KOTLIN_BUILD_SCRIPT_NAME;
        KOTLIN_SETTINGS_SCRIPT_NAME = KOTLIN_SETTINGS_SCRIPT_NAME;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J(\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u001cH\u0002J\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0004J(\u0010\u001f\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0016J,\u0010%\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010&\u001a\u0004\u0018\u00010\u00042\b\u0010'\u001a\u0004\u0018\u00010\u00042\u0006\u0010$\u001a\u00020\u0016J+\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\u00042\u0012\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040,\"\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010-J\u000e\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u0004J\u001e\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u0016J\u0010\u00103\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u0010J\u001c\u00104\u001a\u0006\u0012\u0002\b\u0003052\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u00106\u001a\u00020\u0016J\u001a\u00107\u001a\u00020\u000e2\u0006\u00108\u001a\u0002092\b\u0010:\u001a\u0004\u0018\u00010\u0004H\u0002J'\u0010;\u001a\u0004\u0018\u00010)*\u00020\u00102\u0012\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040,\"\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010<J\u000e\u0010=\u001a\u0004\u0018\u00010\u0018*\u00020\u0010H\u0002J'\u0010>\u001a\u0004\u0018\u00010)*\u00020\u00102\u0012\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040,\"\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010<J\f\u0010?\u001a\u0004\u0018\u00010\u0018*\u00020\u0010J\u0016\u0010@\u001a\u0004\u0018\u00010\u0018*\u00020)2\u0006\u00108\u001a\u000209H\u0002J\u000e\u0010A\u001a\u0004\u0018\u00010\u0018*\u000209H\u0002J\f\u0010B\u001a\u0004\u0018\u00010\u0018*\u00020\u0010R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator$Companion;", "", "()V", "CLASSPATH", "", "getCLASSPATH", "()Ljava/lang/String;", "GRADLE_PLUGIN_ID", "getGRADLE_PLUGIN_ID", "GROUP_ID", "getGROUP_ID", "KOTLIN_BUILD_SCRIPT_NAME", "KOTLIN_SETTINGS_SCRIPT_NAME", "addKotlinLibraryToModule", "", "module", "Lcom/intellij/openapi/module/Module;", "scope", "Lcom/intellij/openapi/roots/DependencyScope;", "libraryDescriptor", "Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;", "canConfigureFile", "", "file", "Lcom/intellij/psi/PsiFile;", "changeBuildGradle", "Lcom/intellij/psi/PsiElement;", "body", "Lkotlin/Function1;", "changeCoroutineConfiguration", "coroutineOption", "changeFeatureConfiguration", "feature", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "state", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "forTests", "changeLanguageVersion", "languageVersion", "apiVersion", "findBuildGradleFile", "Ljava/io/File;", "path", "fileNames", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/io/File;", "getGroovyApplyPluginDirective", "pluginName", "getGroovyDependencySnippet", "artifactName", "withVersion", "getKotlinStdlibVersion", "getManipulator", "Lorg/jetbrains/kotlin/idea/configuration/GradleBuildScriptManipulator;", "preferNewSyntax", "showErrorMessage", "project", "Lcom/intellij/openapi/project/Project;", "message", "getBuildScriptFile", "(Lcom/intellij/openapi/module/Module;[Ljava/lang/String;)Ljava/io/File;", "getBuildScriptPsiFile", "getBuildScriptSettingsFile", "getBuildScriptSettingsPsiFile", "getPsiFile", "getTopLevelBuildScriptPsiFile", "getTopLevelBuildScriptSettingsPsiFile", "idea-gradle"})
    public static final class Companion {
        @NotNull
        public final GradleBuildScriptManipulator<?> getManipulator(@NotNull PsiFile file, boolean preferNewSyntax) {
            GradleBuildScriptManipulator gradleBuildScriptManipulator;
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            PsiFile psiFile = file;
            if (psiFile instanceof KtFile) {
                gradleBuildScriptManipulator = new KotlinBuildScriptManipulator((KtFile)file, preferNewSyntax);
            } else if (psiFile instanceof GroovyFile) {
                gradleBuildScriptManipulator = new GroovyBuildScriptManipulator((GroovyFile)file, preferNewSyntax);
            } else {
                String string = "Unknown build script file type (" + Reflection.getOrCreateKotlinClass(file.getClass()).getQualifiedName() + ")!";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return gradleBuildScriptManipulator;
        }

        @NotNull
        public static /* synthetic */ GradleBuildScriptManipulator getManipulator$default(Companion companion, PsiFile psiFile, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.getManipulator(psiFile, bl);
        }

        @NotNull
        public final String getGROUP_ID() {
            return GROUP_ID;
        }

        @NotNull
        public final String getGRADLE_PLUGIN_ID() {
            return GRADLE_PLUGIN_ID;
        }

        @NotNull
        public final String getCLASSPATH() {
            return CLASSPATH;
        }

        @NotNull
        public final String getGroovyDependencySnippet(@NotNull String artifactName, @NotNull String scope2, boolean withVersion) {
            Intrinsics.checkParameterIsNotNull((Object)artifactName, (String)"artifactName");
            Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
            return scope2 + " \"org.jetbrains.kotlin:" + artifactName + (withVersion ? ":$kotlin_version" : "") + '\"';
        }

        @NotNull
        public final String getGroovyApplyPluginDirective(@NotNull String pluginName) {
            Intrinsics.checkParameterIsNotNull((Object)pluginName, (String)"pluginName");
            return "apply plugin: '" + pluginName + '\'';
        }

        public final void addKotlinLibraryToModule(@NotNull Module module, @NotNull DependencyScope scope2, @NotNull ExternalLibraryDescriptor libraryDescriptor) {
            block2: {
                VirtualFile virtualFile;
                Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
                Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
                Intrinsics.checkParameterIsNotNull((Object)libraryDescriptor, (String)"libraryDescriptor");
                PsiFile psiFile = this.getBuildScriptPsiFile(module);
                if (psiFile == null) {
                    return;
                }
                PsiFile buildScript = psiFile;
                if (!this.canConfigureFile(buildScript)) {
                    return;
                }
                org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion.getManipulator$default(this, buildScript, false, 2, null).addKotlinLibraryToModuleBuildScript(scope2, libraryDescriptor);
                VirtualFile virtualFile2 = buildScript.getVirtualFile();
                if (virtualFile2 == null) break block2;
                VirtualFile it = virtualFile = virtualFile2;
                Project project = buildScript.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"buildScript.project");
                NotificationMessageCollectorKt.createConfigureKotlinNotificationCollector((Project)project).addMessage(it.getPath() + " was modified").showNotification();
            }
        }

        @Nullable
        public final PsiElement changeCoroutineConfiguration(@NotNull Module module, @NotNull String coroutineOption) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Intrinsics.checkParameterIsNotNull((Object)coroutineOption, (String)"coroutineOption");
            return this.changeBuildGradle(module, (Function1<? super PsiFile, ? extends PsiElement>)((Function1)new Function1<PsiFile, PsiElement>(coroutineOption){
                final /* synthetic */ String $coroutineOption;

                @Nullable
                public final PsiElement invoke(@NotNull PsiFile it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion.getManipulator$default(KotlinWithGradleConfigurator.Companion, it, false, 2, null).changeCoroutineConfiguration(this.$coroutineOption);
                }
                {
                    this.$coroutineOption = string;
                    super(1);
                }
            }));
        }

        @Nullable
        public final PsiElement changeFeatureConfiguration(@NotNull Module module, @NotNull LanguageFeature feature, @NotNull LanguageFeature.State state, boolean forTests) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Intrinsics.checkParameterIsNotNull((Object)((Object)feature), (String)"feature");
            Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
            return this.changeBuildGradle(module, (Function1<? super PsiFile, ? extends PsiElement>)((Function1)new Function1<PsiFile, PsiElement>(feature, state, forTests){
                final /* synthetic */ LanguageFeature $feature;
                final /* synthetic */ LanguageFeature.State $state;
                final /* synthetic */ boolean $forTests;

                @Nullable
                public final PsiElement invoke(@NotNull PsiFile it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion.getManipulator$default(KotlinWithGradleConfigurator.Companion, it, false, 2, null).changeLanguageFeatureConfiguration(this.$feature, this.$state, this.$forTests);
                }
                {
                    this.$feature = languageFeature;
                    this.$state = state;
                    this.$forTests = bl;
                    super(1);
                }
            }));
        }

        @Nullable
        public final PsiElement changeLanguageVersion(@NotNull Module module, @Nullable String languageVersion, @Nullable String apiVersion, boolean forTests) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            return this.changeBuildGradle(module, (Function1<? super PsiFile, ? extends PsiElement>)((Function1)new Function1<PsiFile, PsiElement>(languageVersion, forTests, apiVersion){
                final /* synthetic */ String $languageVersion;
                final /* synthetic */ boolean $forTests;
                final /* synthetic */ String $apiVersion;

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final PsiElement invoke(@NotNull PsiFile buildScriptFile) {
                    void var3_3;
                    Intrinsics.checkParameterIsNotNull((Object)buildScriptFile, (String)"buildScriptFile");
                    GradleBuildScriptManipulator manipulator = org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion.getManipulator$default(KotlinWithGradleConfigurator.Companion, buildScriptFile, false, 2, null);
                    PsiElement result2 = null;
                    if (this.$languageVersion != null) {
                        result2 = manipulator.changeLanguageVersion(this.$languageVersion, this.$forTests);
                    }
                    if (this.$apiVersion != null) {
                        result2 = manipulator.changeApiVersion(this.$apiVersion, this.$forTests);
                    }
                    return var3_3;
                }
                {
                    this.$languageVersion = string;
                    this.$forTests = bl;
                    this.$apiVersion = string2;
                    super(1);
                }
            }));
        }

        private final PsiElement changeBuildGradle(Module module, Function1<? super PsiFile, ? extends PsiElement> body2) {
            PsiFile buildScriptFile = this.getBuildScriptPsiFile(module);
            if (buildScriptFile != null && this.canConfigureFile(buildScriptFile)) {
                Project project = buildScriptFile.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"buildScriptFile.project");
                return (PsiElement)ApplicationUtilsKt.executeWriteCommand(project, "Change build.gradle configuration", null, (Function0)new Function0<PsiElement>(body2, buildScriptFile){
                    final /* synthetic */ Function1 $body;
                    final /* synthetic */ PsiFile $buildScriptFile;

                    @Nullable
                    public final PsiElement invoke() {
                        return (PsiElement)this.$body.invoke((Object)this.$buildScriptFile);
                    }
                    {
                        this.$body = function1;
                        this.$buildScriptFile = psiFile;
                        super(0);
                    }
                });
            }
            return null;
        }

        @Nullable
        public final String getKotlinStdlibVersion(@NotNull Module module) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            PsiFile psiFile = this.getBuildScriptPsiFile(module);
            if (psiFile != null) {
                PsiFile psiFile2;
                PsiFile it = psiFile2 = psiFile;
                string = org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion.getManipulator$default(Companion, it, false, 2, null).getKotlinStdlibVersion();
            } else {
                string = null;
            }
            return string;
        }

        private final boolean canConfigureFile(PsiFile file) {
            return WritingAccessProvider.isPotentiallyWritable((VirtualFile)file.getVirtualFile(), null);
        }

        private final PsiFile getBuildScriptPsiFile(@NotNull Module $receiver) {
            PsiFile psiFile;
            File file = this.getBuildScriptFile($receiver, "build.gradle", KOTLIN_BUILD_SCRIPT_NAME);
            if (file != null) {
                Project project = $receiver.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                psiFile = this.getPsiFile(file, project);
            } else {
                psiFile = null;
            }
            return psiFile;
        }

        @Nullable
        public final PsiFile getBuildScriptSettingsPsiFile(@NotNull Module $receiver) {
            PsiFile psiFile;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
            File file = this.getBuildScriptSettingsFile($receiver, "settings.gradle", KOTLIN_SETTINGS_SCRIPT_NAME);
            if (file != null) {
                Project project = $receiver.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                psiFile = this.getPsiFile(file, project);
            } else {
                psiFile = null;
            }
            return psiFile;
        }

        private final PsiFile getTopLevelBuildScriptPsiFile(@NotNull Project $receiver) {
            PsiFile psiFile;
            String string = $receiver.getBasePath();
            if (string != null) {
                String string2;
                String it;
                String string3 = it = (string2 = string);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it");
                File file = Companion.findBuildGradleFile(string3, "build.gradle", KOTLIN_BUILD_SCRIPT_NAME);
                psiFile = file != null ? Companion.getPsiFile(file, $receiver) : null;
            } else {
                psiFile = null;
            }
            return psiFile;
        }

        @Nullable
        public final PsiFile getTopLevelBuildScriptSettingsPsiFile(@NotNull Module $receiver) {
            PsiFile psiFile;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
            String string = ExternalSystemApiUtil.getExternalRootProjectPath((Module)$receiver);
            if (string != null) {
                String string2;
                String externalProjectPath;
                String string3 = externalProjectPath = (string2 = string);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"externalProjectPath");
                File file = Companion.findBuildGradleFile(string3, "settings.gradle", KOTLIN_SETTINGS_SCRIPT_NAME);
                if (file != null) {
                    Project project = $receiver.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                    psiFile = Companion.getPsiFile(file, project);
                } else {
                    psiFile = null;
                }
            } else {
                psiFile = null;
            }
            return psiFile;
        }

        private final File getBuildScriptFile(@NotNull Module $receiver, String ... fileNames) {
            block3: {
                String string;
                String externalProjectPath;
                VirtualFile[] $receiver$iv;
                String moduleDir;
                String string2 = moduleDir = new File($receiver.getModuleFilePath()).getParent();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"moduleDir");
                File file = this.findBuildGradleFile(string2, Arrays.copyOf(fileNames, fileNames.length));
                if (file != null) {
                    File file2;
                    File it = file2 = file;
                    return it;
                }
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)$receiver);
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(this)");
                VirtualFile[] virtualFileArray = moduleRootManager.getContentRoots();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"ModuleRootManager.getInstance(this).contentRoots");
                VirtualFile[] it = $receiver$iv = virtualFileArray;
                int n = it.length;
                for (int j = 0; j < n; ++j) {
                    File file3;
                    VirtualFile element$iv;
                    VirtualFile root;
                    VirtualFile virtualFile = root = (element$iv = it[j]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"root");
                    String string3 = virtualFile.getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"root.path");
                    File file4 = Companion.findBuildGradleFile(string3, Arrays.copyOf(fileNames, fileNames.length));
                    if (file4 == null) continue;
                    File it2 = file3 = file4;
                    return it2;
                }
                String string4 = ExternalSystemApiUtil.getExternalProjectPath((Module)$receiver);
                if (string4 == null) break block3;
                String string5 = externalProjectPath = (string = string4);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"externalProjectPath");
                File file5 = Companion.findBuildGradleFile(string5, Arrays.copyOf(fileNames, fileNames.length));
                if (file5 != null) {
                    File file6;
                    File it3 = file6 = file5;
                    return it3;
                }
            }
            return null;
        }

        private final File getBuildScriptSettingsFile(@NotNull Module $receiver, String ... fileNames) {
            String string = ExternalSystemApiUtil.getExternalProjectPath((Module)$receiver);
            if (string != null) {
                String string2;
                String externalProjectPath = string2 = string;
                return (File)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.generateSequence((Object)externalProjectPath, (Function1)getBuildScriptSettingsFile.1.1.INSTANCE), (Function1)((Function1)new Function1<String, File>(fileNames){
                    final /* synthetic */ String[] $fileNames$inlined;
                    {
                        this.$fileNames$inlined = stringArray;
                        super(1);
                    }

                    @Nullable
                    public final File invoke(@NotNull String it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator$Companion.access$findBuildGradleFile(KotlinWithGradleConfigurator.Companion, it, Arrays.copyOf(this.$fileNames$inlined, this.$fileNames$inlined.length));
                    }
                })));
            }
            return null;
        }

        private final File findBuildGradleFile(String path2, String ... fileNames) {
            Object v0;
            block1: {
                Sequence $receiver$iv = SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])fileNames), (Function1)((Function1)new Function1<String, File>(path2){
                    final /* synthetic */ String $path;

                    @NotNull
                    public final File invoke(@NotNull String it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return new File(this.$path + "/" + it);
                    }
                    {
                        this.$path = string;
                        super(1);
                    }
                }));
                for (Object element$iv : $receiver$iv) {
                    File it = (File)element$iv;
                    if (!it.exists()) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        private final PsiFile getPsiFile(@NotNull File $receiver, Project project) {
            PsiFile psiFile;
            VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)$receiver, (boolean)true);
            if (virtualFile != null) {
                VirtualFile virtualFile2;
                VirtualFile it = virtualFile2 = virtualFile;
                psiFile = PsiManager.getInstance((Project)project).findFile(it);
            } else {
                psiFile = null;
            }
            return psiFile;
        }

        private final void showErrorMessage(Project project, String message2) {
            Messages.showErrorDialog((Project)project, (String)("<html>Couldn't configure kotlin-gradle plugin automatically.<br/>" + (message2 != null ? message2 + "<br/>" : "") + "<br/>See manual installation instructions <a href=\"https://kotlinlang.org/docs/reference/using-gradle.html\">here</a>.</html>"), (String)"Configure Kotlin-Gradle Plugin");
        }

        private Companion() {
        }

        @Nullable
        public static final /* synthetic */ File access$findBuildGradleFile(Companion $this, @NotNull String path2, String ... fileNames) {
            return $this.findBuildGradleFile(path2, fileNames);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

