/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor.fixers;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.editor.KotlinSmartEnterHandler;
import org.jetbrains.kotlin.idea.editor.fixers.FixersUtilKt;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtTypeParameterList;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/editor/fixers/KotlinFunctionParametersFixer;", "Lcom/intellij/lang/SmartEnterProcessorWithFixers$Fixer;", "Lorg/jetbrains/kotlin/idea/editor/KotlinSmartEnterHandler;", "()V", "apply", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "processor", "psiElement", "Lcom/intellij/psi/PsiElement;", "idea"})
public final class KotlinFunctionParametersFixer
extends SmartEnterProcessorWithFixers.Fixer<KotlinSmartEnterHandler> {
    public void apply(@NotNull Editor editor, @NotNull KotlinSmartEnterHandler processor2, @NotNull PsiElement psiElement2) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)psiElement2, (String)"psiElement");
        if (!(psiElement2 instanceof KtNamedFunction)) {
            return;
        }
        KtParameterList parameterList = ((KtNamedFunction)psiElement2).getValueParameterList();
        if (parameterList == null) {
            KtTypeParameterList ktTypeParameterList;
            PsiElement psiElement3 = ((KtNamedFunction)psiElement2).getNameIdentifier();
            if (psiElement3 == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"psiElement.nameIdentifier ?: return");
            PsiElement identifier2 = psiElement3;
            int offset2 = Math.max(FixersUtilKt.getEnd(FixersUtilKt.getRange(identifier2)), (ktTypeParameterList = ((KtNamedFunction)psiElement2).getTypeParameterList()) != null && (ktTypeParameterList = FixersUtilKt.getRange((PsiElement)ktTypeParameterList)) != null ? FixersUtilKt.getEnd((TextRange)ktTypeParameterList) : FixersUtilKt.getStart(FixersUtilKt.getRange(psiElement2)));
            editor.getDocument().insertString(offset2, (CharSequence)"()");
            processor2.registerUnresolvedError(offset2 + 1);
        } else {
            PsiElement psiElement4 = parameterList.getLastChild();
            if (psiElement4 == null) {
                return;
            }
            PsiElement rParen = psiElement4;
            if (Intrinsics.areEqual((Object)")", (Object)rParen.getText()) ^ true) {
                int n;
                List<KtParameter> list2 = parameterList.getParameters();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"parameterList.parameters");
                List<KtParameter> params2 = list2;
                if (params2.isEmpty()) {
                    n = FixersUtilKt.getStart(FixersUtilKt.getRange((PsiElement)parameterList)) + 1;
                } else {
                    Object object = CollectionsKt.last(params2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"params.last()");
                    n = FixersUtilKt.getEnd(FixersUtilKt.getRange((PsiElement)object));
                }
                int offset3 = n;
                editor.getDocument().insertString(offset3, (CharSequence)")");
            }
        }
    }
}

