/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.lang.Language;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import kotlin.collections.ArraysKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.core.formatter.CompatibilityKt;
import org.jetbrains.kotlin.idea.formatter.KotlinObsoleteCodeStyle;
import org.jetbrains.kotlin.idea.formatter.KotlinStyleGuideCodeStyle;
import org.jetbrains.kotlin.idea.util.FormatterUtilKt;
import org.jetbrains.kotlin.idea.util.ReflectionUtil;

public class KotlinCommonCodeStyleSettings
extends CommonCodeStyleSettings {
    @ReflectionUtil.SkipInEquals
    public String CODE_STYLE_DEFAULTS = null;
    @Nullable
    private KotlinCommonCodeStyleSettings settingsAgainstPreviousDefaults = null;
    private final boolean isTempForDeserialize;
    private static final String INDENT_OPTIONS_TAG = "indentOptions";
    private static final String ARRANGEMENT_ELEMENT_NAME = "arrangement";
    private final Language myLanguage = KotlinLanguage.INSTANCE;

    public KotlinCommonCodeStyleSettings() {
        this(false);
    }

    private KotlinCommonCodeStyleSettings(boolean isTempForDeserialize) {
        super((Language)KotlinLanguage.INSTANCE);
        this.isTempForDeserialize = isTempForDeserialize;
    }

    private static KotlinCommonCodeStyleSettings createForTempDeserialize() {
        return new KotlinCommonCodeStyleSettings(true);
    }

    public void readExternal(Element element3) throws InvalidDataException {
        if (this.isTempForDeserialize) {
            super.readExternal(element3);
            return;
        }
        KotlinCommonCodeStyleSettings tempDeserialize = KotlinCommonCodeStyleSettings.createForTempDeserialize();
        tempDeserialize.readExternal(element3);
        String customDefaults = tempDeserialize.CODE_STYLE_DEFAULTS;
        if ("KOTLIN_OFFICIAL".equals(customDefaults)) {
            KotlinStyleGuideCodeStyle.Companion.applyToCommonSettings(this, true);
        } else if ("KOTLIN_OLD_DEFAULTS".equals(customDefaults)) {
            KotlinObsoleteCodeStyle.Companion.applyToCommonSettings(this, true);
        } else if (customDefaults == null && FormatterUtilKt.isDefaultOfficialCodeStyle()) {
            this.settingsAgainstPreviousDefaults = KotlinCommonCodeStyleSettings.createForTempDeserialize();
            KotlinObsoleteCodeStyle.Companion.applyToCommonSettings(this.settingsAgainstPreviousDefaults, true);
            this.settingsAgainstPreviousDefaults.readExternal(element3);
        }
        this.readExternalBase(element3);
    }

    public void writeExternal(Element element3) throws WriteExternalException {
        CommonCodeStyleSettings defaultSettings = this.getDefaultSettings();
        if (defaultSettings != null) {
            if ("KOTLIN_OFFICIAL".equals(this.CODE_STYLE_DEFAULTS)) {
                KotlinStyleGuideCodeStyle.Companion.applyToCommonSettings(defaultSettings, false);
            } else if ("KOTLIN_OLD_DEFAULTS".equals(this.CODE_STYLE_DEFAULTS)) {
                KotlinObsoleteCodeStyle.Companion.applyToCommonSettings(defaultSettings, false);
            }
        }
        this.writeExternalBase(element3, defaultSettings);
    }

    private void readExternalBase(Element element3) throws InvalidDataException {
        super.readExternal(element3);
    }

    private void writeExternalBase(Element element3, CommonCodeStyleSettings defaultSettings) throws WriteExternalException {
        ArrangementSettings myArrangementSettings;
        Set<String> supportedFields = this.getSupportedFields();
        if (supportedFields != null) {
            supportedFields.add("FORCE_REARRANGE_MODE");
            supportedFields.add("CODE_STYLE_DEFAULTS");
        }
        DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element3, (DefaultJDOMExternalizer.JDOMFilter)new SupportedFieldsDiffFilter(this, supportedFields, defaultSettings));
        List softMargins = this.getSoftMargins();
        this.serializeInto(softMargins, element3);
        CommonCodeStyleSettings.IndentOptions myIndentOptions = this.getIndentOptions();
        if (myIndentOptions != null) {
            CommonCodeStyleSettings.IndentOptions defaultIndentOptions = defaultSettings != null ? defaultSettings.getIndentOptions() : null;
            Element indentOptionsElement = new Element(INDENT_OPTIONS_TAG);
            myIndentOptions.serialize(indentOptionsElement, defaultIndentOptions);
            if (!indentOptionsElement.getChildren().isEmpty()) {
                element3.addContent(indentOptionsElement);
            }
        }
        if ((myArrangementSettings = this.getArrangementSettings()) != null) {
            Element container2 = new Element(ARRANGEMENT_ELEMENT_NAME);
            ArrangementUtil.writeExternal((Element)container2, (ArrangementSettings)myArrangementSettings, (Language)this.myLanguage);
            if (!container2.getChildren().isEmpty()) {
                element3.addContent(container2);
            }
        }
    }

    public CommonCodeStyleSettings clone(@NotNull CodeStyleSettings rootSettings) {
        ArrangementSettings arrangementSettings;
        KotlinCommonCodeStyleSettings commonSettings = new KotlinCommonCodeStyleSettings();
        commonSettings.settingsAgainstPreviousDefaults = this.settingsAgainstPreviousDefaults;
        KotlinCommonCodeStyleSettings.copyPublicFieldsOwn((Object)this, (Object)commonSettings);
        try {
            Method setRootSettingsMethod = CommonCodeStyleSettings.class.getDeclaredMethod("setRootSettings", CodeStyleSettings.class);
            setRootSettingsMethod.setAccessible(true);
            setRootSettingsMethod.invoke((Object)commonSettings, rootSettings);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        commonSettings.setForceArrangeMenuAvailable(this.isForceArrangeMenuAvailable());
        CommonCodeStyleSettings.IndentOptions indentOptions = this.getIndentOptions();
        if (indentOptions != null) {
            CommonCodeStyleSettings.IndentOptions targetIndentOptions = commonSettings.initIndentOptions();
            targetIndentOptions.copyFrom(indentOptions);
        }
        if ((arrangementSettings = this.getArrangementSettings()) != null) {
            commonSettings.setArrangementSettings(arrangementSettings.clone());
        }
        try {
            Method setRootSettingsMethod = (Method)ArraysKt.singleOrNull((Object[])CommonCodeStyleSettings.class.getDeclaredMethods(), method -> "setSoftMargins".equals(method.getName()));
            if (setRootSettingsMethod != null) {
                setRootSettingsMethod.setAccessible(true);
                setRootSettingsMethod.invoke((Object)commonSettings, this.getSoftMargins());
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        return commonSettings;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KotlinCommonCodeStyleSettings)) {
            return false;
        }
        if (!org.jetbrains.kotlin.idea.util.ReflectionUtil.comparePublicNonFinalFieldsWithSkip((Object)this, obj)) {
            return false;
        }
        CommonCodeStyleSettings other = (CommonCodeStyleSettings)obj;
        if (!this.getSoftMargins().equals(other.getSoftMargins())) {
            return false;
        }
        CommonCodeStyleSettings.IndentOptions options2 = this.getIndentOptions();
        if (options2 == null && other.getIndentOptions() != null || options2 != null && !options2.equals((Object)other.getIndentOptions())) {
            return false;
        }
        return this.arrangementSettingsEqual(other);
    }

    private void serializeInto(@NotNull List<Integer> softMargins, @NotNull Element element3) {
        if (softMargins.size() > 0) {
            XmlSerializer.serializeInto((Object)((Object)this), (Element)element3);
        }
    }

    @Nullable
    private CommonCodeStyleSettings getDefaultSettings() {
        return LanguageCodeStyleSettingsProvider.getDefaultCommonSettings((Language)this.myLanguage);
    }

    @Nullable
    private Set<String> getSupportedFields() {
        LanguageCodeStyleSettingsProvider provider2 = LanguageCodeStyleSettingsProvider.forLanguage((Language)this.myLanguage);
        return provider2 == null ? null : provider2.getSupportedFields();
    }

    public boolean canRestore() {
        return this.settingsAgainstPreviousDefaults != null;
    }

    public void restore() {
        if (this.settingsAgainstPreviousDefaults != null) {
            CompatibilityKt.copyFromEx(this, this.settingsAgainstPreviousDefaults);
        }
    }

    private static void copyPublicFieldsOwn(Object from, Object to) {
        assert (from != to);
        ReflectionUtil.copyFields((Field[])to.getClass().getFields(), (Object)from, (Object)to);
    }

    private static class SupportedFieldsDiffFilter
    extends DifferenceFilter<CommonCodeStyleSettings> {
        private final Set<String> mySupportedFieldNames;

        public SupportedFieldsDiffFilter(CommonCodeStyleSettings object, Set<String> supportedFiledNames, CommonCodeStyleSettings parentObject) {
            super((Object)object, (Object)parentObject);
            this.mySupportedFieldNames = supportedFiledNames;
        }

        public boolean isAccept(@NotNull Field field2) {
            if (this.mySupportedFieldNames == null || this.mySupportedFieldNames.contains(field2.getName())) {
                return super.isAccept(field2);
            }
            return false;
        }
    }
}

