/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.hierarchy.calls;

import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.light.LightMemberReference;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.hierarchy.calls.CallHierarchyUtilsKt;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;

public abstract class CalleeReferenceProcessor
extends ReadActionProcessor<PsiReference> {
    private final boolean kotlinOnly;

    public CalleeReferenceProcessor(boolean only) {
        this.kotlinOnly = only;
    }

    public boolean processInReadAction(PsiReference ref) {
        KtProperty property;
        KtElement element3;
        PsiElement refElement;
        if (!(ref instanceof PsiReferenceExpression) && !(ref instanceof KtReference)) {
            if (!(ref instanceof PsiElement)) {
                return true;
            }
            PsiElement parent2 = ((PsiElement)ref).getParent();
            if (parent2 instanceof PsiNewExpression) {
                if (((PsiNewExpression)parent2).getClassReference() != ref) {
                    return true;
                }
            } else if (parent2 instanceof PsiAnonymousClass) {
                if (((PsiAnonymousClass)parent2).getBaseClassReference() != ref) {
                    return true;
                }
            } else if (ref instanceof LightMemberReference) {
                PsiElement refTarget = ref.resolve();
                if (!(refTarget instanceof PsiMethod) || !((PsiMethod)refTarget).isConstructor()) {
                    return true;
                }
            } else {
                return true;
            }
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)(refElement = ref.getElement()), KtImportDirective.class, (boolean)true) != null) {
            return true;
        }
        KtElement ktElement = element3 = refElement instanceof KtElement ? CallHierarchyUtilsKt.getCallHierarchyElement(refElement) : PsiTreeUtil.getParentOfType((PsiElement)refElement, PsiMethod.class, (boolean)false);
        if (this.kotlinOnly && !(element3 instanceof KtNamedDeclaration)) {
            return true;
        }
        if (element3 instanceof KtProperty && PsiTreeUtil.isAncestor((PsiElement)(property = (KtProperty)element3).getInitializer(), (PsiElement)refElement, (boolean)false)) {
            element3 = CallHierarchyUtilsKt.getCallHierarchyElement(element3.getParent());
        }
        if (element3 != null) {
            this.onAccept(ref, (PsiElement)element3);
        }
        return true;
    }

    protected abstract void onAccept(@NotNull PsiReference var1, @NotNull PsiElement var2);
}

