/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.highlighter.KotlinRecursiveCallLineMarkerProviderKt;
import org.jetbrains.kotlin.idea.inspections.RecursivePropertyAccessorInspection;
import org.jetbrains.kotlin.idea.util.ExtensionUtils;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0010\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinRecursiveCallLineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/LineMarkerProvider;", "()V", "collectSlowLineMarkers", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "getEnclosingFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "stopOnNonInlinedLambdas", "", "getLineMarkerInfo", "", "isRecursiveCall", "RecursiveMethodCallMarkerInfo", "idea"})
public final class KotlinRecursiveCallLineMarkerProvider
implements LineMarkerProvider {
    @Nullable
    public Void getLineMarkerInfo(@NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements2, @NotNull Collection<LineMarkerInfo<?>> result2) {
        Intrinsics.checkParameterIsNotNull(elements2, (String)"elements");
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        HashSet<Integer> markedLineNumbers = new HashSet<Integer>();
        for (PsiElement element3 : elements2) {
            int lineNumber;
            ProgressManager.checkCanceled();
            if (!(element3 instanceof KtElement) || markedLineNumbers.contains(lineNumber = KotlinRecursiveCallLineMarkerProviderKt.access$getLineNumber(element3)) || !this.isRecursiveCall((KtElement)element3)) continue;
            markedLineNumbers.add(lineNumber);
            result2.add(new RecursiveMethodCallMarkerInfo(KotlinRecursiveCallLineMarkerProviderKt.getElementForLineMark(element3)));
        }
    }

    private final KtNamedFunction getEnclosingFunction(KtElement element3, boolean stopOnNonInlinedLambdas) {
        for (PsiElement parent2 : PsiUtilsKt.getParents((PsiElement)element3)) {
            PsiElement psiElement2 = parent2;
            if (psiElement2 instanceof KtFunctionLiteral) {
                if (!stopOnNonInlinedLambdas || InlineUtil.isInlinedArgument((KtFunction)parent2, ResolutionUtils.analyze$default((KtElement)parent2, null, 1, null), false)) continue;
                return null;
            }
            if (psiElement2 instanceof KtNamedFunction) {
                PsiElement psiElement3 = ((KtNamedFunction)parent2).getParent();
                if (psiElement3 instanceof KtBlockExpression || psiElement3 instanceof KtClassBody || psiElement3 instanceof KtFile || psiElement3 instanceof KtScript) {
                    return (KtNamedFunction)parent2;
                }
                if (!stopOnNonInlinedLambdas || InlineUtil.isInlinedArgument((KtFunction)parent2, ResolutionUtils.analyze$default((KtElement)parent2, null, 1, null), false)) continue;
                return null;
            }
            if (!(psiElement2 instanceof KtClassOrObject)) continue;
            return null;
        }
        return null;
    }

    private final boolean isRecursiveCall(KtElement element3) {
        if (RecursivePropertyAccessorInspection.Companion.isRecursivePropertyAccess(element3)) {
            return true;
        }
        if (RecursivePropertyAccessorInspection.Companion.isRecursiveSyntheticPropertyAccess(element3)) {
            return true;
        }
        Name name2 = KotlinRecursiveCallLineMarkerProviderKt.access$getCallNameFromPsi(element3);
        if (name2 == null) {
            return false;
        }
        Name resolveName = name2;
        KtNamedFunction ktNamedFunction = this.getEnclosingFunction(element3, false);
        if (ktNamedFunction == null) {
            return false;
        }
        KtNamedFunction enclosingFunction = ktNamedFunction;
        String enclosingFunctionName = enclosingFunction.getName();
        if (Intrinsics.areEqual((Object)enclosingFunctionName, (Object)OperatorNameConventions.INVOKE.asString()) ^ true && Intrinsics.areEqual((Object)enclosingFunctionName, (Object)resolveName.asString()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)enclosingFunction, (Object)this.getEnclosingFunction(element3, true)) ^ true) {
            return false;
        }
        BindingContext bindingContext2 = ResolutionUtils.analyze$default(element3, null, 1, null);
        SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)bindingContext2.get(BindingContext.FUNCTION, enclosingFunction);
        if (simpleFunctionDescriptor == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleFunctionDescriptor, (String)"bindingContext[BindingCo\u2026Function] ?: return false");
        SimpleFunctionDescriptor enclosingFunctionDescriptor = simpleFunctionDescriptor;
        Call call2 = (Call)bindingContext2.get(BindingContext.CALL, element3);
        if (call2 == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"bindingContext[BindingCo\u2026 element] ?: return false");
        Call call3 = call2;
        ResolvedCall resolvedCall2 = (ResolvedCall)bindingContext2.get(BindingContext.RESOLVED_CALL, call3);
        if (resolvedCall2 == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)resolvedCall2, (String)"bindingContext[BindingCo\u2026LL, call] ?: return false");
        ResolvedCall resolvedCall3 = resolvedCall2;
        Object d = resolvedCall3.getCandidateDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(d, (String)"resolvedCall.candidateDescriptor");
        if (Intrinsics.areEqual((Object)d.getOriginal(), (Object)enclosingFunctionDescriptor) ^ true) {
            return false;
        }
        Function1<Receiver, Boolean> isDifferentReceiver$ = new Function1<Receiver, Boolean>(bindingContext2, enclosingFunctionDescriptor){
            final /* synthetic */ BindingContext $bindingContext;
            final /* synthetic */ SimpleFunctionDescriptor $enclosingFunctionDescriptor;

            public final boolean invoke(@Nullable Receiver receiver) {
                boolean bl;
                DeclarationDescriptor receiverOwner;
                if (!(receiver instanceof ReceiverValue)) {
                    return false;
                }
                DeclarationDescriptor declarationDescriptor = ExtensionUtils.getReceiverTargetDescriptor((ReceiverValue)receiver, this.$bindingContext);
                if (declarationDescriptor == null) {
                    return true;
                }
                DeclarationDescriptor declarationDescriptor2 = receiverOwner = declarationDescriptor;
                if (declarationDescriptor2 instanceof SimpleFunctionDescriptor) {
                    bl = Intrinsics.areEqual((Object)receiverOwner, (Object)this.$enclosingFunctionDescriptor) ^ true;
                } else if (declarationDescriptor2 instanceof ClassDescriptor) {
                    bl = Intrinsics.areEqual((Object)receiverOwner, (Object)this.$enclosingFunctionDescriptor.getContainingDeclaration()) ^ true;
                } else {
                    return true;
                }
                return bl;
            }
            {
                this.$bindingContext = bindingContext2;
                this.$enclosingFunctionDescriptor = simpleFunctionDescriptor;
                super(1);
            }
        };
        return !isDifferentReceiver$.invoke((Receiver)resolvedCall3.getDispatchReceiver());
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinRecursiveCallLineMarkerProvider$RecursiveMethodCallMarkerInfo;", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "Lcom/intellij/psi/PsiElement;", "callElement", "(Lcom/intellij/psi/PsiElement;)V", "createGutterRenderer", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "idea"})
    private static final class RecursiveMethodCallMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        @Nullable
        public GutterIconRenderer createGutterRenderer() {
            return (GutterIconRenderer)new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>(this, (LineMarkerInfo)this){
                final /* synthetic */ RecursiveMethodCallMarkerInfo this$0;

                @Nullable
                public Void getClickAction() {
                    return null;
                }
                {
                    this.this$0 = $outer;
                    super($super_call_param$1);
                }
            };
        }

        public RecursiveMethodCallMarkerInfo(@NotNull PsiElement callElement2) {
            Intrinsics.checkParameterIsNotNull((Object)callElement2, (String)"callElement");
            super(callElement2, callElement2.getTextRange(), AllIcons.Gutter.RecursiveMethod, 11, (Function)1.INSTANCE, (GutterIconNavigationHandler)null, GutterIconRenderer.Alignment.RIGHT);
        }
    }
}

