/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.idea.highlighter.AfterAnalysisHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.HighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.highlighter.NameHighlighter;
import org.jetbrains.kotlin.idea.highlighter.TypeKindHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.TypeKindHighlightingVisitor$WhenMappings;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDynamicType;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 H\u0016\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor;", "Lorg/jetbrains/kotlin/idea/highlighter/AfterAnalysisHighlightingVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lcom/intellij/lang/annotation/AnnotationHolder;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "attributeKeyForObjectAccess", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "computeHighlightingRangeForUsage", "Lcom/intellij/openapi/util/TextRange;", "referenceTarget", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "computeReferencedDescriptor", "textAttributesKeyForClassDeclaration", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "visitClassOrObject", "", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitDynamicType", "type", "Lorg/jetbrains/kotlin/psi/KtDynamicType;", "visitSimpleNameExpression", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "visitTypeParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "idea-core"})
public final class TypeKindHighlightingVisitor
extends AfterAnalysisHighlightingVisitor {
    @Override
    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        PsiElement parent2 = expression2.getParent();
        if (parent2 instanceof KtSuperExpression || parent2 instanceof KtThisExpression) {
            return;
        }
        if (!NameHighlighter.INSTANCE.getNamesHighlightingEnabled()) {
            return;
        }
        DeclarationDescriptor declarationDescriptor = this.computeReferencedDescriptor(expression2);
        if (declarationDescriptor == null) {
            return;
        }
        DeclarationDescriptor referenceTarget = declarationDescriptor;
        TextAttributesKey textAttributesKey = this.attributeKeyForObjectAccess(expression2);
        if (textAttributesKey == null) {
            DeclarationDescriptor declarationDescriptor2 = referenceTarget;
            if (declarationDescriptor2 instanceof TypeParameterDescriptor) {
                textAttributesKey = KotlinHighlightingColors.TYPE_PARAMETER;
            } else if (declarationDescriptor2 instanceof TypeAliasDescriptor) {
                textAttributesKey = KotlinHighlightingColors.TYPE_ALIAS;
            } else {
                if (!(declarationDescriptor2 instanceof ClassDescriptor)) {
                    return;
                }
                switch (TypeKindHighlightingVisitor$WhenMappings.$EnumSwitchMapping$0[((ClassDescriptor)referenceTarget).getKind().ordinal()]) {
                    case 1: {
                        textAttributesKey = KotlinHighlightingColors.ANNOTATION;
                        break;
                    }
                    default: {
                        textAttributesKey = this.textAttributesKeyForClassDeclaration((ClassDescriptor)referenceTarget);
                    }
                }
            }
        }
        TextAttributesKey key = textAttributesKey;
        TextRange textRange = this.computeHighlightingRangeForUsage(expression2, referenceTarget);
        TextAttributesKey textAttributesKey2 = key;
        Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey2, (String)"key");
        HighlightingVisitor.highlightName$default((HighlightingVisitor)this, textRange, textAttributesKey2, null, 4, null);
    }

    private final TextAttributesKey attributeKeyForObjectAccess(KtSimpleNameExpression expression2) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2;
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2 = CallUtilKt.getResolvedCall(expression2, this.getBindingContext());
        return (resolvedCall3 != null ? resolvedCall3.getResultingDescriptor() : null) instanceof FakeCallableDescriptorForObject ? this.attributeKeyForCallFromExtensions(expression2, resolvedCall2) : null;
    }

    private final DeclarationDescriptor computeReferencedDescriptor(KtSimpleNameExpression expression2) {
        NavigatablePsiElement callElement2;
        NavigatablePsiElement navigatablePsiElement;
        boolean strict$iv;
        PsiElement $receiver$iv;
        DeclarationDescriptor referenceTarget = (DeclarationDescriptor)this.getBindingContext().get(BindingContext.REFERENCE_TARGET, expression2);
        if (!(referenceTarget instanceof ConstructorDescriptor)) {
            return referenceTarget;
        }
        PsiElement psiElement2 = (PsiElement)expression2;
        boolean bl = true;
        Function1 branch$iv = computeReferencedDescriptor.callElement.1.INSTANCE;
        PsiElement $receiver$iv$iv = $receiver$iv;
        PsiElement psiElement3 = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv$iv, KtCallExpression.class, (boolean)strict$iv);
        KtCallExpression ktCallExpression = (KtCallExpression)(psiElement3 != null ? PsiUtilsKt.getIfChildIsInBranch(psiElement3, $receiver$iv, branch$iv) : null);
        if (ktCallExpression != null) {
            navigatablePsiElement = ktCallExpression;
        } else {
            $receiver$iv = (PsiElement)expression2;
            strict$iv = true;
            branch$iv = computeReferencedDescriptor.callElement.2.INSTANCE;
            $receiver$iv$iv = $receiver$iv;
            PsiElement psiElement4 = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv$iv, KtSuperTypeCallEntry.class, (boolean)strict$iv);
            navigatablePsiElement = callElement2 = (NavigatablePsiElement)(psiElement4 != null ? PsiUtilsKt.getIfChildIsInBranch(psiElement4, $receiver$iv, branch$iv) : null);
        }
        if (callElement2 != null) {
            return referenceTarget;
        }
        return ((ConstructorDescriptor)referenceTarget).getContainingDeclaration();
    }

    private final TextRange computeHighlightingRangeForUsage(KtSimpleNameExpression expression2, DeclarationDescriptor referenceTarget) {
        TextRange expressionRange = expression2.getTextRange();
        if (!(referenceTarget instanceof ClassDescriptor) || ((ClassDescriptor)referenceTarget).getKind() != ClassKind.ANNOTATION_CLASS) {
            TextRange textRange = expressionRange;
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"expressionRange");
            return textRange;
        }
        KtAnnotationEntry annotationEntry2 = (KtAnnotationEntry)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)expression2), KtAnnotationEntry.class, (boolean)false, (Class[])new Class[]{KtValueArgumentList.class});
        KtAnnotationEntry ktAnnotationEntry = annotationEntry2;
        if (ktAnnotationEntry == null || (ktAnnotationEntry = ktAnnotationEntry.getAtSymbol()) == null) {
            TextRange textRange = expressionRange;
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"expressionRange");
            return textRange;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktAnnotationEntry, (String)"annotationEntry?.atSymbo\u2026?: return expressionRange");
        KtAnnotationEntry atSymbol = ktAnnotationEntry;
        TextRange textRange = atSymbol.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"atSymbol.textRange");
        int n = textRange.getStartOffset();
        TextRange textRange2 = expression2.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"expression.textRange");
        return new TextRange(n, textRange2.getEndOffset());
    }

    @Override
    public void visitTypeParameter(@NotNull KtTypeParameter parameter) {
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        PsiElement psiElement2 = parameter.getNameIdentifier();
        if (psiElement2 != null) {
            PsiElement psiElement3;
            PsiElement it;
            PsiElement psiElement4 = it = (psiElement3 = psiElement2);
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"it");
            TextAttributesKey textAttributesKey = KotlinHighlightingColors.TYPE_PARAMETER;
            Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey, (String)"TYPE_PARAMETER");
            HighlightingVisitor.highlightName$default((HighlightingVisitor)this, psiElement4, textAttributesKey, null, 4, null);
        }
        super.visitTypeParameter(parameter);
    }

    @Override
    public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
        Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
        PsiElement identifier2 = classOrObject.getNameIdentifier();
        ClassDescriptor classDescriptor2 = (ClassDescriptor)this.getBindingContext().get(BindingContext.CLASS, classOrObject);
        if (identifier2 != null && classDescriptor2 != null) {
            TextAttributesKey textAttributesKey = this.attributeKeyForDeclarationFromExtensions(classOrObject, classDescriptor2);
            if (textAttributesKey == null) {
                textAttributesKey = this.textAttributesKeyForClassDeclaration(classDescriptor2);
            }
            HighlightingVisitor.highlightName$default((HighlightingVisitor)this, identifier2, textAttributesKey, null, 4, null);
        }
        super.visitClassOrObject(classOrObject);
    }

    @Override
    public void visitTypeAlias(@NotNull KtTypeAlias typeAlias2) {
        Intrinsics.checkParameterIsNotNull((Object)typeAlias2, (String)"typeAlias");
        PsiElement identifier2 = typeAlias2.getNameIdentifier();
        TypeAliasDescriptor descriptor2 = (TypeAliasDescriptor)this.getBindingContext().get(BindingContext.TYPE_ALIAS, typeAlias2);
        if (identifier2 != null && descriptor2 != null) {
            TextAttributesKey textAttributesKey = this.attributeKeyForDeclarationFromExtensions(identifier2, descriptor2);
            if (textAttributesKey == null) {
                TextAttributesKey textAttributesKey2 = KotlinHighlightingColors.TYPE_ALIAS;
                textAttributesKey = textAttributesKey2;
                Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey2, (String)"TYPE_ALIAS");
            }
            HighlightingVisitor.highlightName$default((HighlightingVisitor)this, identifier2, textAttributesKey, null, 4, null);
        }
        super.visitTypeAlias(typeAlias2);
    }

    @Override
    public void visitDynamicType(@NotNull KtDynamicType type2) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
    }

    private final TextAttributesKey textAttributesKeyForClassDeclaration(ClassDescriptor descriptor2) {
        TextAttributesKey textAttributesKey;
        switch (TypeKindHighlightingVisitor$WhenMappings.$EnumSwitchMapping$1[descriptor2.getKind().ordinal()]) {
            case 1: {
                TextAttributesKey textAttributesKey2 = KotlinHighlightingColors.TRAIT;
                textAttributesKey = textAttributesKey2;
                Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey2, (String)"TRAIT");
                break;
            }
            case 2: {
                TextAttributesKey textAttributesKey3 = KotlinHighlightingColors.ANNOTATION;
                textAttributesKey = textAttributesKey3;
                Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey3, (String)"ANNOTATION");
                break;
            }
            case 3: {
                TextAttributesKey textAttributesKey4 = KotlinHighlightingColors.OBJECT;
                textAttributesKey = textAttributesKey4;
                Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey4, (String)"OBJECT");
                break;
            }
            case 4: {
                TextAttributesKey textAttributesKey5 = KotlinHighlightingColors.ENUM_ENTRY;
                textAttributesKey = textAttributesKey5;
                Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey5, (String)"ENUM_ENTRY");
                break;
            }
            default: {
                TextAttributesKey textAttributesKey6 = descriptor2.getModality() == Modality.ABSTRACT ? KotlinHighlightingColors.ABSTRACT_CLASS : KotlinHighlightingColors.CLASS;
                textAttributesKey = textAttributesKey6;
                Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey6, (String)"if (descriptor.modality \u2026ABSTRACT_CLASS else CLASS");
            }
        }
        return textAttributesKey;
    }

    public TypeKindHighlightingVisitor(@NotNull AnnotationHolder holder, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        super(holder, bindingContext2);
    }
}

