/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.caches.resolve.KotlinCacheService;
import org.jetbrains.kotlin.idea.highlighter.KotlinSuppressableWarningProblemGroupKt;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspectionKt;
import org.jetbrains.kotlin.resolve.diagnostics.KotlinSuppressCache;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001f\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0016JO\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\t\"\u00020\u001aH\u0004\u00a2\u0006\u0002\u0010\u001bJE\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\t\"\u00020\u001aH\u0004\u00a2\u0006\u0002\u0010\u001cR\u0014\u0010\u0004\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "Lcom/intellij/codeInspection/CustomSuppressableInspectionTool;", "()V", "suppressionKey", "", "getSuppressionKey", "()Ljava/lang/String;", "getSuppressActions", "", "Lcom/intellij/codeInspection/SuppressIntentionAction;", "element", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/codeInspection/SuppressIntentionAction;", "isSuppressedFor", "", "registerProblemWithoutOfflineInformation", "", "Lcom/intellij/codeInspection/ProblemsHolder;", "description", "isOnTheFly", "highlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "range", "Lcom/intellij/openapi/util/TextRange;", "fixes", "Lcom/intellij/codeInspection/LocalQuickFix;", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/intellij/psi/PsiElement;Ljava/lang/String;ZLcom/intellij/codeInspection/ProblemHighlightType;Lcom/intellij/openapi/util/TextRange;[Lcom/intellij/codeInspection/LocalQuickFix;)V", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/intellij/psi/PsiElement;Ljava/lang/String;ZLcom/intellij/codeInspection/ProblemHighlightType;[Lcom/intellij/codeInspection/LocalQuickFix;)V", "idea-core"})
public abstract class AbstractKotlinInspection
extends LocalInspectionTool
implements CustomSuppressableInspectionTool {
    @Nullable
    public SuppressIntentionAction[] getSuppressActions(@Nullable PsiElement element3) {
        Collection $receiver$iv;
        if (element3 == null) {
            return new SuppressIntentionAction[0];
        }
        HighlightDisplayLevel highlightDisplayLevel = this.getDefaultLevel();
        Intrinsics.checkExpressionValueIsNotNull((Object)highlightDisplayLevel, (String)"defaultLevel");
        Collection collection = $receiver$iv = (Collection)KotlinSuppressableWarningProblemGroupKt.createSuppressWarningActions(element3, AbstractKotlinInspectionKt.toSeverity(highlightDisplayLevel), this.getSuppressionKey());
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        SuppressIntentionAction[] suppressIntentionActionArray = thisCollection$iv.toArray(new SuppressIntentionAction[0]);
        if (suppressIntentionActionArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return suppressIntentionActionArray;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        SuppressManager suppressManager = SuppressManager.getInstance();
        if (suppressManager == null) {
            Intrinsics.throwNpe();
        }
        if (suppressManager.isSuppressedFor(element3, this.getID())) {
            return true;
        }
        Project project = element3.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"element.project");
        Project project2 = project;
        KotlinSuppressCache kotlinSuppressCache2 = KotlinCacheService.Companion.getInstance(project2).getSuppressionCache();
        String string = this.getSuppressionKey();
        HighlightDisplayLevel highlightDisplayLevel = this.getDefaultLevel();
        Intrinsics.checkExpressionValueIsNotNull((Object)highlightDisplayLevel, (String)"defaultLevel");
        return kotlinSuppressCache2.isSuppressed(element3, string, AbstractKotlinInspectionKt.toSeverity(highlightDisplayLevel));
    }

    @NotNull
    protected String getSuppressionKey() {
        String string = this.getShortName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.shortName");
        return StringsKt.removePrefix((String)string, (CharSequence)"Kotlin");
    }

    protected final void registerProblemWithoutOfflineInformation(@NotNull ProblemsHolder $receiver, @NotNull PsiElement element3, @NotNull String description2, boolean isOnTheFly, @NotNull ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)description2, (String)"description");
        Intrinsics.checkParameterIsNotNull((Object)highlightType, (String)"highlightType");
        Intrinsics.checkParameterIsNotNull((Object)fixes, (String)"fixes");
        this.registerProblemWithoutOfflineInformation($receiver, element3, description2, isOnTheFly, highlightType, (TextRange)null, Arrays.copyOf(fixes, fixes.length));
    }

    protected final void registerProblemWithoutOfflineInformation(@NotNull ProblemsHolder $receiver, @NotNull PsiElement element3, @NotNull String description2, boolean isOnTheFly, @NotNull ProblemHighlightType highlightType, @Nullable TextRange range, LocalQuickFix ... fixes) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)description2, (String)"description");
        Intrinsics.checkParameterIsNotNull((Object)highlightType, (String)"highlightType");
        Intrinsics.checkParameterIsNotNull((Object)fixes, (String)"fixes");
        if (!isOnTheFly && highlightType == ProblemHighlightType.INFORMATION) {
            return;
        }
        ProblemDescriptor problemDescriptor = $receiver.getManager().createProblemDescriptor(element3, range, description2, highlightType, isOnTheFly, Arrays.copyOf(fixes, fixes.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)problemDescriptor, (String)"manager.createProblemDes\u2026Type, isOnTheFly, *fixes)");
        ProblemDescriptor problemDescriptor2 = problemDescriptor;
        $receiver.registerProblem(problemDescriptor2);
    }
}

