/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.RemoveRedundantBackticksQuickFix;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RemoveRedundantBackticksInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isKeyword", "text", "", "isRedundantBackticks", "node", "Lcom/intellij/lang/ASTNode;", "registerProblem", "", "element", "Lcom/intellij/psi/PsiElement;", "idea"})
public final class RemoveRedundantBackticksInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return new KtVisitorVoid(this, holder){
            final /* synthetic */ RemoveRedundantBackticksInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitKtElement(@NotNull KtElement element3) {
                ASTNode[] $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                super.visitKtElement(element3);
                ASTNode[] aSTNodeArray = SharedImplUtil.getChildrenOfType((ASTNode)element3.getNode(), (IElementType)KtTokens.IDENTIFIER);
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNodeArray, (String)"SharedImplUtil.getChildr\u2026ode, KtTokens.IDENTIFIER)");
                ASTNode[] aSTNodeArray2 = $receiver$iv = aSTNodeArray;
                int n = aSTNodeArray2.length;
                for (int j = 0; j < n; ++j) {
                    ASTNode element$iv;
                    ASTNode it;
                    ASTNode aSTNode = it = (element$iv = aSTNodeArray2[j]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"it");
                    if (!RemoveRedundantBackticksInspection.access$isRedundantBackticks(this.this$0, aSTNode)) continue;
                    PsiElement psiElement2 = it.getPsi();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"it.psi");
                    RemoveRedundantBackticksInspection.access$registerProblem(this.this$0, this.$holder, psiElement2);
                }
            }
            {
                this.this$0 = $outer;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isKeyword(String text2) {
        Object[] $receiver$iv;
        if (Intrinsics.areEqual((Object)text2, (Object)"yield")) return true;
        TokenSet tokenSet = KtTokens.KEYWORDS;
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"KtTokens.KEYWORDS");
        Object[] objectArray = tokenSet.getTypes();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"KtTokens.KEYWORDS.types");
        TokenSet tokenSet2 = KtTokens.SOFT_KEYWORDS;
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet2, (String)"KtTokens.SOFT_KEYWORDS");
        Object[] objectArray2 = tokenSet2.getTypes();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray2, (String)"KtTokens.SOFT_KEYWORDS.types");
        Object[] objectArray3 = $receiver$iv = ArraysKt.plus((Object[])objectArray, (Object[])objectArray2);
        int n = objectArray3.length;
        int n2 = 0;
        while (n2 < n) {
            Object element$iv = objectArray3[n2];
            IElementType it = (IElementType)element$iv;
            if (Intrinsics.areEqual((Object)it.toString(), (Object)text2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private final boolean isRedundantBackticks(ASTNode node) {
        String string = node.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"node.text");
        String text2 = string;
        if (!StringsKt.startsWith$default((String)text2, (String)"`", (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)text2, (String)"`", (boolean)false, (int)2, null)) {
            return false;
        }
        String unquotedText = UtilsKt.unquote(text2);
        return KtPsiUtilKt.isIdentifier(unquotedText) && !this.isKeyword(unquotedText);
    }

    private final void registerProblem(ProblemsHolder holder, PsiElement element3) {
        holder.registerProblem(element3, "Remove redundant backticks", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveRedundantBackticksQuickFix()});
    }

    public static final /* synthetic */ boolean access$isRedundantBackticks(RemoveRedundantBackticksInspection $this, @NotNull ASTNode node) {
        return $this.isRedundantBackticks(node);
    }

    public static final /* synthetic */ void access$registerProblem(RemoveRedundantBackticksInspection $this, @NotNull ProblemsHolder holder, @NotNull PsiElement element3) {
        $this.registerProblem(holder, element3);
    }
}

