/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.collections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.collections.ConvertCallChainIntoSequenceFix$$special$;
import org.jetbrains.kotlin.idea.inspections.collections.ConvertCallChainIntoSequenceInspectionKt;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/collections/ConvertCallChainIntoSequenceFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
final class ConvertCallChainIntoSequenceFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        return "Convert call chain into 'Sequence'";
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    /*
     * WARNING - void declaration
     */
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        KtExpression ktExpression;
        void newElement$iv;
        boolean bl;
        Sequence $receiver$iv;
        StringBuilder $receiver;
        StringBuilder stringBuilder;
        KtPsiFactory psiFactory;
        boolean endWithTermination;
        KtQualifiedExpression last;
        KtQualifiedExpression first;
        KtCallExpression firstCall;
        block15: {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (!(psiElement2 instanceof KtQualifiedExpression)) {
                psiElement2 = null;
            }
            KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)psiElement2;
            if (ktQualifiedExpression == null) {
                return;
            }
            KtQualifiedExpression expression2 = ktQualifiedExpression;
            BindingContext context = ResolutionUtils.analyze(expression2, BodyResolveMode.PARTIAL);
            List calls = CollectionsKt.reversed((Iterable)ConvertCallChainIntoSequenceInspectionKt.access$collectCallExpression(expression2, context));
            KtCallExpression ktCallExpression = (KtCallExpression)CollectionsKt.firstOrNull((List)calls);
            if (ktCallExpression == null) {
                return;
            }
            firstCall = ktCallExpression;
            KtCallExpression ktCallExpression2 = (KtCallExpression)CollectionsKt.lastOrNull((List)calls);
            if (ktCallExpression2 == null) {
                return;
            }
            KtCallExpression lastCall = ktCallExpression2;
            KtQualifiedExpression ktQualifiedExpression2 = KtPsiUtilKt.getQualifiedExpressionForSelector(firstCall);
            if (ktQualifiedExpression2 == null) {
                return;
            }
            first = ktQualifiedExpression2;
            KtQualifiedExpression ktQualifiedExpression3 = KtPsiUtilKt.getQualifiedExpressionForSelector(lastCall);
            if (ktQualifiedExpression3 == null) {
                return;
            }
            last = ktQualifiedExpression3;
            endWithTermination = ConvertCallChainIntoSequenceInspectionKt.access$isTermination(lastCall, context);
            psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)expression2, false, 2, null);
            $receiver = stringBuilder = new StringBuilder();
            $receiver$iv = PsiUtilsKt.siblings$default((PsiElement)first.getReceiverExpression(), false, false, 3, null);
            Sequence sequence2 = SequencesKt.filter((Sequence)$receiver$iv, (Function1)$special$$inlined$filterIsInstance$1.INSTANCE);
            if (sequence2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
            }
            $receiver$iv = sequence2;
            for (Object element$iv : $receiver$iv) {
                PsiWhiteSpace it = (PsiWhiteSpace)element$iv;
                if (!it.textContains('\n')) continue;
                bl = true;
                break block15;
            }
            bl = false;
        }
        if (bl) {
            $receiver.append("\n");
        }
        if (first instanceof KtSafeQualifiedExpression) {
            $receiver.append("?");
        }
        $receiver.append(".");
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String dot = string;
        CommentSaver firstCommentSaver = new CommentSaver((PsiElement)first, false, 2, null);
        $receiver$iv = (PsiElement)first;
        Iterator $i$f$filterIsInstance = (PsiElement)CreateByPatternKt.buildExpression$default(psiFactory, false, (Function1)new Function1<BuilderByPattern<KtExpression>, Unit>(first, dot, psiFactory, firstCall){
            final /* synthetic */ KtQualifiedExpression $first;
            final /* synthetic */ String $dot;
            final /* synthetic */ KtPsiFactory $psiFactory;
            final /* synthetic */ KtCallExpression $firstCall;

            public final void invoke(@NotNull BuilderByPattern<KtExpression> $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
                $receiver.appendExpression(this.$first.getReceiverExpression());
                $receiver.appendFixedText(this.$dot);
                $receiver.appendExpression(this.$psiFactory.createExpression("asSequence()"));
                $receiver.appendFixedText(this.$dot);
                $receiver.appendExpression(this.$firstCall);
            }
            {
                this.$first = ktQualifiedExpression;
                this.$dot = string;
                this.$psiFactory = ktPsiFactory;
                this.$firstCall = ktCallExpression;
                super(1);
            }
        }, 1, null);
        PsiElement result$iv = $receiver$iv.replace((PsiElement)newElement$iv);
        PsiElement psiElement3 = result$iv;
        if (!(psiElement3 instanceof KtExpression)) {
            psiElement3 = null;
        }
        if ((ktExpression = (KtExpression)psiElement3) == null) {
            PsiElement psiElement4 = result$iv;
            if (psiElement4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            ktExpression = ((KtParenthesizedExpression)psiElement4).getExpression();
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
        }
        KtExpression firstReplaced2 = ktExpression;
        CommentSaver.restore$default(firstCommentSaver, (PsiElement)firstReplaced2, false, 2, null);
        if (!endWithTermination) {
            PsiElement lastReplaced2;
            CommentSaver lastCommentSaver = new CommentSaver((PsiElement)last, false, 2, null);
            PsiElement psiElement5 = lastReplaced2 = last.replace((PsiElement)CreateByPatternKt.buildExpression$default(psiFactory, false, (Function1)new Function1<BuilderByPattern<KtExpression>, Unit>(last, dot, psiFactory){
                final /* synthetic */ KtQualifiedExpression $last;
                final /* synthetic */ String $dot;
                final /* synthetic */ KtPsiFactory $psiFactory;

                public final void invoke(@NotNull BuilderByPattern<KtExpression> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
                    $receiver.appendExpression(this.$last);
                    $receiver.appendFixedText(this.$dot);
                    $receiver.appendExpression(this.$psiFactory.createExpression("toList()"));
                }
                {
                    this.$last = ktQualifiedExpression;
                    this.$dot = string;
                    this.$psiFactory = ktPsiFactory;
                    super(1);
                }
            }, 1, null));
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement5, (String)"lastReplaced");
            CommentSaver.restore$default(lastCommentSaver, psiElement5, false, 2, null);
        }
    }
}

