/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.coroutines;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenameProcessor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.callableBuilder.CallableBuilderKt;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001c2\u00020\u0001:\u0003\u001b\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J#\u0010\u000f\u001a\u0004\u0018\u00010\u000e*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J6\u0010\u000f\u001a\u00020\u000e*\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u0012H\u0002\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/coroutines/ResultIsResultInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "analyzeFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "toReport", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "isOnTheFly", "", "hasCorrespondingNonCatchingFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "returnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "nameWithoutCatching", "", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;Lorg/jetbrains/kotlin/types/KotlinType;Ljava/lang/String;)Ljava/lang/Boolean;", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "valueParameters", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "extensionReceiverType", "AddGetOrThrowFix", "Companion", "RenameToCatchingFix", "idea"})
public final class ResultIsResultInspection
extends AbstractKotlinInspection {
    private static final String SHORT_NAME = "Result";
    private static final String FULL_NAME = "kotlin.Result";
    private static final String CATCHING = "Catching";
    private static final String GET_OR_THROW = "getOrThrow";
    private static final Set<String> ALLOWED_NAMES;
    public static final Companion Companion;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasCorrespondingNonCatchingFunction(@NotNull MemberScope $receiver, String nameWithoutCatching, List<? extends ValueParameterDescriptor> valueParameters2, KotlinType returnType2, KotlinType extensionReceiverType) {
        boolean bl;
        Name name2 = Name.identifier(nameWithoutCatching);
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(nameWithoutCatching)");
        Collection<SimpleFunctionDescriptor> nonCatchingFunctions = $receiver.getContributedFunctions(name2, NoLookupLocation.FROM_IDE);
        Iterable $receiver$iv = nonCatchingFunctions;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            SimpleFunctionDescriptor nonCatchingFun = (SimpleFunctionDescriptor)element$iv;
            if (nonCatchingFun.getValueParameters().size() == valueParameters2.size() && Intrinsics.areEqual((Object)nonCatchingFun.getReturnType(), (Object)returnType2)) {
                ReceiverParameterDescriptor receiverParameterDescriptor = nonCatchingFun.getExtensionReceiverParameter();
                if (Intrinsics.areEqual((Object)(receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null), (Object)extensionReceiverType)) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final Boolean hasCorrespondingNonCatchingFunction(@NotNull FunctionDescriptor $receiver, KotlinType returnType2, String nameWithoutCatching) {
        MemberScope memberScope2;
        DeclarationDescriptor containingDescriptor;
        DeclarationDescriptor declarationDescriptor = $receiver.getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"containingDeclaration");
        DeclarationDescriptor declarationDescriptor2 = containingDescriptor = declarationDescriptor;
        if (declarationDescriptor2 instanceof ClassDescriptor) {
            memberScope2 = ((ClassDescriptor)containingDescriptor).getUnsubstitutedMemberScope();
        } else if (declarationDescriptor2 instanceof PackageFragmentDescriptor) {
            memberScope2 = ((PackageFragmentDescriptor)containingDescriptor).getMemberScope();
        } else {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)memberScope2, (String)"when (containingDescript\u2026 -> return null\n        }");
        MemberScope scope2 = memberScope2;
        TypeProjection typeProjection = (TypeProjection)CollectionsKt.firstOrNull(returnType2.getArguments());
        KotlinType returnTypeArgument = typeProjection != null ? typeProjection.getType() : null;
        ReceiverParameterDescriptor receiverParameterDescriptor = $receiver.getExtensionReceiverParameter();
        KotlinType extensionReceiverType = receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null;
        List<ValueParameterDescriptor> list2 = $receiver.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"valueParameters");
        if (this.hasCorrespondingNonCatchingFunction(scope2, nameWithoutCatching, list2, returnTypeArgument, extensionReceiverType)) {
            return true;
        }
        if (extensionReceiverType != null) {
            ClassDescriptor extensionClassDescriptor;
            ClassifierDescriptor classifierDescriptor = extensionReceiverType.getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof ClassDescriptor)) {
                classifierDescriptor = null;
            }
            if ((extensionClassDescriptor = (ClassDescriptor)classifierDescriptor) != null) {
                MemberScope memberScope3 = extensionClassDescriptor.getUnsubstitutedMemberScope();
                Intrinsics.checkExpressionValueIsNotNull((Object)memberScope3, (String)"extensionClassDescriptor.unsubstitutedMemberScope");
                MemberScope extensionClassScope = memberScope3;
                List<ValueParameterDescriptor> list3 = $receiver.getValueParameters();
                Intrinsics.checkExpressionValueIsNotNull(list3, (String)"valueParameters");
                if (this.hasCorrespondingNonCatchingFunction(extensionClassScope, nameWithoutCatching, list3, returnTypeArgument, null)) {
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void analyzeFunction(KtFunction function2, PsiElement toReport, ProblemsHolder holder) {
        Object nameWithoutCatching;
        DeclarationDescriptor declarationDescriptor;
        Object it;
        KtTypeReference receiverTypeReference;
        String name2;
        Object object;
        String returnTypeText;
        if (function2 instanceof KtConstructor) {
            return;
        }
        KtTypeReference ktTypeReference = CallableBuilderKt.getReturnTypeReference(function2);
        String string = returnTypeText = ktTypeReference != null ? ktTypeReference.getText() : null;
        if (returnTypeText != null && !StringsKt.contains$default((CharSequence)returnTypeText, (CharSequence)SHORT_NAME, (boolean)false, (int)2, null)) {
            return;
        }
        KtFunction ktFunction = function2;
        if (!(ktFunction instanceof KtNamedFunction)) {
            ktFunction = null;
        }
        String string2 = (object = (KtNamedFunction)ktFunction) != null && (object = ((KtTypeParameterListOwnerStub)object).getNameAsName()) != null ? ((Name)object).asString() : (name2 = null);
        if (CollectionsKt.contains((Iterable)ALLOWED_NAMES, (Object)name2)) {
            return;
        }
        if (function2 instanceof KtNamedFunction && (receiverTypeReference = ((KtNamedFunction)function2).getReceiverTypeReference()) != null) {
            String string3 = receiverTypeReference.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"receiverTypeReference.text");
            if (StringsKt.contains$default((CharSequence)string3, (CharSequence)SHORT_NAME, (boolean)false, (int)2, null)) {
                return;
            }
        }
        if (function2 instanceof KtFunctionLiteral || returnTypeText == null) {
            String text2;
            KtExpression ktExpression = function2.getBodyExpression();
            String string4 = text2 = ktExpression != null ? ktExpression.getText() : null;
            if (text2 != null) {
                boolean bl;
                block26: {
                    Iterable $receiver$iv = ALLOWED_NAMES;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $receiver$iv) {
                            it = (String)element$iv;
                            if (!StringsKt.contains$default((CharSequence)text2, (CharSequence)((CharSequence)it), (boolean)false, (int)2, null)) continue;
                            bl = false;
                            break block26;
                        }
                        bl = true;
                    }
                }
                if (bl && !StringsKt.contains$default((CharSequence)text2, (CharSequence)SHORT_NAME, (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)text2, (CharSequence)CATCHING, (boolean)false, (int)2, null)) {
                    return;
                }
            }
        }
        if (!((declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default(function2, null, 1, null)) instanceof FunctionDescriptor)) {
            declarationDescriptor = null;
        }
        FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)declarationDescriptor;
        if (functionDescriptor2 == null) {
            return;
        }
        FunctionDescriptor descriptor2 = functionDescriptor2;
        KotlinType kotlinType = descriptor2.getReturnType();
        if (kotlinType == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"descriptor.returnType ?: return");
        KotlinType returnType2 = kotlinType;
        ClassifierDescriptor classifierDescriptor = returnType2.getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor2 = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor2 == null) {
            return;
        }
        ClassDescriptor returnTypeClass = classDescriptor2;
        if (Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe(returnTypeClass).asString(), (Object)FULL_NAME) ^ true) {
            return;
        }
        if (name2 != null && StringsKt.endsWith$default((String)name2, (String)CATCHING, (boolean)false, (int)2, null)) {
            nameWithoutCatching = StringsKt.substringBeforeLast$default((String)name2, (String)CATCHING, null, (int)2, null);
            if (Intrinsics.areEqual((Object)this.hasCorrespondingNonCatchingFunction(descriptor2, returnType2, (String)nameWithoutCatching), (Object)false)) {
                TypeProjection typeProjection = (TypeProjection)CollectionsKt.firstOrNull(returnType2.getArguments());
                KotlinType returnTypeArgument = typeProjection != null ? typeProjection.getType() : null;
                Object object2 = returnTypeArgument;
                if (object2 == null || (object2 = ((KotlinType)object2).getConstructor()) == null || (object2 = object2.getDeclarationDescriptor()) == null || (object2 = object2.getName()) == null || (object2 = ((Name)object2).asString()) == null) {
                    object2 = "T";
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"returnTypeArgument?.cons\u2026?.name?.asString() ?: \"T\"");
                Object typeName = object2;
                holder.registerProblem(toReport, "Function '" + name2 + "' returning 'Result<" + (String)typeName + ">' without the corresponding " + "function '" + (String)nameWithoutCatching + "' returning '" + (String)typeName + '\'', ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
        } else {
            void $receiver$iv;
            RenameToCatchingFix renameToCatchingFix;
            ProblemsHolder problemsHolder;
            PsiElement psiElement2;
            String string5;
            ProblemHighlightType problemHighlightType;
            Object[] objectArray;
            ProblemsHolder problemsHolder2 = holder;
            PsiElement psiElement3 = toReport;
            String string6 = "Function returning Result with a name that does not end with Catching";
            ProblemHighlightType problemHighlightType2 = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            Object[] objectArray2 = new LocalQuickFix[2];
            objectArray2[0] = new AddGetOrThrowFix(function2.hasBody());
            Object[] objectArray3 = objectArray2;
            Object[] objectArray4 = objectArray2;
            int n = 1;
            String string7 = name2;
            if (string7 != null) {
                nameWithoutCatching = string7;
                int n2 = n;
                Object[] objectArray5 = objectArray3;
                objectArray = objectArray4;
                problemHighlightType = problemHighlightType2;
                string5 = string6;
                psiElement2 = psiElement3;
                problemsHolder = problemsHolder2;
                it = nameWithoutCatching;
                RenameToCatchingFix renameToCatchingFix2 = new RenameToCatchingFix((String)it + CATCHING);
                problemsHolder2 = problemsHolder;
                psiElement3 = psiElement2;
                string6 = string5;
                problemHighlightType2 = problemHighlightType;
                objectArray4 = objectArray;
                objectArray3 = objectArray5;
                n = n2;
                renameToCatchingFix = renameToCatchingFix2;
            } else {
                renameToCatchingFix = null;
            }
            objectArray3[n] = renameToCatchingFix;
            nameWithoutCatching = CollectionsKt.listOfNotNull((Object[])objectArray4);
            problemHighlightType = problemHighlightType2;
            string5 = string6;
            psiElement2 = psiElement3;
            problemsHolder = problemsHolder2;
            void v26 = $receiver$iv;
            if (v26 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            void thisCollection$iv = v26;
            LocalQuickFix[] localQuickFixArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
            if (localQuickFixArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            objectArray = localQuickFixArray;
            LocalQuickFix[] localQuickFixArray2 = (LocalQuickFix[])objectArray;
            problemsHolder.registerProblem(psiElement2, string5, problemHighlightType, Arrays.copyOf(localQuickFixArray2, localQuickFixArray2.length));
        }
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return new KtVisitorVoid(this, holder){
            final /* synthetic */ ResultIsResultInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitNamedFunction(@NotNull KtNamedFunction function2) {
                PsiElement psiElement2;
                Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
                KtFunction ktFunction = function2;
                PsiElement psiElement3 = function2.getNameIdentifier();
                if (psiElement3 == null) {
                    psiElement3 = psiElement2 = function2.getFunKeyword();
                }
                if (psiElement3 == null) {
                    psiElement2 = function2;
                }
                ResultIsResultInspection.access$analyzeFunction(this.this$0, ktFunction, psiElement2, this.$holder);
            }

            public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression2) {
                Intrinsics.checkParameterIsNotNull((Object)lambdaExpression2, (String)"lambdaExpression");
                KtFunctionLiteral ktFunctionLiteral = lambdaExpression2.getFunctionLiteral();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktFunctionLiteral, (String)"lambdaExpression.functionLiteral");
                KtFunction ktFunction = ktFunctionLiteral;
                KtFunctionLiteral ktFunctionLiteral2 = lambdaExpression2.getFunctionLiteral();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktFunctionLiteral2, (String)"lambdaExpression.functionLiteral");
                PsiElement psiElement2 = ktFunctionLiteral2.getLBrace();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"lambdaExpression.functionLiteral.lBrace");
                ResultIsResultInspection.access$analyzeFunction(this.this$0, ktFunction, psiElement2, this.$holder);
            }
            {
                this.this$0 = $outer;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    static {
        Companion = new Companion(null);
        ALLOWED_NAMES = SetsKt.setOf((Object[])new String[]{"success", "failure", "runCatching"});
    }

    public static final /* synthetic */ void access$analyzeFunction(ResultIsResultInspection $this, @NotNull KtFunction function2, @NotNull PsiElement toReport, @NotNull ProblemsHolder holder) {
        $this.analyzeFunction(function2, toReport, holder);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0014\u0010\u0010\u001a\u00020\b*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/coroutines/ResultIsResultInspection$AddGetOrThrowFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "withBody", "", "(Z)V", "getWithBody", "()Z", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "addGetOrThrow", "Lorg/jetbrains/kotlin/psi/KtExpression;", "factory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "idea"})
    private static final class AddGetOrThrowFix
    implements LocalQuickFix {
        private final boolean withBody;

        @NotNull
        public String getName() {
            return this.withBody ? "Add '.getOrThrow()' to function result (breaks use-sites!)" : "Unwrap 'Result' return type (breaks use-sites!)";
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        private final void addGetOrThrow(@NotNull KtExpression $receiver, KtPsiFactory factory2) {
            KtExpression getOrThrowExpression = CreateByPatternKt.createExpressionByPattern$default(factory2, "$0.getOrThrow()", new Object[]{$receiver}, false, 4, null);
            $receiver.replace((PsiElement)getOrThrowExpression);
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            block9: {
                KtExpression bodyExpression;
                KtPsiFactory factory2;
                KtFunction function2;
                block8: {
                    KtExpression lastStatement;
                    Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                    Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                    PsiElement psiElement2 = descriptor2.getPsiElement();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"descriptor.psiElement");
                    PsiElement $receiver$iv = psiElement2;
                    KtFunction ktFunction = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtFunction.class, (boolean)false);
                    if (ktFunction == null) {
                        return;
                    }
                    function2 = ktFunction;
                    KtTypeReference returnTypeReference = CallableBuilderKt.getReturnTypeReference(function2);
                    BindingContext context = ResolutionUtils.analyze$default(function2, null, 1, null);
                    SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)context.get(BindingContext.FUNCTION, function2);
                    if (simpleFunctionDescriptor == null) {
                        return;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleFunctionDescriptor, (String)"context[BindingContext.F\u2026TION, function] ?: return");
                    SimpleFunctionDescriptor functionDescriptor2 = simpleFunctionDescriptor;
                    if (returnTypeReference != null) {
                        KotlinType kotlinType = functionDescriptor2.getReturnType();
                        if (kotlinType == null) {
                            return;
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"functionDescriptor.returnType ?: return");
                        KotlinType returnType2 = kotlinType;
                        Object object = (TypeProjection)CollectionsKt.firstOrNull(returnType2.getArguments());
                        if (object == null || (object = object.getType()) == null) {
                            return;
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"returnType.arguments.firstOrNull()?.type ?: return");
                        Object returnTypeArgument = object;
                        PsiModificationUtilsKt.setType$default((KtCallableDeclaration)function2, (KotlinType)returnTypeArgument, false, 2, null);
                    }
                    if (!this.withBody) {
                        return;
                    }
                    factory2 = new KtPsiFactory(project, false, 2, null);
                    KtExpression ktExpression = bodyExpression = function2.getBodyExpression();
                    if (ktExpression != null) {
                        void $receiver$iv2;
                        PsiElement psiElement3 = (PsiElement)ktExpression;
                        Function1 action$iv = (Function1)new Function1<KtReturnExpression, Unit>(this, functionDescriptor2, context, factory2){
                            final /* synthetic */ AddGetOrThrowFix this$0;
                            final /* synthetic */ SimpleFunctionDescriptor $functionDescriptor;
                            final /* synthetic */ BindingContext $context;
                            final /* synthetic */ KtPsiFactory $factory;

                            public final void invoke(@NotNull KtReturnExpression it) {
                                block1: {
                                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                    if (!Intrinsics.areEqual((Object)BindingContextUtilsKt.getTargetFunctionDescriptor(it, this.$context), (Object)this.$functionDescriptor)) break block1;
                                    KtExpression ktExpression = it.getReturnedExpression();
                                    if (ktExpression != null) {
                                        AddGetOrThrowFix.access$addGetOrThrow(this.this$0, ktExpression, this.$factory);
                                    }
                                }
                            }
                            {
                                this.this$0 = addGetOrThrowFix;
                                this.$functionDescriptor = simpleFunctionDescriptor;
                                this.$context = bindingContext2;
                                this.$factory = ktPsiFactory;
                                super(1);
                            }
                        };
                        void $receiver$iv$iv = $receiver$iv2;
                        $receiver$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv){
                            final /* synthetic */ Function1 $action;
                            {
                                this.$action = $captured_local_variable$1;
                            }

                            public void visitElement(@NotNull PsiElement element3) {
                                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                                PsiElement it = element3;
                                super.visitElement(element3);
                                if (element3 instanceof KtReturnExpression) {
                                    this.$action.invoke((Object)element3);
                                }
                            }
                        });
                    }
                    if (!(function2 instanceof KtFunctionLiteral)) break block8;
                    Object object = ((KtFunctionLiteral)function2).getBodyExpression();
                    KtExpression ktExpression2 = object != null && (object = ((KtBlockExpression)object).getStatements()) != null ? (KtExpression)CollectionsKt.lastOrNull((List)object) : (lastStatement = null);
                    if (lastStatement == null || lastStatement instanceof KtReturnExpression) break block9;
                    this.addGetOrThrow(lastStatement, factory2);
                    break block9;
                }
                if (function2.hasBlockBody()) break block9;
                KtExpression ktExpression = bodyExpression;
                if (ktExpression != null) {
                    this.addGetOrThrow(ktExpression, factory2);
                }
            }
        }

        public final boolean getWithBody() {
            return this.withBody;
        }

        public AddGetOrThrowFix(boolean withBody) {
            this.withBody = withBody;
        }

        public static final /* synthetic */ void access$addGetOrThrow(AddGetOrThrowFix $this, @NotNull KtExpression $receiver, @NotNull KtPsiFactory factory2) {
            $this.addGetOrThrow($receiver, factory2);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/coroutines/ResultIsResultInspection$RenameToCatchingFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "newName", "", "(Ljava/lang/String;)V", "getNewName", "()Ljava/lang/String;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "startInWriteAction", "", "idea"})
    private static final class RenameToCatchingFix
    implements LocalQuickFix {
        @NotNull
        private final String newName;

        @NotNull
        public String getName() {
            return "Rename to '" + this.newName + '\'';
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"descriptor.psiElement");
            PsiElement $receiver$iv = psiElement2;
            KtFunction ktFunction = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtFunction.class, (boolean)false);
            if (ktFunction == null) {
                return;
            }
            KtFunction function2 = ktFunction;
            new RenameProcessor(project, (PsiElement)function2, this.newName, false, false).run();
        }

        @NotNull
        public final String getNewName() {
            return this.newName;
        }

        public RenameToCatchingFix(@NotNull String newName2) {
            Intrinsics.checkParameterIsNotNull((Object)newName2, (String)"newName");
            this.newName = newName2;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/coroutines/ResultIsResultInspection$Companion;", "", "()V", "ALLOWED_NAMES", "", "", "CATCHING", "FULL_NAME", "GET_OR_THROW", "SHORT_NAME", "idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

