/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.ChangeCallableReturnTypeFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u0018\u0019\u001a\u001bB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\f\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\"\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\n\u0010\u0017\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;", "element", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;Lorg/jetbrains/kotlin/types/KotlinType;)V", "typeContainsError", "", "typePresentation", "", "typeSourceCode", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "variablePresentation", "ComponentFunctionReturnTypeMismatchFactory", "ForOverridden", "OnType", "PropertyOrReturnTypeMismatchOnOverrideFactory", "idea"})
public class ChangeVariableTypeFix
extends KotlinQuickFixAction<KtVariableDeclaration> {
    private final boolean typeContainsError;
    private final String typePresentation;
    private final String typeSourceCode;

    /*
     * Unable to fully structure code
     */
    @Nullable
    public String variablePresentation() {
        block5: {
            block4: {
                v0 = this.getElement();
                if (v0 == null) {
                    Intrinsics.throwNpe();
                }
                if ((name = (element = (KtVariableDeclaration)v0).getName()) == null) break block4;
                v1 = ResolutionUtils.unsafeResolveToDescriptor$default(element, null, 1, null).getContainingDeclaration();
                if (!(v1 instanceof ClassDescriptor)) {
                    v1 = null;
                }
                if ((v2 = (container = (ClassDescriptor)v1)) == null || (v2 = v2.getName()) == null) ** GOTO lbl-1000
                v3 = it = (var5_4 = v2);
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
                v2 = v3.isSpecial() == false ? var5_4 : null;
                if (v2 != null) {
                    v4 = v2.asString();
                } else lbl-1000:
                // 2 sources

                {
                    v4 = containerName = null;
                }
                v5 = containerName != null ? '\'' + containerName + '.' + name + '\'' : '\'' + name + '\'';
                break block5;
            }
            v5 = null;
        }
        return v5;
    }

    @NotNull
    public String getText() {
        if (this.getElement() == null) {
            return "";
        }
        String variablePresentation = this.variablePresentation();
        return variablePresentation != null ? "Change type of " + variablePresentation + " to '" + this.typePresentation + '\'' : "Change type to '" + this.typePresentation + '\'';
    }

    @NotNull
    public String getFamilyName() {
        String string = KotlinBundle.message("change.type.family", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"KotlinBundle.message(\"change.type.family\")");
        return string;
    }

    @Override
    protected boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return !this.typeContainsError;
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        KtVariableDeclaration ktVariableDeclaration = (KtVariableDeclaration)this.getElement();
        if (ktVariableDeclaration == null) {
            return;
        }
        KtVariableDeclaration element3 = ktVariableDeclaration;
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)file, false, 2, null);
        boolean bl2 = bl = element3.getNameIdentifier() != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "ChangeVariableTypeFix applied to variable without name";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KtTypeReference replacingTypeReference = psiFactory.createType(this.typeSourceCode);
        ArrayList<KtTypeReference> toShorten = new ArrayList<KtTypeReference>();
        KtTypeReference ktTypeReference = element3.setTypeReference(replacingTypeReference);
        if (ktTypeReference == null) {
            Intrinsics.throwNpe();
        }
        toShorten.add(ktTypeReference);
        if (element3 instanceof KtProperty) {
            KtTypeReference setterParameterTypeRef;
            KtDeclarationStub ktDeclarationStub;
            KtTypeReference getterReturnTypeRef;
            KtPropertyAccessor ktPropertyAccessor = ((KtProperty)element3).getGetter();
            KtTypeReference ktTypeReference2 = getterReturnTypeRef = ktPropertyAccessor != null ? ktPropertyAccessor.getReturnTypeReference() : null;
            if (getterReturnTypeRef != null) {
                PsiElement psiElement2 = getterReturnTypeRef.replace(replacingTypeReference);
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtTypeReference");
                }
                toShorten.add((KtTypeReference)psiElement2);
            }
            KtTypeReference ktTypeReference3 = (ktDeclarationStub = ((KtProperty)element3).getSetter()) != null && (ktDeclarationStub = ((KtPropertyAccessor)ktDeclarationStub).getParameter()) != null ? ((KtParameter)ktDeclarationStub).getTypeReference() : (setterParameterTypeRef = null);
            if (setterParameterTypeRef != null) {
                PsiElement psiElement3 = setterParameterTypeRef.replace(replacingTypeReference);
                if (psiElement3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtTypeReference");
                }
                toShorten.add((KtTypeReference)psiElement3);
            }
        }
        ShortenReferences.process$default(ShortenReferences.DEFAULT, toShorten, null, 2, null);
    }

    public ChangeVariableTypeFix(@NotNull KtVariableDeclaration element3, @NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        super((PsiElement)element3);
        this.typeContainsError = ErrorUtils.containsErrorType(type2);
        this.typePresentation = IdeDescriptorRenderers.SOURCE_CODE_TYPES_WITH_SHORT_NAMES.renderType(type2);
        this.typeSourceCode = IdeDescriptorRenderers.SOURCE_CODE_TYPES.renderType(type2);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix$OnType;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "element", "Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;Lorg/jetbrains/kotlin/types/KotlinType;)V", "variablePresentation", "", "idea"})
    public static final class OnType
    extends ChangeVariableTypeFix
    implements HighPriorityAction {
        @Nullable
        public Void variablePresentation() {
            return null;
        }

        public OnType(@NotNull KtVariableDeclaration element3, @NotNull KotlinType type2) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            super(element3, type2);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix$ForOverridden;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix;", "element", "Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;Lorg/jetbrains/kotlin/types/KotlinType;)V", "variablePresentation", "", "idea"})
    public static final class ForOverridden
    extends ChangeVariableTypeFix {
        @Override
        @Nullable
        public String variablePresentation() {
            String string = super.variablePresentation();
            if (string == null) {
                return null;
            }
            String presentation = string;
            return "base property " + presentation;
        }

        public ForOverridden(@NotNull KtVariableDeclaration element3, @NotNull KotlinType type2) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            super(element3, type2);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix$ComponentFunctionReturnTypeMismatchFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class ComponentFunctionReturnTypeMismatchFactory
    extends KotlinSingleIntentionActionFactory {
        public static final ComponentFunctionReturnTypeMismatchFactory INSTANCE;

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            KtDestructuringDeclarationEntry entry = ChangeCallableReturnTypeFix.Companion.getDestructuringDeclarationEntryThatTypeMismatchComponentFunction(diagnostic);
            BindingContext context = ResolutionUtils.analyze$default(entry, null, 1, null);
            ResolvedCall resolvedCall2 = (ResolvedCall)context.get(BindingContext.COMPONENT_RESOLVED_CALL, entry);
            if (resolvedCall2 == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedCall2, (String)"context.get(BindingConte\u2026LL, entry) ?: return null");
            ResolvedCall resolvedCall3 = resolvedCall2;
            Object d = resolvedCall3.getCandidateDescriptor();
            Intrinsics.checkExpressionValueIsNotNull(d, (String)"resolvedCall.candidateDescriptor");
            if (DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)d) == null) {
                return null;
            }
            Object d2 = resolvedCall3.getCandidateDescriptor();
            Intrinsics.checkExpressionValueIsNotNull(d2, (String)"resolvedCall.candidateDescriptor");
            KotlinType kotlinType = ((FunctionDescriptor)d2).getReturnType();
            if (kotlinType == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"resolvedCall.candidateDe\u2026returnType ?: return null");
            KotlinType expectedType = kotlinType;
            return new ChangeVariableTypeFix(entry, expectedType);
        }

        private ComponentFunctionReturnTypeMismatchFactory() {
        }

        static {
            ComponentFunctionReturnTypeMismatchFactory componentFunctionReturnTypeMismatchFactory;
            INSTANCE = componentFunctionReturnTypeMismatchFactory = new ComponentFunctionReturnTypeMismatchFactory();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix$PropertyOrReturnTypeMismatchOnOverrideFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class PropertyOrReturnTypeMismatchOnOverrideFactory
    extends KotlinIntentionActionsFactory {
        public static final PropertyOrReturnTypeMismatchOnOverrideFactory INSTANCE;

        @Override
        @NotNull
        protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            LinkedList<ChangeVariableTypeFix> actions = new LinkedList<ChangeVariableTypeFix>();
            if (diagnostic.getPsiElement() instanceof KtProperty) {
                PropertyDescriptor overriddenProperty;
                PsiElement psiElement2 = diagnostic.getPsiElement();
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
                }
                KtProperty property = (KtProperty)psiElement2;
                DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny(property, BodyResolveMode.FULL);
                if (!(declarationDescriptor instanceof PropertyDescriptor)) {
                    declarationDescriptor = null;
                }
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)declarationDescriptor;
                if (propertyDescriptor == null) {
                    return actions;
                }
                PropertyDescriptor descriptor2 = propertyDescriptor;
                KotlinType lowerBoundOfOverriddenPropertiesTypes = QuickFixUtil.findLowerBoundOfOverriddenCallablesReturnTypes(descriptor2);
                KotlinType kotlinType = descriptor2.getReturnType();
                if (kotlinType == null) {
                    String string = "Property type cannot be null if it mismatches something";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"descriptor.returnType ?:\u2026it mismatches something\")");
                KotlinType propertyType = kotlinType;
                LinkedList<PropertyDescriptor> overriddenMismatchingProperties = new LinkedList<PropertyDescriptor>();
                boolean canChangeOverriddenPropertyType = true;
                Iterator<? extends PropertyDescriptor> iterator2 = descriptor2.getOverriddenDescriptors().iterator();
                while (iterator2.hasNext()) {
                    PropertyDescriptor propertyDescriptor2 = overriddenProperty = iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor2, (String)"overriddenProperty");
                    KotlinType overriddenPropertyType = propertyDescriptor2.getReturnType();
                    if (overriddenPropertyType == null) continue;
                    if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(propertyType, overriddenPropertyType)) {
                        overriddenMismatchingProperties.add(overriddenProperty);
                    } else if (overriddenProperty.isVar() && !KotlinTypeChecker.DEFAULT.equalTypes(overriddenPropertyType, propertyType)) {
                        canChangeOverriddenPropertyType = false;
                    }
                    if (!overriddenProperty.isVar() || lowerBoundOfOverriddenPropertiesTypes == null || KotlinTypeChecker.DEFAULT.equalTypes(lowerBoundOfOverriddenPropertiesTypes, overriddenPropertyType)) continue;
                    lowerBoundOfOverriddenPropertiesTypes = null;
                }
                if (lowerBoundOfOverriddenPropertiesTypes != null) {
                    actions.add(new OnType(property, lowerBoundOfOverriddenPropertiesTypes));
                }
                if (overriddenMismatchingProperties.size() == 1 && canChangeOverriddenPropertyType && (overriddenProperty = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)CollectionsKt.single((List)overriddenMismatchingProperties))) instanceof KtProperty) {
                    actions.add(new ForOverridden((KtVariableDeclaration)((Object)overriddenProperty), propertyType));
                }
            }
            return actions;
        }

        private PropertyOrReturnTypeMismatchOnOverrideFactory() {
        }

        static {
            PropertyOrReturnTypeMismatchOnOverrideFactory propertyOrReturnTypeMismatchOnOverrideFactory;
            INSTANCE = propertyOrReturnTypeMismatchOnOverrideFactory = new PropertyOrReturnTypeMismatchOnOverrideFactory();
        }
    }
}

