/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.RemoveEmptyPrimaryConstructorIntention;
import org.jetbrains.kotlin.idea.quickfix.ChangeFunctionSignatureFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.RemoveUnusedFunctionParameterFix;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.EditCommaSeparatedListHelper;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010\u0010\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveUnusedFunctionParameterFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "parameter", "(Lorg/jetbrains/kotlin/psi/KtParameter;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "runRemoveUnusedTypeParameters", "typeParameters", "", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "startInWriteAction", "", "Companion", "idea"})
public final class RemoveUnusedFunctionParameterFix
extends KotlinQuickFixAction<KtParameter> {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        return ChangeFunctionSignatureFix.Companion.getFAMILY_NAME();
    }

    @NotNull
    public String getText() {
        Object object;
        block3: {
            block2: {
                KtParameter ktParameter;
                object = (KtParameter)this.getElement();
                if (object == null) break block2;
                KtParameter it = ktParameter = object;
                object = "Remove parameter '" + it.getName() + '\'';
                if (object != null) break block3;
            }
            object = "";
        }
        return object;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        RemoveEmptyPrimaryConstructorIntention removeConstructorIntention;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        KtParameter ktParameter = (KtParameter)this.getElement();
        if (ktParameter == null) {
            return;
        }
        KtParameter parameter = ktParameter;
        PsiElement psiElement2 = parameter.getParent();
        if (!(psiElement2 instanceof KtParameterList)) {
            psiElement2 = null;
        }
        KtParameterList ktParameterList = (KtParameterList)psiElement2;
        if (ktParameterList == null) {
            return;
        }
        KtParameterList parameterList = ktParameterList;
        ValueParameterDescriptor valueParameterDescriptor = ResolutionUtils.resolveToParameterDescriptorIfAny(parameter, BodyResolveMode.FULL);
        if (valueParameterDescriptor == null) {
            return;
        }
        ValueParameterDescriptor parameterDescriptor = valueParameterDescriptor;
        int parameterSize = parameterList.getParameters().size();
        List<KtTypeParameter> typeParameters2 = this.typeParameters(parameter);
        PsiElement psiElement3 = parameterList.getParent();
        if (!(psiElement3 instanceof KtPrimaryConstructor)) {
            psiElement3 = null;
        }
        KtPrimaryConstructor primaryConstructor2 = (KtPrimaryConstructor)psiElement3;
        ChangeFunctionSignatureFix.Companion.runRemoveParameter(parameterDescriptor, parameter);
        this.runRemoveUnusedTypeParameters(typeParameters2);
        if (parameterSize > 1) {
            Editor editor2;
            List<KtParameter> list2 = parameterList.getParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"parameterList.parameters");
            KtParameter nextParameter = (KtParameter)CollectionsKt.getOrNull(list2, (int)parameterDescriptor.getIndex());
            if (nextParameter != null && (editor2 = editor) != null && (editor2 = editor2.getCaretModel()) != null) {
                editor2.moveToOffset(PsiUtilsKt.getStartOffset(nextParameter));
            }
        }
        if (primaryConstructor2 != null && (removeConstructorIntention = new RemoveEmptyPrimaryConstructorIntention()).isApplicableTo(primaryConstructor2)) {
            Editor editor3 = editor;
            if (editor3 != null && (editor3 = editor3.getCaretModel()) != null) {
                editor3.moveToOffset(PsiUtilsKt.getEndOffset(primaryConstructor2));
            }
            ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(removeConstructorIntention, primaryConstructor2){
                final /* synthetic */ RemoveEmptyPrimaryConstructorIntention $removeConstructorIntention;
                final /* synthetic */ KtPrimaryConstructor $primaryConstructor;

                public final void invoke() {
                    this.$removeConstructorIntention.applyTo(this.$primaryConstructor, (Editor)null);
                }
                {
                    this.$removeConstructorIntention = removeEmptyPrimaryConstructorIntention;
                    this.$primaryConstructor = ktPrimaryConstructor;
                    super(0);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtTypeParameter> typeParameters(KtParameter parameter) {
        List list2;
        KtTypeParameterListOwnerStub parameterParent2 = (KtTypeParameterListOwnerStub)PsiUtilsKt.getParentOfTypesAndPredicate(parameter, false, new Class[]{KtNamedFunction.class, KtClass.class}, typeParameters.parameterParent.1.INSTANCE);
        KtElement ktElement = parameter.getTypeReference();
        if (ktElement != null && (ktElement = ktElement.getTypeElement()) != null) {
            void $receiver$iv$iv;
            void $receiver$iv$iv$iv;
            Iterable $receiver$iv;
            PsiElement psiElement2 = ktElement;
            Object predicate$iv = typeParameters.1.INSTANCE;
            void $receiver$iv$iv2 = $receiver$iv;
            ArrayList result$iv$iv = new ArrayList();
            Iterator iterator2 = $receiver$iv$iv2;
            Function1 action$iv$iv$iv = (Function1)new Function1<KtNameReferenceExpression, Unit>(predicate$iv, result$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ ArrayList $result;
                {
                    this.$predicate = function1;
                    this.$result = arrayList;
                    super(1);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final void invoke(@NotNull PsiElement it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                        this.$result.add(it);
                    }
                }
            };
            $receiver$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $captured_local_variable$1;
                }

                public void visitElement(@NotNull PsiElement element3) {
                    Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                    PsiElement it = element3;
                    super.visitElement(element3);
                    if (element3 instanceof KtNameReferenceExpression) {
                        this.$action.invoke((Object)element3);
                    }
                }
            });
            $receiver$iv = result$iv$iv;
            predicate$iv = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv2 = $receiver$iv$iv;
            iterator2 = $receiver$iv$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                KtTypeParameter ktTypeParameter;
                KtTypeParameter ktTypeParameter2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                KtNameReferenceExpression it = (KtNameReferenceExpression)element$iv$iv;
                PsiReference psiReference = it.getReference();
                Object object = psiReference != null ? psiReference.resolve() : null;
                if (!(object instanceof KtTypeParameter)) {
                    object = null;
                }
                if ((KtTypeParameter)object == null) {
                    ktTypeParameter2 = null;
                } else {
                    KtTypeParameter typeParameter;
                    KtTypeParameterListOwnerStub parent2 = (KtTypeParameterListOwnerStub)PsiUtilsKt.getParentOfTypesAndPredicate(typeParameter, false, new Class[]{KtNamedFunction.class, KtClass.class}, typeParameters.2.parent.1.INSTANCE);
                    ktTypeParameter2 = Intrinsics.areEqual((Object)parent2, (Object)parameterParent2) ? typeParameter : null;
                }
                if (ktTypeParameter2 == null) continue;
                KtTypeParameter it$iv$iv = ktTypeParameter = ktTypeParameter2;
                destination$iv$iv.add(it$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final void runRemoveUnusedTypeParameters(List<? extends KtTypeParameter> typeParameters2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)typeParameters2;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            KtTypeParameter it = (KtTypeParameter)element$iv$iv;
            if (!(ReferencesSearch.search((PsiElement)it).findFirst() == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unusedTypeParams = (List)destination$iv$iv;
        if (unusedTypeParams.isEmpty()) {
            return;
        }
        ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(unusedTypeParams){
            final /* synthetic */ List $unusedTypeParams;

            public final void invoke() {
                Iterable $receiver$iv = this.$unusedTypeParams;
                for (T element$iv : $receiver$iv) {
                    KtTypeParameterList typeParameterList;
                    KtTypeParameter typeParameter = (KtTypeParameter)element$iv;
                    PsiElement psiElement2 = typeParameter.getParent();
                    if (!(psiElement2 instanceof KtTypeParameterList)) {
                        psiElement2 = null;
                    }
                    if ((KtTypeParameterList)psiElement2 == null) {
                        continue;
                    }
                    if (typeParameterList.getParameters().size() == 1) {
                        typeParameterList.delete();
                        continue;
                    }
                    EditCommaSeparatedListHelper.INSTANCE.removeItem((KtElement)typeParameter);
                }
            }
            {
                this.$unusedTypeParams = list2;
                super(0);
            }
        });
    }

    public RemoveUnusedFunctionParameterFix(@NotNull KtParameter parameter) {
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        super((PsiElement)parameter);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveUnusedFunctionParameterFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected KotlinQuickFixAction<KtParameter> createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            Object d = Errors.UNUSED_PARAMETER.cast(diagnostic);
            Intrinsics.checkExpressionValueIsNotNull(d, (String)"Errors.UNUSED_PARAMETER.cast(diagnostic)");
            Object e = ((DiagnosticWithParameters1)d).getPsiElement();
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"Errors.UNUSED_PARAMETER.\u2026st(diagnostic).psiElement");
            KtParameter parameter = (KtParameter)e;
            PsiElement psiElement2 = parameter.getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"parameter.parent");
            PsiElement parameterOwner = psiElement2.getParent();
            if (parameterOwner instanceof KtFunctionLiteral || parameterOwner instanceof KtNamedFunction && ((KtNamedFunction)parameterOwner).getName() == null) {
                return null;
            }
            return new RemoveUnusedFunctionParameterFix(parameter);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

