/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.pushDown;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.AbstractPullPushMembersHandler;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberInfo;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberInfoStorage;
import org.jetbrains.kotlin.idea.refactoring.pullUp.KotlinPullUpHandlerKt;
import org.jetbrains.kotlin.idea.refactoring.pushDown.KotlinPushDownDialog;
import org.jetbrains.kotlin.idea.refactoring.pushDown.KotlinPushDownHandlerKt;
import org.jetbrains.kotlin.idea.refactoring.pushDown.KotlinPushDownProcessor;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014J\"\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownHandler;", "Lorg/jetbrains/kotlin/idea/refactoring/AbstractPullPushMembersHandler;", "()V", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "member", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "reportFinalClassOrObject", "Companion", "TestHelper", "idea"})
public final class KotlinPushDownHandler
extends AbstractPullPushMembersHandler {
    @NotNull
    private static final String PUSH_DOWN_TEST_HELPER_KEY = "PUSH_DOWN_TEST_HELPER_KEY";
    public static final Companion Companion = new Companion(null);

    private final void reportFinalClassOrObject(Project project, Editor editor, KtClassOrObject classOrObject) {
        String message2 = RefactoringBundle.getCannotRefactorMessage((String)StringsKt.capitalize((String)(RefactoringUIUtil.getDescription((PsiElement)classOrObject, (boolean)false) + " is final")));
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)KotlinPullUpHandlerKt.getPULL_MEMBERS_UP(), (String)"refactoring.pullMembersUp");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable KtClassOrObject classOrObject, @Nullable KtNamedDeclaration member, @Nullable DataContext dataContext) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (classOrObject == null) {
            this.reportWrongContext(project, editor);
            return;
        }
        if (!(classOrObject instanceof KtClass) || !PsiModificationUtilsKt.isInheritable((KtClass)classOrObject)) {
            this.reportFinalClassOrObject(project, editor, classOrObject);
            return;
        }
        List list2 = new KotlinMemberInfoStorage(classOrObject, null, 2, null).getClassMemberInfos(classOrObject);
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"KotlinMemberInfoStorage(\u2026emberInfos(classOrObject)");
        Iterable iterable = $receiver$iv = (Iterable)list2;
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            KotlinMemberInfo it;
            KotlinMemberInfo kotlinMemberInfo = it = (KotlinMemberInfo)((Object)element$iv$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kotlinMemberInfo), (String)"it");
            if (!(!(kotlinMemberInfo.getMember() instanceof KtParameter))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List members2 = (List)destination$iv$iv;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            DataContext dataContext2 = dataContext;
            Object object = dataContext2 != null ? dataContext2.getData(PUSH_DOWN_TEST_HELPER_KEY) : null;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.refactoring.pushDown.KotlinPushDownHandler.TestHelper");
            }
            TestHelper helper2 = (TestHelper)object;
            List<KotlinMemberInfo> selectedMembers = helper2.adjustMembers(members2);
            new KotlinPushDownProcessor(project, (KtClass)classOrObject, selectedMembers).run();
        } else {
            void $receiver$iv$iv2;
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"PsiManager.getInstance(project)");
            PsiManager manager = psiManager;
            Iterable $receiver$iv2 = members2;
            destination$iv$iv = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv2) {
                KotlinMemberInfo it;
                KotlinMemberInfo kotlinMemberInfo = it = (KotlinMemberInfo)((Object)element$iv$iv);
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kotlinMemberInfo), (String)"it");
                if (!manager.areElementsEquivalent(kotlinMemberInfo.getMember(), (PsiElement)member)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $receiver$iv2 = (List)destination$iv$iv2;
            for (Object element$iv : $receiver$iv2) {
                KotlinMemberInfo it;
                KotlinMemberInfo kotlinMemberInfo = it = (KotlinMemberInfo)((Object)element$iv);
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kotlinMemberInfo), (String)"it");
                kotlinMemberInfo.setChecked(true);
            }
            new KotlinPushDownDialog(project, members2, (KtClass)classOrObject).show();
        }
    }

    public KotlinPushDownHandler() {
        String string = KotlinPushDownHandlerKt.getPUSH_MEMBERS_DOWN();
        String string2 = RefactoringBundle.message((String)"the.caret.should.be.positioned.inside.a.class.to.push.members.from");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"RefactoringBundle.messag\u2026ss.to.push.members.from\")");
        super(string, "refactoring.pushMembersDown", string2);
    }

    static {
        PUSH_DOWN_TEST_HELPER_KEY = PUSH_DOWN_TEST_HELPER_KEY;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H&\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownHandler$TestHelper;", "", "adjustMembers", "", "Lorg/jetbrains/kotlin/idea/refactoring/memberInfo/KotlinMemberInfo;", "members", "idea"})
    public static interface TestHelper {
        @NotNull
        public List<KotlinMemberInfo> adjustMembers(@NotNull List<KotlinMemberInfo> var1);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownHandler$Companion;", "", "()V", "PUSH_DOWN_TEST_HELPER_KEY", "", "getPUSH_DOWN_TEST_HELPER_KEY", "()Ljava/lang/String;", "idea"})
    public static final class Companion {
        @NotNull
        public final String getPUSH_DOWN_TEST_HELPER_KEY() {
            return PUSH_DOWN_TEST_HELPER_KEY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

