/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.JavaClassesTrackerImplKt;
import org.jetbrains.kotlin.incremental.SerializedJavaClass;
import org.jetbrains.kotlin.metadata.ProtoBuf;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\f\u0010\f\u001a\u00020\r*\u00020\u0006H\u0002J\u0014\u0010\u000e\u001a\u00020\b*\u00020\n2\u0006\u0010\u000f\u001a\u00020\rH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/incremental/JavaClassProtoMapValueExternalizer;", "Lcom/intellij/util/io/DataExternalizer;", "Lorg/jetbrains/kotlin/incremental/SerializedJavaClass;", "()V", "read", "input", "Ljava/io/DataInput;", "save", "", "output", "Ljava/io/DataOutput;", "value", "readBytesWithSize", "", "writeBytesWithSize", "bytes", "kotlin-build-common"})
public final class JavaClassProtoMapValueExternalizer
implements DataExternalizer<SerializedJavaClass> {
    public static final JavaClassProtoMapValueExternalizer INSTANCE;

    public void save(@NotNull DataOutput output, @NotNull SerializedJavaClass value) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        byte[] byArray = value.getProto().toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"value.proto.toByteArray()");
        this.writeBytesWithSize(output, byArray);
        byte[] byArray2 = value.getStringTable().toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"value.stringTable.toByteArray()");
        this.writeBytesWithSize(output, byArray2);
        byte[] byArray3 = value.getQualifiedNameTable().toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"value.qualifiedNameTable.toByteArray()");
        this.writeBytesWithSize(output, byArray3);
    }

    private final void writeBytesWithSize(@NotNull DataOutput $receiver, byte[] bytes) {
        $receiver.writeInt(bytes.length);
        $receiver.write(bytes);
    }

    private final byte[] readBytesWithSize(@NotNull DataInput $receiver) {
        byte[] byArray;
        int bytesLength = $receiver.readInt();
        byte[] it = byArray = new byte[bytesLength];
        $receiver.readFully(it, 0, bytesLength);
        return byArray;
    }

    @NotNull
    public SerializedJavaClass read(@NotNull DataInput input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        ProtoBuf.Class proto = ProtoBuf.Class.parseFrom(this.readBytesWithSize(input), JavaClassesTrackerImplKt.getJAVA_CLASS_PROTOBUF_REGISTRY());
        ProtoBuf.StringTable stringTable = ProtoBuf.StringTable.parseFrom(this.readBytesWithSize(input), JavaClassesTrackerImplKt.getJAVA_CLASS_PROTOBUF_REGISTRY());
        ProtoBuf.QualifiedNameTable qualifiedNameTable = ProtoBuf.QualifiedNameTable.parseFrom(this.readBytesWithSize(input), JavaClassesTrackerImplKt.getJAVA_CLASS_PROTOBUF_REGISTRY());
        ProtoBuf.Class clazz = proto;
        Intrinsics.checkExpressionValueIsNotNull((Object)clazz, (String)"proto");
        ProtoBuf.StringTable stringTable2 = stringTable;
        Intrinsics.checkExpressionValueIsNotNull((Object)stringTable2, (String)"stringTable");
        ProtoBuf.QualifiedNameTable qualifiedNameTable2 = qualifiedNameTable;
        Intrinsics.checkExpressionValueIsNotNull((Object)qualifiedNameTable2, (String)"qualifiedNameTable");
        return new SerializedJavaClass(clazz, stringTable2, qualifiedNameTable2);
    }

    private JavaClassProtoMapValueExternalizer() {
    }

    static {
        JavaClassProtoMapValueExternalizer javaClassProtoMapValueExternalizer;
        INSTANCE = javaClassProtoMapValueExternalizer = new JavaClassProtoMapValueExternalizer();
    }
}

