/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsLoop;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.util.AstUtil;

public class JsWhile
extends SourceInfoAwareJsNode
implements JsLoop {
    protected JsStatement body;
    protected JsExpression condition;

    public JsWhile() {
    }

    public JsWhile(JsExpression condition2, JsStatement body2) {
        this.condition = condition2;
        this.body = body2;
    }

    public JsStatement getBody() {
        return this.body;
    }

    public JsExpression getCondition() {
        return this.condition;
    }

    public void setBody(JsStatement body2) {
        this.body = body2;
    }

    public void setCondition(JsExpression condition2) {
        this.condition = condition2;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitWhile(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.accept(this.condition);
        visitor2.accept(this.body);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.condition = v.accept(this.condition);
            this.body = v.acceptStatement(this.body);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsWhile deepCopy() {
        JsExpression conditionCopy = AstUtil.deepCopy(this.condition);
        JsStatement bodyCopy = AstUtil.deepCopy(this.body);
        return new JsWhile(conditionCopy, bodyCopy).withMetadataFrom(this);
    }
}

