/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.callTranslator;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.RangeKind;
import org.jetbrains.kotlin.js.backend.ast.metadata.RangeType;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfoKt;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslatorKt$WhenMappings;
import org.jetbrains.kotlin.js.translate.callTranslator.ExplicitReceivers;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallCasesKt;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallInfo;
import org.jetbrains.kotlin.js.translate.callTranslator.RangeCheckTranslator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.utils.InlineUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0005\u001a \u0010\f\u001a\u00020\r2\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a(\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u001a8\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\t2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u001a\u0014\u0010\u0014\u001a\u00020\u0015*\n\u0012\u0006\b\u0001\u0012\u00020\u00130\tH\u0002\u001a\u0012\u0010\u0016\u001a\u00020\u0017*\n\u0012\u0006\b\u0001\u0012\u00020\u00130\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"intRangeToFqName", "Lorg/jetbrains/kotlin/name/FqName;", "longRangeToFqName", "untilFqName", "computeExplicitReceiversForInvoke", "Lorg/jetbrains/kotlin/js/translate/callTranslator/ExplicitReceivers;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "explicitReceivers", "mayBeMarkByRangeMetadata", "", "callExpression", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "translateCall", "translateFunctionCall", "inlineResolvedCall", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "expectedReceivers", "", "getReturnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "js.translator"})
public final class CallTranslatorKt {
    private static final FqName intRangeToFqName = new FqName("kotlin.Int.rangeTo");
    private static final FqName longRangeToFqName = new FqName("kotlin.Long.rangeTo");
    private static final FqName untilFqName = new FqName("kotlin.ranges.until");

    private static final boolean expectedReceivers(@NotNull ResolvedCall<? extends CallableDescriptor> $receiver) {
        return $receiver.getExplicitReceiverKind() != ExplicitReceiverKind.NO_EXPLICIT_RECEIVER;
    }

    private static final JsExpression translateCall(TranslationContext context, ResolvedCall<? extends FunctionDescriptor> resolvedCall2, ExplicitReceivers explicitReceivers) {
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
            ExplicitReceivers explicitReceivers2;
            ResolvedCall<CallableDescriptor> inlineCall2;
            KotlinType kotlinType;
            boolean bl;
            boolean bl2 = bl = explicitReceivers.getExtensionReceiver() == null;
            if (_Assertions.ENABLED && !bl) {
                String string = "VariableAsFunctionResolvedCall must have one receiver";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            ResolvedCall<VariableDescriptor> variableCall = ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall();
            VariableDescriptor variableDescriptor = variableCall.getResultingDescriptor();
            Intrinsics.checkExpressionValueIsNotNull((Object)variableDescriptor, (String)"variableCall.resultingDescriptor");
            KotlinType $receiver = kotlinType = variableDescriptor.getType();
            boolean isFunctionType = FunctionTypesKt.isFunctionTypeOrSubtype($receiver) || FunctionTypesKt.isSuspendFunctionTypeOrSubtype($receiver);
            ResolvedCall<CallableDescriptor> resolvedCall3 = inlineCall2 = isFunctionType ? variableCall : resolvedCall2;
            if (CallTranslatorKt.expectedReceivers(variableCall)) {
                JsExpression newReceiver = CallTranslator.INSTANCE.translateGet(context, variableCall, explicitReceivers.getExtensionOrDispatchReceiver());
                explicitReceivers2 = new ExplicitReceivers(newReceiver, null, 2, null);
            } else {
                JsExpression dispatchReceiver = CallTranslator.INSTANCE.translateGet(context, variableCall, null);
                explicitReceivers2 = explicitReceivers.getExtensionOrDispatchReceiver() == null ? new ExplicitReceivers(dispatchReceiver, null, 2, null) : new ExplicitReceivers(dispatchReceiver, explicitReceivers.getExtensionOrDispatchReceiver());
            }
            ExplicitReceivers newExplicitReceivers = explicitReceivers2;
            return CallTranslatorKt.translateFunctionCall(context, ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getFunctionCall(), inlineCall2, newExplicitReceivers);
        }
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"resolvedCall.call");
        Call call3 = call2;
        if (call3.getCallType() == Call.CallType.INVOKE && !CallResolverUtilKt.isInvokeCallOnVariable(call3)) {
            ExplicitReceivers explicitReceiversForInvoke = CallTranslatorKt.computeExplicitReceiversForInvoke(context, resolvedCall2, explicitReceivers);
            return CallTranslatorKt.translateFunctionCall(context, resolvedCall2, resolvedCall2, explicitReceiversForInvoke);
        }
        return CallTranslatorKt.translateFunctionCall(context, resolvedCall2, resolvedCall2, explicitReceivers);
    }

    private static final JsExpression translateFunctionCall(TranslationContext context, ResolvedCall<? extends FunctionDescriptor> resolvedCall2, ResolvedCall<? extends CallableDescriptor> inlineResolvedCall, ExplicitReceivers explicitReceivers) {
        Object ktExpression;
        JsExpression rangeCheck = new RangeCheckTranslator(context).translateAsRangeCheck(resolvedCall2, explicitReceivers);
        if (rangeCheck != null) {
            return rangeCheck;
        }
        FunctionCallInfo callInfo = CallInfoKt.getCallInfo(context, resolvedCall2, explicitReceivers);
        JsExpression callExpression2 = FunctionCallCasesKt.translateFunctionCall(callInfo);
        if (CallExpressionTranslator.shouldBeInlined(inlineResolvedCall.getResultingDescriptor(), context)) {
            KtElement ktElement;
            Call call2 = resolvedCall2.getCall();
            Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"resolvedCall.call");
            KtElement ktElement2 = call2.getCallElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktElement2, (String)"resolvedCall.call.callElement");
            KtElement callElement2 = ktElement2;
            KtElement ktElement3 = callElement2;
            if (!(ktElement3 instanceof KtWhenConditionInRange)) {
                ktElement3 = null;
            }
            if ((ktElement = (KtWhenConditionInRange)ktElement3) == null || (ktElement = ktElement.getRangeExpression()) == null) {
                KtElement ktElement4 = callElement2;
                if (ktElement4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                ktElement = (KtExpression)ktElement4;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"(callElement as? KtWhenC\u2026llElement as KtExpression");
            ktExpression = ktElement;
            InlineUtils.setInlineCallMetadata(callExpression2, (KtExpression)ktExpression, inlineResolvedCall.getResultingDescriptor(), context);
        }
        if (resolvedCall2.getResultingDescriptor().isSuspend()) {
            ktExpression = callExpression2;
            FunctionCallInfo functionCallInfo = callInfo;
            JsExpression $receiver = ktExpression;
            MetadataProperties.setSuspend($receiver, true);
            Call call3 = resolvedCall2.getCall();
            Intrinsics.checkExpressionValueIsNotNull((Object)call3, (String)"resolvedCall.call");
            $receiver.setSource(call3.getCallElement());
            JsExpression jsExpression = ktExpression;
            JsStatement jsStatement = JsAstUtils.asSyntheticStatement(jsExpression);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsStatement, (String)"JsAstUtils.asSyntheticSt\u2026ll.callElement\n        })");
            JsStatement statement2 = functionCallInfo.constructSuspendSafeCallIfNeeded(jsStatement);
            JsBlock jsBlock = context.getCurrentBlock();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsBlock, (String)"context.currentBlock");
            ktExpression = jsBlock.getStatements();
            ktExpression.add(statement2);
            return UtilsKt.createCoroutineResult(context, resolvedCall2);
        }
        callExpression2 = callInfo.constructSafeCallIfNeeded(callExpression2);
        KotlinType kotlinType = CallTranslatorKt.getReturnType(resolvedCall2);
        JsExpression jsExpression = callExpression2;
        KotlinType it = kotlinType;
        Call call4 = resolvedCall2.getCall();
        Intrinsics.checkExpressionValueIsNotNull((Object)call4, (String)"resolvedCall.call");
        KotlinType kotlinType2 = CallUtilKt.isSafeCall(call4) ? TypeUtilsKt.makeNullable(it) : it;
        MetadataProperties.setType(jsExpression, kotlinType2);
        CallTranslatorKt.mayBeMarkByRangeMetadata(resolvedCall2, callExpression2);
        return callExpression2;
    }

    private static final void mayBeMarkByRangeMetadata(ResolvedCall<? extends FunctionDescriptor> resolvedCall2, JsExpression callExpression2) {
        FqName fqName2 = DescriptorUtilsKt.getFqNameSafe(resolvedCall2.getResultingDescriptor());
        if (Intrinsics.areEqual((Object)fqName2, (Object)intRangeToFqName)) {
            MetadataProperties.setRange(callExpression2, (Pair<? extends RangeType, ? extends RangeKind>)new Pair((Object)RangeType.INT, (Object)RangeKind.RANGE_TO));
        } else if (Intrinsics.areEqual((Object)fqName2, (Object)longRangeToFqName)) {
            MetadataProperties.setRange(callExpression2, (Pair<? extends RangeType, ? extends RangeKind>)new Pair((Object)RangeType.LONG, (Object)RangeKind.RANGE_TO));
        } else if (Intrinsics.areEqual((Object)fqName2, (Object)untilFqName)) {
            FqNameUnsafe fqNameUnsafe;
            Object object = resolvedCall2.getResultingDescriptor().getReturnType();
            FqNameUnsafe fqNameUnsafe2 = object != null && (object = ((KotlinType)object).getConstructor()) != null && (object = object.getDeclarationDescriptor()) != null ? DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)object) : (fqNameUnsafe = null);
            if (Intrinsics.areEqual(fqNameUnsafe, (Object)KotlinBuiltIns.FQ_NAMES.intRange)) {
                MetadataProperties.setRange(callExpression2, (Pair<? extends RangeType, ? extends RangeKind>)new Pair((Object)RangeType.INT, (Object)RangeKind.UNTIL));
            } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)KotlinBuiltIns.FQ_NAMES.longRange)) {
                MetadataProperties.setRange(callExpression2, (Pair<? extends RangeType, ? extends RangeKind>)new Pair((Object)RangeType.LONG, (Object)RangeKind.UNTIL));
            }
        }
    }

    @NotNull
    public static final KotlinType getReturnType(@NotNull ResolvedCall<? extends CallableDescriptor> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        KotlinType kotlinType = TranslationUtils.getReturnTypeForCoercion($receiver.getResultingDescriptor());
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"TranslationUtils.getRetu\u2026cion(resultingDescriptor)");
        return kotlinType;
    }

    @NotNull
    public static final ExplicitReceivers computeExplicitReceiversForInvoke(@NotNull TranslationContext context, @NotNull ResolvedCall<? extends FunctionDescriptor> resolvedCall2, @NotNull ExplicitReceivers explicitReceivers) {
        ExplicitReceivers explicitReceivers2;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)explicitReceivers, (String)"explicitReceivers");
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"resolvedCall.call");
        KtElement ktElement = call2.getCallElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"resolvedCall.call.callElement");
        KtElement callElement2 = ktElement;
        boolean bl2 = bl = explicitReceivers.getExtensionReceiver() == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "'Invoke' call must have one receiver: " + callElement2;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Function1<ReceiverValue, JsExpression> translateReceiverAsExpression$ = new Function1<ReceiverValue, JsExpression>(context){
            final /* synthetic */ TranslationContext $context;

            @Nullable
            public final JsExpression invoke(@Nullable ReceiverValue receiver) {
                JsExpression jsExpression;
                ReceiverValue receiverValue = receiver;
                if (!(receiverValue instanceof ExpressionReceiver)) {
                    receiverValue = null;
                }
                ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue;
                if (expressionReceiver != null) {
                    ExpressionReceiver expressionReceiver2;
                    ExpressionReceiver it = expressionReceiver2 = expressionReceiver;
                    jsExpression = Translation.translateAsExpression(it.getExpression(), this.$context);
                } else {
                    jsExpression = null;
                }
                return jsExpression;
            }
            {
                this.$context = translationContext;
                super(1);
            }
        };
        ReceiverValue dispatchReceiver = resolvedCall2.getDispatchReceiver();
        ReceiverValue extensionReceiver2 = resolvedCall2.getExtensionReceiver();
        if (dispatchReceiver != null && extensionReceiver2 != null && resolvedCall2.getExplicitReceiverKind() == ExplicitReceiverKind.BOTH_RECEIVERS) {
            boolean bl3;
            boolean bl4 = bl3 = explicitReceivers.getExtensionOrDispatchReceiver() != null;
            if (_Assertions.ENABLED && !bl3) {
                String string = "No explicit receiver for 'invoke' resolved call with both receivers: " + callElement2 + ", text: " + callElement2.getText() + "Dispatch receiver: " + dispatchReceiver + " Extension receiver: " + extensionReceiver2;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        } else {
            boolean bl5;
            boolean bl6 = bl5 = explicitReceivers.getExtensionOrDispatchReceiver() == null;
            if (_Assertions.ENABLED && !bl5) {
                String string = "Non trivial explicit receiver " + explicitReceivers.getExtensionOrDispatchReceiver() + '\n' + "for 'invoke' resolved call: " + callElement2 + ", text: " + callElement2.getText() + '\n' + "Dispatch receiver: " + dispatchReceiver + " Extension receiver: " + extensionReceiver2;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
        switch (CallTranslatorKt$WhenMappings.$EnumSwitchMapping$0[resolvedCall2.getExplicitReceiverKind().ordinal()]) {
            case 1: {
                explicitReceivers2 = new ExplicitReceivers(null, null, 2, null);
                break;
            }
            case 2: {
                explicitReceivers2 = new ExplicitReceivers(translateReceiverAsExpression$.invoke(dispatchReceiver), null, 2, null);
                break;
            }
            case 3: {
                explicitReceivers2 = new ExplicitReceivers(translateReceiverAsExpression$.invoke(extensionReceiver2), null, 2, null);
                break;
            }
            case 4: {
                explicitReceivers2 = new ExplicitReceivers(translateReceiverAsExpression$.invoke(dispatchReceiver), translateReceiverAsExpression$.invoke(extensionReceiver2));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return explicitReceivers2;
    }

    @NotNull
    public static final /* synthetic */ JsExpression access$translateCall(@NotNull TranslationContext context, @NotNull ResolvedCall resolvedCall2, @NotNull ExplicitReceivers explicitReceivers) {
        return CallTranslatorKt.translateCall(context, resolvedCall2, explicitReceivers);
    }
}

