/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.builders.PrimitivesKt;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.impl.IrBinaryPrimitiveImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrErrorExpressionImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrTypeOperatorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrUnaryPrimitiveImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.impl.IrTypeBaseKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.ReferenceSymbolTable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.KotlinUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.ArgumentsGenerationUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.AssignmentGenerator;
import org.jetbrains.kotlin.psi2ir.generators.CallGenerator;
import org.jetbrains.kotlin.psi2ir.generators.CallGeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.OperatorConventionsKt;
import org.jetbrains.kotlin.psi2ir.generators.OperatorExpressionGenerator$WhenMappings;
import org.jetbrains.kotlin.psi2ir.generators.StatementGenerator;
import org.jetbrains.kotlin.psi2ir.generators.StatementGeneratorExtension;
import org.jetbrains.kotlin.psi2ir.intermediate.SafeCallReceiverKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.PrimitiveNumericComparisonInfo;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0010H\u0002J&\u0010\u0014\u001a\u00020\f2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0010H\u0002J\u000e\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0018J\u0018\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J8\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\f2\b\u0010!\u001a\u0004\u0018\u00010\"J\u0018\u0010#\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010$\u001a\u00020\f2\u0006\u0010\r\u001a\u00020%2\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\u0018\u0010&\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010'\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010(\u001a\u00020)2\u0006\u0010\r\u001a\u00020*J\u000e\u0010+\u001a\u00020\f2\u0006\u0010\r\u001a\u00020%J\u000e\u0010,\u001a\u00020\f2\u0006\u0010\r\u001a\u00020-J\u0018\u0010.\u001a\u00020\f2\u0006\u0010\r\u001a\u00020-2\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\u0018\u0010/\u001a\u0002002\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u00101\u001a\u000202H\u0002J\u0012\u00103\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0007\u001a\u00020\u000eH\u0002J(\u00104\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\fH\u0002J\u0016\u00108\u001a\u0004\u0018\u000106*\u0002022\u0006\u00109\u001a\u000202H\u0002J \u0010:\u001a\u00020\f*\u00020\b2\b\u0010;\u001a\u0004\u0018\u0001022\b\u0010<\u001a\u0004\u0018\u000102H\u0002J \u0010=\u001a\u00020\f*\u00020\f2\b\u0010>\u001a\u0004\u0018\u0001022\b\u00109\u001a\u0004\u0018\u000102H\u0002\u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/OperatorExpressionGenerator;", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGeneratorExtension;", "statementGenerator", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;", "(Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;)V", "createErrorExpression", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrErrorExpressionImpl;", "ktExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "text", "", "generateBinaryBooleanOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "irOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "generateBinaryExpression", "generateBinaryOperatorAsCall", "origin", "generateCall", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "generateCastExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "generateComparisonOperator", "generateElvis", "generateEquality", "startOffset", "", "endOffset", "arg1", "arg2", "comparisonInfo", "Lorg/jetbrains/kotlin/resolve/checkers/PrimitiveNumericComparisonInfo;", "generateEqualityOperator", "generateExclExclOperator", "Lorg/jetbrains/kotlin/psi/KtPostfixExpression;", "generateIdentityOperator", "generateInOperator", "generateInstanceOfExpression", "Lorg/jetbrains/kotlin/ir/IrStatement;", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "generatePostfixExpression", "generatePrefixExpression", "Lorg/jetbrains/kotlin/psi/KtPrefixExpression;", "generatePrefixOperatorAsCall", "getComparisonOperatorSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "primitiveNumericType", "Lorg/jetbrains/kotlin/types/KotlinType;", "getPrimitiveNumericComparisonInfo", "invokeConversionFunction", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "receiver", "findConversionFunctionTo", "targetType", "generateAsPrimitiveNumericComparisonOperand", "expressionType", "comparisonType", "promoteToPrimitiveNumericType", "operandType", "ir.psi2ir"})
public final class OperatorExpressionGenerator
extends StatementGeneratorExtension {
    private final IrErrorExpressionImpl createErrorExpression(KtExpression ktExpression, String text2) {
        return new IrErrorExpressionImpl(PsiUtilsKt.getStartOffset((PsiElement)ktExpression), PsiUtilsKt.getEndOffset((PsiElement)ktExpression), this.getContext().getIrBuiltIns().getNothingType(), text2);
    }

    @NotNull
    public final IrExpression generatePrefixExpression(@NotNull KtPrefixExpression expression2) {
        IrExpression irExpression;
        IrStatementOrigin irOperator;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IElementType ktOperator = expression2.getOperationReference().getReferencedNameElementType();
        IrStatementOrigin irStatementOrigin = irOperator = OperatorConventionsKt.getPrefixOperator(ktOperator);
        if (irStatementOrigin == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected prefix operator: " + ktOperator)));
        }
        if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getINCREMENT_DECREMENT_OPERATORS(), (Object)irStatementOrigin)) {
            irExpression = new AssignmentGenerator(this.getStatementGenerator()).generatePrefixIncrementDecrement(expression2, irOperator);
        } else if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getOPERATORS_DESUGARED_TO_CALLS(), (Object)irStatementOrigin)) {
            irExpression = this.generatePrefixOperatorAsCall(expression2, irOperator);
        } else {
            KtExpression ktExpression = expression2;
            String string = ktOperator.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ktOperator.toString()");
            irExpression = this.createErrorExpression(ktExpression, string);
        }
        return irExpression;
    }

    @NotNull
    public final IrExpression generatePostfixExpression(@NotNull KtPostfixExpression expression2) {
        IrExpression irExpression;
        IrStatementOrigin irOperator;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IElementType ktOperator = expression2.getOperationReference().getReferencedNameElementType();
        IrStatementOrigin irStatementOrigin = irOperator = OperatorConventionsKt.getPostfixOperator(ktOperator);
        if (irStatementOrigin == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected postfix operator: " + ktOperator)));
        }
        if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getINCREMENT_DECREMENT_OPERATORS(), (Object)irStatementOrigin)) {
            irExpression = new AssignmentGenerator(this.getStatementGenerator()).generatePostfixIncrementDecrement(expression2, irOperator);
        } else if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.EXCLEXCL.INSTANCE)) {
            irExpression = this.generateExclExclOperator(expression2, irOperator);
        } else {
            KtExpression ktExpression = expression2;
            String string = ktOperator.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ktOperator.toString()");
            irExpression = this.createErrorExpression(ktExpression, string);
        }
        return irExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final IrExpression generateCastExpression(@NotNull KtBinaryExpressionWithTypeRHS expression2) {
        KotlinType kotlinType;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IElementType ktOperator = expression2.getOperationReference().getReferencedNameElementType();
        IrTypeOperator irOperator = OperatorConventionsKt.getIrTypeOperator(ktOperator);
        WritableSlice<KtTypeReference, KotlinType> writableSlice = BindingContext.TYPE;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice, (String)"BindingContext.TYPE");
        ReadOnlySlice readOnlySlice = writableSlice;
        KtTypeReference ktTypeReference = expression2.getRight();
        if (ktTypeReference == null) {
            Intrinsics.throwNpe();
        }
        KotlinType rhsType = (KotlinType)GeneratorKt.getOrFail(this, readOnlySlice, ktTypeReference);
        IrTypeOperator irTypeOperator = irOperator;
        if (irTypeOperator == null) throw (Throwable)((Object)new AssertionError((Object)("Unexpected IrTypeOperator: " + (Object)((Object)irOperator))));
        switch (OperatorExpressionGenerator$WhenMappings.$EnumSwitchMapping$0[irTypeOperator.ordinal()]) {
            case 1: {
                kotlinType = rhsType;
                break;
            }
            case 2: {
                KotlinType kotlinType2 = rhsType;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"rhsType");
                kotlinType = TypeUtilsKt.makeNullable(kotlinType2);
                break;
            }
            default: {
                throw (Throwable)((Object)new AssertionError((Object)("Unexpected IrTypeOperator: " + (Object)((Object)irOperator))));
            }
        }
        KotlinType resultType = kotlinType;
        int n = PsiUtilsKt.getStartOffset((PsiElement)expression2);
        int n2 = PsiUtilsKt.getEndOffset((PsiElement)expression2);
        KotlinType kotlinType3 = resultType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"resultType");
        IrType irType = this.toIrType(kotlinType3);
        KotlinType kotlinType4 = rhsType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType4, (String)"rhsType");
        IrType irType2 = this.toIrType(kotlinType4);
        ReferenceSymbolTable referenceSymbolTable = this.getContext().getSymbolTable();
        ClassifierDescriptor classifierDescriptor = rhsType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            Intrinsics.throwNpe();
        }
        IrClassifierSymbol irClassifierSymbol = IrUtilsKt.referenceClassifier(referenceSymbolTable, classifierDescriptor);
        KtExpression ktExpression = expression2.getLeft();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.left");
        return new IrTypeOperatorCallImpl(n, n2, irType, irOperator, irType2, irClassifierSymbol, this.genExpr(ktExpression));
    }

    @NotNull
    public final IrStatement generateInstanceOfExpression(@NotNull KtIsExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IElementType ktOperator = expression2.getOperationReference().getReferencedNameElementType();
        IrTypeOperator irTypeOperator = OperatorConventionsKt.getIrTypeOperator(ktOperator);
        if (irTypeOperator == null) {
            Intrinsics.throwNpe();
        }
        IrTypeOperator irOperator = irTypeOperator;
        WritableSlice<KtTypeReference, KotlinType> writableSlice = BindingContext.TYPE;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice, (String)"BindingContext.TYPE");
        KotlinType againstType = (KotlinType)GeneratorKt.getOrFail(this, writableSlice, expression2.getTypeReference());
        int n = PsiUtilsKt.getStartOffset((PsiElement)expression2);
        int n2 = PsiUtilsKt.getEndOffset((PsiElement)expression2);
        IrType irType = this.getContext().getIrBuiltIns().getBooleanType();
        KotlinType kotlinType = againstType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"againstType");
        IrType irType2 = this.toIrType(kotlinType);
        ReferenceSymbolTable referenceSymbolTable = this.getContext().getSymbolTable();
        ClassifierDescriptor classifierDescriptor = againstType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            Intrinsics.throwNpe();
        }
        IrClassifierSymbol irClassifierSymbol = IrUtilsKt.referenceClassifier(referenceSymbolTable, classifierDescriptor);
        KtExpression ktExpression = expression2.getLeftHandSide();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.leftHandSide");
        return new IrTypeOperatorCallImpl(n, n2, irType, irOperator, irType2, irClassifierSymbol, this.genExpr(ktExpression));
    }

    @NotNull
    public final IrExpression generateBinaryExpression(@NotNull KtBinaryExpression expression2) {
        IrExpression irExpression;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IElementType ktOperator = expression2.getOperationReference().getReferencedNameElementType();
        if (Intrinsics.areEqual((Object)ktOperator, (Object)((Object)KtTokens.IDENTIFIER))) {
            return this.generateBinaryOperatorAsCall(expression2, null);
        }
        IrStatementOrigin irOperator = OperatorConventionsKt.getInfixOperator(ktOperator);
        IrStatementOrigin irStatementOrigin = irOperator;
        if (irStatementOrigin == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected infix operator: " + ktOperator)));
        }
        if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.EQ.INSTANCE)) {
            irExpression = new AssignmentGenerator(this.getStatementGenerator()).generateAssignment(expression2);
        } else if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getAUGMENTED_ASSIGNMENTS(), (Object)irStatementOrigin)) {
            irExpression = new AssignmentGenerator(this.getStatementGenerator()).generateAugmentedAssignment(expression2, irOperator);
        } else if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.ELVIS.INSTANCE)) {
            irExpression = this.generateElvis(expression2);
        } else if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getOPERATORS_DESUGARED_TO_CALLS(), (Object)irStatementOrigin)) {
            irExpression = this.generateBinaryOperatorAsCall(expression2, irOperator);
        } else if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getCOMPARISON_OPERATORS(), (Object)irStatementOrigin)) {
            irExpression = this.generateComparisonOperator(expression2, irOperator);
        } else if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getEQUALITY_OPERATORS(), (Object)irStatementOrigin)) {
            irExpression = this.generateEqualityOperator(expression2, irOperator);
        } else if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getIDENTITY_OPERATORS(), (Object)irStatementOrigin)) {
            irExpression = this.generateIdentityOperator(expression2, irOperator);
        } else if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getIN_OPERATORS(), (Object)irStatementOrigin)) {
            irExpression = this.generateInOperator(expression2, irOperator);
        } else if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getBINARY_BOOLEAN_OPERATORS(), (Object)irStatementOrigin)) {
            irExpression = this.generateBinaryBooleanOperator(expression2, irOperator);
        } else {
            KtExpression ktExpression = expression2;
            String string = ktOperator.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ktOperator.toString()");
            irExpression = this.createErrorExpression(ktExpression, string);
        }
        return irExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateElvis(KtBinaryExpression expression2) {
        void this_$iv$iv;
        void endOffset$iv;
        void startOffset$iv;
        void $receiver$iv;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, expression2);
        if (resolvedCall2 == null) {
            Intrinsics.throwNpe();
        }
        ResolvedCall<? extends CallableDescriptor> specialCallForElvis = resolvedCall2;
        KotlinType kotlinType = specialCallForElvis.getResultingDescriptor().getReturnType();
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"specialCallForElvis.resu\u2026ngDescriptor.returnType!!");
        IrType resultType = this.toIrType(kotlinType);
        KtExpression ktExpression = expression2.getLeft();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.left!!");
        IrExpression irArgument0 = this.genExpr(ktExpression);
        KtExpression ktExpression2 = expression2.getRight();
        if (ktExpression2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"expression.right!!");
        IrExpression irArgument1 = this.genExpr(ktExpression2);
        OperatorExpressionGenerator operatorExpressionGenerator = this;
        int n = PsiUtilsKt.getStartOffset((PsiElement)expression2);
        int n2 = PsiUtilsKt.getEndOffset((PsiElement)expression2);
        IrStatementOrigin origin$iv = IrStatementOrigin.ELVIS.INSTANCE;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($receiver$iv.getContext(), $receiver$iv.getScope(), (int)startOffset$iv, (int)endOffset$iv, origin$iv, resultType, false, 64, null);
        void $receiver = this_$iv$iv;
        IrVariable temporary = ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$receiver, irArgument0, "elvis_lhs", null, 4, null);
        $receiver.unaryPlus(ExpressionHelpersKt.irIfNull((IrBuilderWithScope)$receiver, resultType, ExpressionHelpersKt.irGet((IrBuilderWithScope)$receiver, temporary.getType(), temporary.getSymbol()), irArgument1, ExpressionHelpersKt.irGet((IrBuilderWithScope)$receiver, temporary.getType(), temporary.getSymbol())));
        return this_$iv$iv.doBuild();
    }

    private final IrExpression generateBinaryBooleanOperator(KtBinaryExpression expression2, IrStatementOrigin irOperator) {
        IrWhen irWhen;
        KtExpression ktExpression = expression2.getLeft();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.left!!");
        IrExpression irArgument0 = this.genExpr(ktExpression);
        KtExpression ktExpression2 = expression2.getRight();
        if (ktExpression2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"expression.right!!");
        IrExpression irArgument1 = this.genExpr(ktExpression2);
        IrStatementOrigin irStatementOrigin = irOperator;
        if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.OROR.INSTANCE)) {
            irWhen = PrimitivesKt.oror$default(this.getContext(), PsiUtilsKt.getStartOffset((PsiElement)expression2), PsiUtilsKt.getEndOffset((PsiElement)expression2), irArgument0, irArgument1, null, 16, null);
        } else if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.ANDAND.INSTANCE)) {
            irWhen = PrimitivesKt.andand$default(this.getContext(), PsiUtilsKt.getStartOffset((PsiElement)expression2), PsiUtilsKt.getEndOffset((PsiElement)expression2), irArgument0, irArgument1, null, 16, null);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected binary boolean operator " + irOperator)));
        }
        return irWhen;
    }

    private final IrExpression generateInOperator(KtBinaryExpression expression2, IrStatementOrigin irOperator) {
        IrExpression irExpression;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, expression2);
        if (resolvedCall2 == null) {
            Intrinsics.throwNpe();
        }
        ResolvedCall<? extends CallableDescriptor> containsCall = resolvedCall2;
        IrExpression irContainsCall = this.generateCall(containsCall, expression2, irOperator);
        IrStatementOrigin irStatementOrigin = irOperator;
        if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.IN.INSTANCE)) {
            irExpression = irContainsCall;
        } else if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.NOT_IN.INSTANCE)) {
            irExpression = new IrUnaryPrimitiveImpl(PsiUtilsKt.getStartOffset((PsiElement)expression2), PsiUtilsKt.getEndOffset((PsiElement)expression2), this.getContext().getIrBuiltIns().getBooleanType(), (IrStatementOrigin)IrStatementOrigin.NOT_IN.INSTANCE, (IrFunctionSymbol)this.getContext().getIrBuiltIns().getBooleanNotSymbol(), irContainsCall);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected in-operator " + irOperator)));
        }
        return irExpression;
    }

    private final IrExpression generateIdentityOperator(KtBinaryExpression expression2, IrStatementOrigin irOperator) {
        IrCall irCall;
        KtExpression ktExpression = expression2.getLeft();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.left!!");
        IrExpression irArgument0 = this.genExpr(ktExpression);
        KtExpression ktExpression2 = expression2.getRight();
        if (ktExpression2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"expression.right!!");
        IrExpression irArgument1 = this.genExpr(ktExpression2);
        IrBinaryPrimitiveImpl irIdentityEquals = new IrBinaryPrimitiveImpl(PsiUtilsKt.getStartOffset((PsiElement)expression2), PsiUtilsKt.getEndOffset((PsiElement)expression2), this.getContext().getIrBuiltIns().getBooleanType(), irOperator, this.getContext().getIrBuiltIns().getEqeqeqSymbol(), irArgument0, irArgument1);
        IrStatementOrigin irStatementOrigin = irOperator;
        if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.EQEQEQ.INSTANCE)) {
            irCall = irIdentityEquals;
        } else if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.EXCLEQEQ.INSTANCE)) {
            irCall = new IrUnaryPrimitiveImpl(PsiUtilsKt.getStartOffset((PsiElement)expression2), PsiUtilsKt.getEndOffset((PsiElement)expression2), this.getContext().getIrBuiltIns().getBooleanType(), (IrStatementOrigin)IrStatementOrigin.EXCLEQEQ.INSTANCE, (IrFunctionSymbol)this.getContext().getIrBuiltIns().getBooleanNotSymbol(), (IrExpression)irIdentityEquals);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected identity operator " + irOperator)));
        }
        return irCall;
    }

    private final IrExpression generateAsPrimitiveNumericComparisonOperand(@NotNull KtExpression $receiver, KotlinType expressionType, KotlinType comparisonType) {
        return this.promoteToPrimitiveNumericType(this.genExpr($receiver), expressionType, comparisonType);
    }

    private final PrimitiveNumericComparisonInfo getPrimitiveNumericComparisonInfo(KtBinaryExpression ktExpression) {
        return (PrimitiveNumericComparisonInfo)this.getContext().getBindingContext().get(BindingContext.PRIMITIVE_NUMERIC_COMPARISON_INFO, ktExpression);
    }

    private final IrExpression generateEqualityOperator(KtBinaryExpression expression2, IrStatementOrigin irOperator) {
        IrCall irCall;
        PrimitiveNumericComparisonInfo comparisonInfo;
        PrimitiveNumericComparisonInfo primitiveNumericComparisonInfo = comparisonInfo = this.getPrimitiveNumericComparisonInfo(expression2);
        KotlinType comparisonType = primitiveNumericComparisonInfo != null ? primitiveNumericComparisonInfo.getComparisonType() : null;
        Map<SimpleType, IrSimpleFunction> map2 = this.getContext().getIrBuiltIns().getIeee754equalsFunByOperandType();
        Object object = map2.get(comparisonType);
        if (object == null || (object = (IrSimpleFunctionSymbol)object.getSymbol()) == null) {
            object = this.getContext().getIrBuiltIns().getEqeqSymbol();
        }
        Object eqeqSymbol = object;
        int n = PsiUtilsKt.getStartOffset((PsiElement)expression2);
        int n2 = PsiUtilsKt.getEndOffset((PsiElement)expression2);
        IrType irType = this.getContext().getIrBuiltIns().getBooleanType();
        IrFunctionSymbol irFunctionSymbol = (IrFunctionSymbol)eqeqSymbol;
        KtExpression ktExpression = expression2.getLeft();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.left!!");
        PrimitiveNumericComparisonInfo primitiveNumericComparisonInfo2 = comparisonInfo;
        IrExpression irExpression = this.generateAsPrimitiveNumericComparisonOperand(ktExpression, primitiveNumericComparisonInfo2 != null ? primitiveNumericComparisonInfo2.getLeftType() : null, comparisonType);
        KtExpression ktExpression2 = expression2.getRight();
        if (ktExpression2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"expression.right!!");
        PrimitiveNumericComparisonInfo primitiveNumericComparisonInfo3 = comparisonInfo;
        IrBinaryPrimitiveImpl irEquals = new IrBinaryPrimitiveImpl(n, n2, irType, irOperator, irFunctionSymbol, irExpression, this.generateAsPrimitiveNumericComparisonOperand(ktExpression2, primitiveNumericComparisonInfo3 != null ? primitiveNumericComparisonInfo3.getRightType() : null, comparisonType));
        IrStatementOrigin irStatementOrigin = irOperator;
        if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.EQEQ.INSTANCE)) {
            irCall = irEquals;
        } else if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.EXCLEQ.INSTANCE)) {
            irCall = new IrUnaryPrimitiveImpl(PsiUtilsKt.getStartOffset((PsiElement)expression2), PsiUtilsKt.getEndOffset((PsiElement)expression2), this.getContext().getIrBuiltIns().getBooleanType(), (IrStatementOrigin)IrStatementOrigin.EXCLEQ.INSTANCE, (IrFunctionSymbol)this.getContext().getIrBuiltIns().getBooleanNotSymbol(), (IrExpression)irEquals);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected equality operator " + irOperator)));
        }
        return irCall;
    }

    @NotNull
    public final IrExpression generateEquality(int startOffset, int endOffset, @NotNull IrStatementOrigin irOperator, @NotNull IrExpression arg1, @NotNull IrExpression arg2, @Nullable PrimitiveNumericComparisonInfo comparisonInfo) {
        IrBinaryPrimitiveImpl irBinaryPrimitiveImpl;
        Intrinsics.checkParameterIsNotNull((Object)irOperator, (String)"irOperator");
        Intrinsics.checkParameterIsNotNull((Object)arg1, (String)"arg1");
        Intrinsics.checkParameterIsNotNull((Object)arg2, (String)"arg2");
        if (comparisonInfo != null) {
            KotlinType comparisonType = comparisonInfo.getComparisonType();
            Map<SimpleType, IrSimpleFunction> map2 = this.getContext().getIrBuiltIns().getIeee754equalsFunByOperandType();
            Object object = map2.get(comparisonType);
            if (object == null || (object = (IrSimpleFunctionSymbol)object.getSymbol()) == null) {
                object = this.getContext().getIrBuiltIns().getEqeqSymbol();
            }
            Object eqeqSymbol = object;
            irBinaryPrimitiveImpl = new IrBinaryPrimitiveImpl(startOffset, endOffset, this.getContext().getIrBuiltIns().getBooleanType(), irOperator, (IrFunctionSymbol)eqeqSymbol, this.promoteToPrimitiveNumericType(arg1, comparisonInfo.getLeftType(), comparisonType), this.promoteToPrimitiveNumericType(arg2, comparisonInfo.getRightType(), comparisonType));
        } else {
            irBinaryPrimitiveImpl = new IrBinaryPrimitiveImpl(startOffset, endOffset, this.getContext().getIrBuiltIns().getBooleanType(), irOperator, this.getContext().getIrBuiltIns().getEqeqSymbol(), arg1, arg2);
        }
        return irBinaryPrimitiveImpl;
    }

    private final IrExpression promoteToPrimitiveNumericType(@NotNull IrExpression $receiver, KotlinType operandType, KotlinType targetType) {
        IrExpression irExpression;
        if (targetType == null) {
            return $receiver;
        }
        if (operandType == null) {
            throw (Throwable)((Object)new AssertionError((Object)"operandType should be non-null"));
        }
        KotlinType operandNNType = TypeUtilsKt.makeNotNullable(operandType);
        FunctionDescriptor conversionFunction = this.findConversionFunctionTo(operandNNType, targetType);
        if (!TypeUtilsKt.isPrimitiveNumberType(operandNNType)) {
            throw (Throwable)((Object)new AssertionError((Object)("Primitive number type or nullable primitive number type expected: " + $receiver.getType())));
        }
        if (Intrinsics.areEqual((Object)operandType, (Object)targetType) || Intrinsics.areEqual((Object)operandNNType, (Object)targetType)) {
            irExpression = $receiver;
        } else {
            KotlinType kotlinType = IrTypeBaseKt.getOriginalKotlinType($receiver.getType());
            if (kotlinType == null) {
                Intrinsics.throwNpe();
            }
            if (KotlinUtilsKt.containsNull(kotlinType)) {
                irExpression = SafeCallReceiverKt.safeCallOnDispatchReceiver($receiver, this, $receiver.getStartOffset(), $receiver.getEndOffset(), (Function1<? super IrExpression, ? extends IrExpression>)((Function1)new Function1<IrExpression, IrExpression>(this, $receiver, conversionFunction, targetType){
                    final /* synthetic */ OperatorExpressionGenerator this$0;
                    final /* synthetic */ IrExpression $this_promoteToPrimitiveNumericType;
                    final /* synthetic */ FunctionDescriptor $conversionFunction;
                    final /* synthetic */ KotlinType $targetType;

                    @NotNull
                    public final IrExpression invoke(@NotNull IrExpression dispatchReceiver) {
                        Intrinsics.checkParameterIsNotNull((Object)dispatchReceiver, (String)"dispatchReceiver");
                        FunctionDescriptor functionDescriptor2 = this.$conversionFunction;
                        if (functionDescriptor2 == null) {
                            throw (Throwable)((Object)new AssertionError((Object)("No conversion function for " + this.$this_promoteToPrimitiveNumericType.getType() + " ~> " + this.$targetType)));
                        }
                        return OperatorExpressionGenerator.access$invokeConversionFunction(this.this$0, this.$this_promoteToPrimitiveNumericType.getStartOffset(), this.$this_promoteToPrimitiveNumericType.getEndOffset(), functionDescriptor2, dispatchReceiver);
                    }
                    {
                        this.this$0 = operatorExpressionGenerator;
                        this.$this_promoteToPrimitiveNumericType = irExpression;
                        this.$conversionFunction = functionDescriptor2;
                        this.$targetType = kotlinType;
                        super(1);
                    }
                }));
            } else {
                FunctionDescriptor functionDescriptor2 = conversionFunction;
                if (functionDescriptor2 == null) {
                    throw (Throwable)((Object)new AssertionError((Object)("No conversion function for " + $receiver.getType() + " ~> " + targetType)));
                }
                irExpression = this.invokeConversionFunction($receiver.getStartOffset(), $receiver.getEndOffset(), functionDescriptor2, $receiver);
            }
        }
        return irExpression;
    }

    private final IrExpression invokeConversionFunction(int startOffset, int endOffset, FunctionDescriptor functionDescriptor2, IrExpression receiver) {
        IrCallImpl irCallImpl;
        KotlinType kotlinType = functionDescriptor2.getReturnType();
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"functionDescriptor.returnType!!");
        IrType irType = this.toIrType(kotlinType);
        ReferenceSymbolTable referenceSymbolTable = this.getContext().getSymbolTable();
        FunctionDescriptor functionDescriptor3 = functionDescriptor2.getOriginal();
        Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor3, (String)"functionDescriptor.original");
        IrCallImpl $receiver = irCallImpl = new IrCallImpl(startOffset, endOffset, irType, IrUtilsKt.referenceFunction(referenceSymbolTable, functionDescriptor3), functionDescriptor2, null, null);
        $receiver.setDispatchReceiver(receiver);
        return irCallImpl;
    }

    private final FunctionDescriptor findConversionFunctionTo(@NotNull KotlinType $receiver, KotlinType targetType) {
        Object object = targetType.getConstructor().getDeclarationDescriptor();
        if (object == null || (object = object.getName()) == null || (object = ((Name)object).asString()) == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"targetType.constructor.d\u2026asString() ?: return null");
        Object targetTypeName = object;
        MemberScope memberScope2 = $receiver.getMemberScope();
        Name name2 = Name.identifier("to" + (String)targetTypeName);
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(\"to$targetTypeName\")");
        return KotlinUtilsKt.findSingleFunction(memberScope2, name2);
    }

    private final IrExpression generateComparisonOperator(KtBinaryExpression expression2, IrStatementOrigin origin) {
        IrBinaryPrimitiveImpl irBinaryPrimitiveImpl;
        int startOffset = PsiUtilsKt.getStartOffset((PsiElement)expression2);
        int endOffset = PsiUtilsKt.getEndOffset((PsiElement)expression2);
        PrimitiveNumericComparisonInfo comparisonInfo = this.getPrimitiveNumericComparisonInfo(expression2);
        if (comparisonInfo != null) {
            IrType irType = this.getContext().getIrBuiltIns().getBooleanType();
            IrFunctionSymbol irFunctionSymbol = this.getComparisonOperatorSymbol(origin, comparisonInfo.getComparisonType());
            KtExpression ktExpression = expression2.getLeft();
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.left!!");
            IrExpression irExpression = this.generateAsPrimitiveNumericComparisonOperand(ktExpression, comparisonInfo.getLeftType(), comparisonInfo.getComparisonType());
            KtExpression ktExpression2 = expression2.getRight();
            if (ktExpression2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"expression.right!!");
            irBinaryPrimitiveImpl = new IrBinaryPrimitiveImpl(startOffset, endOffset, irType, origin, irFunctionSymbol, irExpression, this.generateAsPrimitiveNumericComparisonOperand(ktExpression2, comparisonInfo.getRightType(), comparisonInfo.getComparisonType()));
        } else {
            IrType irType = this.getContext().getIrBuiltIns().getBooleanType();
            IrFunctionSymbol irFunctionSymbol = this.getComparisonOperatorSymbol(origin, this.getContext().getIrBuiltIns().getInt());
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, expression2);
            if (resolvedCall2 == null) {
                Intrinsics.throwNpe();
            }
            irBinaryPrimitiveImpl = new IrBinaryPrimitiveImpl(startOffset, endOffset, irType, origin, irFunctionSymbol, this.generateCall(resolvedCall2, expression2, origin), (IrExpression)IrConstImpl.Companion.int(startOffset, endOffset, this.getContext().getIrBuiltIns().getIntType(), 0));
        }
        return irBinaryPrimitiveImpl;
    }

    private final IrExpression generateCall(ResolvedCall<?> resolvedCall2, KtExpression ktExpression, IrStatementOrigin origin) {
        return CallGeneratorKt.generateCall(new CallGenerator(this.getStatementGenerator()), ktExpression, ArgumentsGenerationUtilsKt.pregenerateCall(this.getStatementGenerator(), resolvedCall2), origin);
    }

    private final IrSimpleFunctionSymbol getComparisonOperatorSymbol(IrStatementOrigin origin, KotlinType primitiveNumericType) {
        Map<SimpleType, IrSimpleFunction> map2;
        Object object = origin;
        if (Intrinsics.areEqual((Object)object, (Object)IrStatementOrigin.LT.INSTANCE)) {
            map2 = this.getContext().getIrBuiltIns().getLessFunByOperandType();
        } else if (Intrinsics.areEqual((Object)object, (Object)IrStatementOrigin.LTEQ.INSTANCE)) {
            map2 = this.getContext().getIrBuiltIns().getLessOrEqualFunByOperandType();
        } else if (Intrinsics.areEqual((Object)object, (Object)IrStatementOrigin.GT.INSTANCE)) {
            map2 = this.getContext().getIrBuiltIns().getGreaterFunByOperandType();
        } else if (Intrinsics.areEqual((Object)object, (Object)IrStatementOrigin.GTEQ.INSTANCE)) {
            map2 = this.getContext().getIrBuiltIns().getGreaterOrEqualFunByOperandType();
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected comparison operator: " + origin)));
        }
        object = map2;
        Object v = object.get(primitiveNumericType);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        return (IrSimpleFunctionSymbol)((IrSimpleFunction)v).getSymbol();
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateExclExclOperator(KtPostfixExpression expression2, IrStatementOrigin origin) {
        void this_$iv$iv;
        void startOffset$iv;
        void $receiver$iv;
        KtExpression ktExpression = expression2.getBaseExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.baseExpression!!");
        KtExpression ktArgument = ktExpression;
        IrExpression irArgument = this.genExpr(ktArgument);
        KtSimpleNameExpression ktSimpleNameExpression = expression2.getOperationReference();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression, (String)"expression.operationReference");
        KtSimpleNameExpression ktOperator = ktSimpleNameExpression;
        IrType resultType = IrTypesKt.makeNotNull(irArgument.getType());
        OperatorExpressionGenerator operatorExpressionGenerator = this;
        int n = PsiUtilsKt.getStartOffset((PsiElement)ktOperator);
        int endOffset$iv = PsiUtilsKt.getEndOffset((PsiElement)ktOperator);
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($receiver$iv.getContext(), $receiver$iv.getScope(), (int)startOffset$iv, endOffset$iv, origin, resultType, false, 64, null);
        void $receiver = this_$iv$iv;
        IrVariable temporary = ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$receiver, irArgument, "notnull", null, 4, null);
        $receiver.unaryPlus(ExpressionHelpersKt.irIfNull((IrBuilderWithScope)$receiver, resultType, ExpressionHelpersKt.irGet((IrBuilderWithScope)$receiver, temporary.getType(), temporary.getSymbol()), ExpressionHelpersKt.irThrowNpe((IrBuilderWithScope)$receiver, origin), ExpressionHelpersKt.irGet((IrBuilderWithScope)$receiver, temporary.getType(), temporary.getSymbol())));
        return this_$iv$iv.doBuild();
    }

    private final IrExpression generateBinaryOperatorAsCall(KtBinaryExpression expression2, IrStatementOrigin origin) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, expression2);
        if (resolvedCall2 == null) {
            Intrinsics.throwNpe();
        }
        return this.generateCall(resolvedCall2, expression2, origin);
    }

    private final IrExpression generatePrefixOperatorAsCall(KtPrefixExpression expression2, IrStatementOrigin origin) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, expression2);
        if (resolvedCall2 == null) {
            Intrinsics.throwNpe();
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (expression2.getBaseExpression() instanceof KtConstantExpression) {
            CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression2, this.getContext().getBindingContext());
            if (compileTimeConstant != null) {
                KotlinType receiverType2;
                CompileTimeConstant<?> compileTimeConstant2;
                CompileTimeConstant<?> constant = compileTimeConstant2 = compileTimeConstant;
                ReceiverValue receiverValue = resolvedCall3.getDispatchReceiver();
                KotlinType kotlinType = receiverType2 = receiverValue != null ? receiverValue.getType() : null;
                if (receiverType2 != null && KotlinBuiltIns.isPrimitiveType(receiverType2)) {
                    return this.getStatementGenerator().generateConstantExpression(expression2, constant);
                }
            }
        }
        return this.generateCall(resolvedCall3, expression2, origin);
    }

    public OperatorExpressionGenerator(@NotNull StatementGenerator statementGenerator) {
        Intrinsics.checkParameterIsNotNull((Object)statementGenerator, (String)"statementGenerator");
        super(statementGenerator);
    }

    @NotNull
    public static final /* synthetic */ IrExpression access$invokeConversionFunction(OperatorExpressionGenerator $this, int startOffset, int endOffset, @NotNull FunctionDescriptor functionDescriptor2, @NotNull IrExpression receiver) {
        return $this.invokeConversionFunction(startOffset, endOffset, functionDescriptor2, receiver);
    }
}

