/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;

@ApiStatus.Experimental
public class LibraryDataNodeSubstitutor {
    @Nullable
    private final File gradleUserHomeDir;
    @Nullable
    private final File gradleHomeDir;
    @Nullable
    private final GradleVersion gradleVersion;
    @NotNull
    private final Map<String, Pair<DataNode<GradleSourceSetData>, ExternalSourceSet>> sourceSetMap;
    @NotNull
    private final Map<String, Pair<String, ExternalSystemSourceType>> moduleOutputsMap;
    @NotNull
    private final Map<String, String> artifactsMap;

    public LibraryDataNodeSubstitutor(@Nullable File gradleUserHomeDir, @Nullable File gradleHomeDir, @Nullable GradleVersion gradleVersion, @NotNull Map<String, Pair<DataNode<GradleSourceSetData>, ExternalSourceSet>> sourceSetMap, @NotNull Map<String, Pair<String, ExternalSystemSourceType>> moduleOutputsMap, @NotNull Map<String, String> artifactsMap) {
        if (sourceSetMap == null) {
            LibraryDataNodeSubstitutor.$$$reportNull$$$0(0);
        }
        if (moduleOutputsMap == null) {
            LibraryDataNodeSubstitutor.$$$reportNull$$$0(1);
        }
        if (artifactsMap == null) {
            LibraryDataNodeSubstitutor.$$$reportNull$$$0(2);
        }
        this.gradleUserHomeDir = gradleUserHomeDir;
        this.gradleHomeDir = gradleHomeDir;
        this.gradleVersion = gradleVersion;
        this.sourceSetMap = sourceSetMap;
        this.moduleOutputsMap = moduleOutputsMap;
        this.artifactsMap = artifactsMap;
    }

    public void run(@NotNull DataNode<LibraryDependencyData> libraryDependencyDataNode) {
        DataNode libraryNodeParent;
        if (libraryDependencyDataNode == null) {
            LibraryDataNodeSubstitutor.$$$reportNull$$$0(3);
        }
        if ((libraryNodeParent = libraryDependencyDataNode.getParent()) == null) {
            return;
        }
        LibraryDependencyData libraryDependencyData = (LibraryDependencyData)libraryDependencyDataNode.getData();
        LibraryData libraryData = (LibraryData)libraryDependencyData.getTarget();
        Set libraryPaths = libraryData.getPaths(LibraryPathType.BINARY);
        if (libraryPaths.isEmpty()) {
            return;
        }
        if (StringUtil.isNotEmpty((String)libraryData.getExternalName())) {
            if (this.gradleUserHomeDir != null) {
                GradleProjectResolverUtil.attachSourcesAndJavadocFromGradleCacheIfNeeded(this.gradleUserHomeDir, libraryData);
            }
            return;
        }
        boolean projectDependencyCandidate = libraryPaths.size() == 1 && !libraryDependencyDataNode.getChildren().isEmpty();
        LinkedList unprocessedPaths = ContainerUtil.newLinkedList((Iterable)libraryPaths);
        while (!unprocessedPaths.isEmpty()) {
            Pair<DataNode<GradleSourceSetData>, ExternalSourceSet> pair;
            String moduleId;
            String path = (String)unprocessedPaths.remove();
            Set targetModuleOutputPaths = null;
            Pair<String, ExternalSystemSourceType> sourceTypePair = this.moduleOutputsMap.get(path);
            if (sourceTypePair == null) {
                moduleId = this.artifactsMap.get(path);
                if (moduleId != null) {
                    targetModuleOutputPaths = ContainerUtil.set((Object[])new String[]{path});
                }
            } else {
                moduleId = (String)sourceTypePair.first;
            }
            if (moduleId == null || (pair = this.sourceSetMap.get(moduleId)) == null) continue;
            ModuleData moduleData = (ModuleData)((DataNode)pair.first).getData();
            if (targetModuleOutputPaths == null) {
                HashSet compileSet = ContainerUtil.newHashSet();
                MultiMap gradleOutputs = (MultiMap)((DataNode)pair.first).getUserData(GradleProjectResolver.GRADLE_OUTPUTS);
                if (gradleOutputs != null) {
                    ContainerUtil.addAllNotNull((Collection)compileSet, (Iterable)gradleOutputs.get((Object)ExternalSystemSourceType.SOURCE));
                    ContainerUtil.addAllNotNull((Collection)compileSet, (Iterable)gradleOutputs.get((Object)ExternalSystemSourceType.RESOURCE));
                }
                if (!compileSet.isEmpty() && ContainerUtil.intersects((Collection)libraryPaths, (Collection)compileSet)) {
                    targetModuleOutputPaths = compileSet;
                } else {
                    HashSet testSet = ContainerUtil.newHashSet();
                    if (gradleOutputs != null) {
                        ContainerUtil.addAllNotNull((Collection)testSet, (Iterable)gradleOutputs.get((Object)ExternalSystemSourceType.TEST));
                        ContainerUtil.addAllNotNull((Collection)testSet, (Iterable)gradleOutputs.get((Object)ExternalSystemSourceType.TEST_RESOURCE));
                    }
                    if (!testSet.isEmpty() && ContainerUtil.intersects((Collection)libraryPaths, (Collection)testSet)) {
                        targetModuleOutputPaths = testSet;
                    }
                }
            }
            ModuleData ownerModule = libraryDependencyData.getOwnerModule();
            ModuleDependencyData moduleDependencyData = new ModuleDependencyData(ownerModule, moduleData);
            moduleDependencyData.setScope(libraryDependencyData.getScope());
            if ("test".equals(((ExternalSourceSet)pair.second).getName())) {
                moduleDependencyData.setProductionOnTestDependency(true);
            }
            DataNode found = ExternalSystemApiUtil.find((DataNode)libraryNodeParent, (Key)ProjectKeys.MODULE_DEPENDENCY, node -> {
                boolean result;
                if (moduleDependencyData.getInternalName().equals(((ModuleDependencyData)node.getData()).getInternalName())) {
                    moduleDependencyData.setModuleDependencyArtifacts(((ModuleDependencyData)node.getData()).getModuleDependencyArtifacts());
                }
                if (moduleDependencyData.getScope() == DependencyScope.PROVIDED) {
                    moduleDependencyData.setScope(((ModuleDependencyData)node.getData()).getScope());
                    result = moduleDependencyData.equals(node.getData());
                    moduleDependencyData.setScope(DependencyScope.PROVIDED);
                } else {
                    result = moduleDependencyData.equals(node.getData());
                }
                return result;
            });
            if (targetModuleOutputPaths != null) {
                if (found == null) {
                    DataNode moduleDependencyNode = libraryNodeParent.createChild(ProjectKeys.MODULE_DEPENDENCY, (Object)moduleDependencyData);
                    if (projectDependencyCandidate) {
                        for (DataNode node2 : libraryDependencyDataNode.getChildren()) {
                            moduleDependencyNode.addChild(node2);
                        }
                    }
                }
                libraryPaths.removeAll(targetModuleOutputPaths);
                unprocessedPaths.removeAll(targetModuleOutputPaths);
                if (!libraryPaths.isEmpty()) continue;
                libraryDependencyDataNode.clear(true);
                break;
            }
            if (found != null) {
                libraryPaths.remove(path);
                if (!libraryPaths.isEmpty()) continue;
                libraryDependencyDataNode.clear(true);
                break;
            }
            ExternalSourceDirectorySet directorySet = (ExternalSourceDirectorySet)((ExternalSourceSet)pair.second).getSources().get(sourceTypePair.second);
            if (directorySet == null) continue;
            for (File file : directorySet.getSrcDirs()) {
                libraryData.addPath(LibraryPathType.SOURCE, file.getAbsolutePath());
            }
        }
        if (libraryDependencyDataNode.getParent() != null && libraryPaths.size() > 1) {
            List toRemove = ContainerUtil.newSmartList();
            for (String path : libraryPaths) {
                File binaryPath = new File(path);
                if (!binaryPath.isFile()) continue;
                LibraryData extractedLibrary = new LibraryData(libraryDependencyData.getOwner(), "");
                extractedLibrary.addPath(LibraryPathType.BINARY, path);
                if (this.gradleHomeDir != null && this.gradleVersion != null) {
                    GradleProjectResolverUtil.attachGradleSdkSources(binaryPath, extractedLibrary, this.gradleHomeDir, this.gradleVersion);
                }
                LibraryDependencyData extractedDependencyData = new LibraryDependencyData(libraryDependencyData.getOwnerModule(), extractedLibrary, LibraryLevel.MODULE);
                libraryDependencyDataNode.getParent().createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)extractedDependencyData);
                toRemove.add(path);
            }
            libraryPaths.removeAll(toRemove);
            if (libraryPaths.isEmpty()) {
                libraryDependencyDataNode.clear(true);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSetMap";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleOutputsMap";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactsMap";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryDependencyDataNode";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/LibraryDataNodeSubstitutor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

