/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.execution.ParametersListUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.settings.ClassHolder;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionWorkspace;

public class GradleExecutionSettings
extends ExternalSystemExecutionSettings {
    private static final boolean USE_VERBOSE_GRADLE_API_BY_DEFAULT = Boolean.parseBoolean(System.getProperty("gradle.api.verbose"));
    private static final long serialVersionUID = 1L;
    @NotNull
    private final GradleExecutionWorkspace myExecutionWorkspace;
    @NotNull
    private final List<ClassHolder<? extends GradleProjectResolverExtension>> myResolverExtensions;
    @Nullable
    private final String myGradleHome;
    @Nullable
    private final String myServiceDirectory;
    private final boolean myIsOfflineWork;
    @NotNull
    private final DistributionType myDistributionType;
    @Nullable
    private String wrapperPropertyFile;
    @Nullable
    private String myJavaHome;
    @Nullable
    private String myIdeProjectPath;
    private boolean resolveModulePerSourceSet;
    private boolean useQualifiedModuleNames;

    public GradleExecutionSettings(@Nullable String gradleHome, @Nullable String serviceDirectory, @NotNull DistributionType distributionType, boolean isOfflineWork) {
        if (distributionType == null) {
            GradleExecutionSettings.$$$reportNull$$$0(0);
        }
        this.myExecutionWorkspace = new GradleExecutionWorkspace();
        this.myResolverExtensions = ContainerUtilRt.newArrayList();
        this.resolveModulePerSourceSet = true;
        this.useQualifiedModuleNames = false;
        this.myGradleHome = gradleHome;
        this.myServiceDirectory = serviceDirectory;
        this.myDistributionType = distributionType;
        this.myIsOfflineWork = isOfflineWork;
        this.setVerboseProcessing(USE_VERBOSE_GRADLE_API_BY_DEFAULT);
    }

    public GradleExecutionSettings(@Nullable String gradleHome, @Nullable String serviceDirectory, @NotNull DistributionType distributionType, @Nullable String daemonVmOptions, boolean isOfflineWork) {
        if (distributionType == null) {
            GradleExecutionSettings.$$$reportNull$$$0(1);
        }
        this.myExecutionWorkspace = new GradleExecutionWorkspace();
        this.myResolverExtensions = ContainerUtilRt.newArrayList();
        this.resolveModulePerSourceSet = true;
        this.useQualifiedModuleNames = false;
        this.myGradleHome = gradleHome;
        this.myServiceDirectory = serviceDirectory;
        this.myDistributionType = distributionType;
        if (daemonVmOptions != null) {
            this.withVmOptions(ParametersListUtil.parse((String)daemonVmOptions));
        }
        this.myIsOfflineWork = isOfflineWork;
        this.setVerboseProcessing(USE_VERBOSE_GRADLE_API_BY_DEFAULT);
    }

    public void setIdeProjectPath(@Nullable String ideProjectPath) {
        this.myIdeProjectPath = ideProjectPath;
    }

    @Nullable
    public String getIdeProjectPath() {
        return this.myIdeProjectPath;
    }

    @Nullable
    public String getGradleHome() {
        return this.myGradleHome;
    }

    @Nullable
    public String getServiceDirectory() {
        return this.myServiceDirectory;
    }

    @Nullable
    public String getJavaHome() {
        return this.myJavaHome;
    }

    public void setJavaHome(@Nullable String javaHome) {
        this.myJavaHome = javaHome;
    }

    public boolean isOfflineWork() {
        return this.myIsOfflineWork;
    }

    public boolean isResolveModulePerSourceSet() {
        return this.resolveModulePerSourceSet;
    }

    public void setResolveModulePerSourceSet(boolean resolveModulePerSourceSet) {
        this.resolveModulePerSourceSet = resolveModulePerSourceSet;
    }

    public boolean isUseQualifiedModuleNames() {
        return this.useQualifiedModuleNames;
    }

    public void setUseQualifiedModuleNames(boolean useQualifiedModuleNames) {
        this.useQualifiedModuleNames = useQualifiedModuleNames;
    }

    @NotNull
    public List<ClassHolder<? extends GradleProjectResolverExtension>> getResolverExtensions() {
        List<ClassHolder<? extends GradleProjectResolverExtension>> list = this.myResolverExtensions;
        if (list == null) {
            GradleExecutionSettings.$$$reportNull$$$0(2);
        }
        return list;
    }

    public void addResolverExtensionClass(@NotNull ClassHolder<? extends GradleProjectResolverExtension> holder) {
        if (holder == null) {
            GradleExecutionSettings.$$$reportNull$$$0(3);
        }
        this.myResolverExtensions.add(holder);
    }

    @Deprecated
    @Nullable
    public String getDaemonVmOptions() {
        return ParametersListUtil.join((List)this.getJvmArguments());
    }

    @Nullable
    public String getWrapperPropertyFile() {
        return this.wrapperPropertyFile;
    }

    public void setWrapperPropertyFile(@Nullable String wrapperPropertyFile) {
        this.wrapperPropertyFile = wrapperPropertyFile;
    }

    @NotNull
    public DistributionType getDistributionType() {
        DistributionType distributionType = this.myDistributionType;
        if (distributionType == null) {
            GradleExecutionSettings.$$$reportNull$$$0(4);
        }
        return distributionType;
    }

    @NotNull
    public GradleExecutionWorkspace getExecutionWorkspace() {
        GradleExecutionWorkspace gradleExecutionWorkspace = this.myExecutionWorkspace;
        if (gradleExecutionWorkspace == null) {
            GradleExecutionSettings.$$$reportNull$$$0(5);
        }
        return gradleExecutionWorkspace;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.myGradleHome != null ? this.myGradleHome.hashCode() : 0);
        result = 31 * result + (this.myServiceDirectory != null ? this.myServiceDirectory.hashCode() : 0);
        result = 31 * result + this.myDistributionType.hashCode();
        result = 31 * result + (this.myJavaHome != null ? this.myJavaHome.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        GradleExecutionSettings that = (GradleExecutionSettings)((Object)o);
        if (this.myDistributionType != that.myDistributionType) {
            return false;
        }
        if (this.myGradleHome != null ? !this.myGradleHome.equals(that.myGradleHome) : that.myGradleHome != null) {
            return false;
        }
        if (this.myJavaHome != null ? !this.myJavaHome.equals(that.myJavaHome) : that.myJavaHome != null) {
            return false;
        }
        return !(this.myServiceDirectory != null ? !this.myServiceDirectory.equals(that.myServiceDirectory) : that.myServiceDirectory != null);
    }

    public String toString() {
        return "home: " + this.myGradleHome + ", distributionType: " + (Object)((Object)this.myDistributionType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distributionType";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/settings/GradleExecutionSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/settings/GradleExecutionSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolverExtensions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDistributionType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutionWorkspace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addResolverExtensionClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

