/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sherpa.interaction;

import java.util.Arrays;

public class DrawPicker {
    private static final int MAX_DATA_SIZE = 10;
    private static final int INITAL_OBJECT_STORE = 30;
    private static final double EPSILON = 1.0E-5;
    private double[] mObjectData = new double[100];
    private int mObjectDataUsed = 0;
    private int[] mObjectOffset = new int[30];
    private int[] mTypes = new int[30];
    private int[] mRect = new int[120];
    private Object[] mObjects = new Object[30];
    HitElementListener mHitElementListener;
    private int mObjectCount = 0;
    private static final int OBJECT_LINE = 0;
    private static final int OBJECT_POINT = 1;
    private static final int OBJECT_CURVE = 2;
    private static final int OBJECT_RECTANGLE = 3;
    LineSelectionEngine mLine = new LineSelectionEngine();
    PointSelectionEngine mPoint = new PointSelectionEngine();
    CurveToSelectionEngine mCurve = new CurveToSelectionEngine();
    RectangleSelectionEngine mRectangle = new RectangleSelectionEngine();
    SelectionEngine[] myEngines = new SelectionEngine[4];

    public DrawPicker() {
        this.myEngines[0] = this.mLine;
        this.myEngines[1] = this.mPoint;
        this.myEngines[2] = this.mCurve;
        this.myEngines[3] = this.mRectangle;
    }

    public void find(int x, int y) {
        for (int i = 0; i < this.mObjectCount; ++i) {
            SelectionEngine selector;
            int y2;
            int x2;
            int y1;
            int p = i * 4;
            int x1 = this.mRect[p++];
            if (!DrawPicker.inRect(x, y, x1, y1 = this.mRect[p++], x2 = this.mRect[p++], y2 = this.mRect[p]) || !(selector = this.myEngines[this.mTypes[i]]).inRange(i, x, y)) continue;
            this.mHitElementListener.over(this.mObjects[i], selector.distance());
        }
    }

    public void setSelectListener(HitElementListener listener) {
        this.mHitElementListener = listener;
    }

    private static boolean inRect(int x, int y, int x1, int y1, int x2, int y2) {
        if (x < x1) {
            return false;
        }
        if (y < y1) {
            return false;
        }
        if (x >= x2) {
            return false;
        }
        return y < y2;
    }

    private static boolean inRect(double x, double y, double x1, double y1, double x2, double y2) {
        if (x < x1) {
            return false;
        }
        if (y < y1) {
            return false;
        }
        if (x >= x2) {
            return false;
        }
        return !(y >= y2);
    }

    public void reset() {
        this.mObjectCount = 0;
        this.mObjectDataUsed = 0;
        Arrays.fill(this.mObjects, null);
    }

    private void resizeTables() {
        if (this.mObjectDataUsed > this.mObjectData.length - 10) {
            this.mObjectData = Arrays.copyOf(this.mObjectData, this.mObjectData.length * 2);
        }
        if (this.mObjectCount < this.mTypes.length) {
            return;
        }
        this.mObjectOffset = Arrays.copyOf(this.mObjectOffset, this.mObjectOffset.length * 2);
        this.mTypes = Arrays.copyOf(this.mTypes, this.mTypes.length * 2);
        this.mObjects = Arrays.copyOf(this.mObjects, this.mObjects.length * 2);
        this.mRect = Arrays.copyOf(this.mRect, this.mRect.length * 2);
    }

    public void addLine(Object e, int range, int x1, int y1, int x2, int y2) {
        this.mLine.add(e, range, x1, y1, x2, y2);
    }

    public void addRect(Object e, int range, int x1, int y1, int x2, int y2) {
        this.mRectangle.add(e, range, x1, y1, x2, y2);
    }

    public void addPoint(Object e, int range, int x1, int y1) {
        this.mPoint.add(e, range, x1, y1);
    }

    public void addCurveTo(Object e, int range, int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        this.mCurve.add(e, range, x1, y1, x2, y2, x3, y3, x4, y4);
    }

    class CurveToSelectionEngine
    extends SelectionEngine {
        double cx0;
        double cx1;
        double cx2;
        double cx3;
        double cy0;
        double cy1;
        double cy2;
        double cy3;
        double mDistance;

        CurveToSelectionEngine() {
        }

        public void add(Object select, int range, int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
            DrawPicker.this.resizeTables();
            ((DrawPicker)DrawPicker.this).mObjectOffset[((DrawPicker)DrawPicker.this).mObjectCount] = DrawPicker.this.mObjectDataUsed;
            ((DrawPicker)DrawPicker.this).mObjectData[((DrawPicker)DrawPicker.this).mObjectDataUsed++] = range;
            this.cx0 = x1;
            this.cx1 = 3 * x2 - 3 * x1;
            this.cx2 = 3 * x3 - 6 * x2 + 3 * x1;
            this.cx3 = x4 - 3 * x3 + 3 * x2 - x1;
            this.cy0 = y1;
            this.cy1 = 3 * y2 - 3 * y1;
            this.cy2 = 3 * y3 - 6 * y2 + 3 * y1;
            this.cy3 = y4 - 3 * y3 + 3 * y2 - y1;
            ((DrawPicker)DrawPicker.this).mObjectData[((DrawPicker)DrawPicker.this).mObjectDataUsed++] = this.cx0;
            ((DrawPicker)DrawPicker.this).mObjectData[((DrawPicker)DrawPicker.this).mObjectDataUsed++] = this.cx1;
            ((DrawPicker)DrawPicker.this).mObjectData[((DrawPicker)DrawPicker.this).mObjectDataUsed++] = this.cx2;
            ((DrawPicker)DrawPicker.this).mObjectData[((DrawPicker)DrawPicker.this).mObjectDataUsed++] = this.cx3;
            ((DrawPicker)DrawPicker.this).mObjectData[((DrawPicker)DrawPicker.this).mObjectDataUsed++] = this.cy0;
            ((DrawPicker)DrawPicker.this).mObjectData[((DrawPicker)DrawPicker.this).mObjectDataUsed++] = this.cy1;
            ((DrawPicker)DrawPicker.this).mObjectData[((DrawPicker)DrawPicker.this).mObjectDataUsed++] = this.cy2;
            ((DrawPicker)DrawPicker.this).mObjectData[((DrawPicker)DrawPicker.this).mObjectDataUsed++] = this.cy3;
            ((DrawPicker)DrawPicker.this).mObjects[((DrawPicker)DrawPicker.this).mObjectCount] = select;
            ((DrawPicker)DrawPicker.this).mTypes[((DrawPicker)DrawPicker.this).mObjectCount] = 2;
            this.bounds(range);
            DrawPicker.this.mObjectCount++;
        }

        @Override
        protected boolean inRange() {
            double range = DrawPicker.this.mObjectData[this.mDataOffset];
            this.cx0 = DrawPicker.this.mObjectData[this.mDataOffset + 1];
            this.cx1 = DrawPicker.this.mObjectData[this.mDataOffset + 2];
            this.cx2 = DrawPicker.this.mObjectData[this.mDataOffset + 3];
            this.cx3 = DrawPicker.this.mObjectData[this.mDataOffset + 4];
            this.cy0 = DrawPicker.this.mObjectData[this.mDataOffset + 5];
            this.cy1 = DrawPicker.this.mObjectData[this.mDataOffset + 6];
            this.cy2 = DrawPicker.this.mObjectData[this.mDataOffset + 7];
            this.cy3 = DrawPicker.this.mObjectData[this.mDataOffset + 8];
            double rangeSqr = range * range;
            for (double t = 0.0; t < 1.0; t += 0.03) {
                double t2 = t * t;
                double t3 = t * t2;
                double x = this.cx0 + this.cx1 * t + this.cx2 * t2 + this.cx3 * t3;
                double dx = x - (double)this.mMouseX;
                double y = this.cy0 + this.cy1 * t + this.cy2 * t2 + this.cy3 * t3;
                double dy = y - (double)this.mMouseY;
                double distanceSq = dx * dx + dy * dy;
                if (!(rangeSqr > distanceSq)) continue;
                this.mDistance = Math.sqrt(distanceSq);
                return true;
            }
            return false;
        }

        public final double evalX(double t) {
            double t2 = t * t;
            double t3 = t * t2;
            return this.cx0 + this.cx1 * t + this.cx2 * t2 + this.cx3 * t3;
        }

        public final double evalY(double t) {
            double t2 = t * t;
            double t3 = t * t2;
            return this.cy0 + this.cy1 * t + this.cy2 * t2 + this.cy3 * t3;
        }

        public final void bounds(int range) {
            double t2;
            double t1;
            double x0 = this.cx0;
            double y0 = this.cy0;
            double x1 = this.cx0 + this.cx1 + this.cx2 + this.cx3;
            double y1 = this.cy0 + this.cy1 + this.cy2 + this.cy3;
            double minx = Math.min(x0, x1);
            double miny = Math.min(y0, y1);
            double maxx = Math.max(x0, x1);
            double maxy = Math.max(y0, y1);
            if (this.cx3 != 0.0) {
                double x;
                t1 = -(Math.sqrt(this.cx2 * this.cx2 - 3.0 * this.cx1 * this.cx3) + this.cx2) / (3.0 * this.cx3);
                t2 = (Math.sqrt(this.cx2 * this.cx2 - 3.0 * this.cx1 * this.cx3) - this.cx2) / (3.0 * this.cx3);
                if (t1 > 0.0 && t1 < 1.0) {
                    x = this.evalX(t1);
                    minx = Math.min(x, minx);
                    maxx = Math.max(x, maxx);
                }
                if (t2 > 0.0 && t2 < 1.0) {
                    x = this.evalX(t2);
                    minx = Math.min(x, minx);
                    maxx = Math.max(x, maxx);
                }
            }
            if (this.cy3 != 0.0) {
                double y;
                t1 = -(Math.sqrt(this.cy2 * this.cy2 - 3.0 * this.cy1 * this.cy3) + this.cy2) / (3.0 * this.cy3);
                t2 = (Math.sqrt(this.cy2 * this.cy2 - 3.0 * this.cy1 * this.cy3) - this.cy2) / (3.0 * this.cy3);
                if (t1 > 0.0 && t1 < 1.0) {
                    y = this.evalY(t1);
                    miny = Math.min(y, miny);
                    maxy = Math.max(y, maxy);
                }
                if (t2 > 0.0 && t2 < 1.0) {
                    y = this.evalY(t2);
                    miny = Math.min(y, miny);
                    maxy = Math.max(y, maxy);
                }
            }
            this.addRect((int)minx - range, (int)miny - range, (int)(maxx + (double)range), (int)(maxy + (double)range));
        }

        @Override
        double distance() {
            return this.mDistance;
        }
    }

    class RectangleSelectionEngine
    extends SelectionEngine {
        double mDistance;

        RectangleSelectionEngine() {
        }

        public void add(Object select, int range, int x1, int y1, int x2, int y2) {
            int t;
            DrawPicker.this.resizeTables();
            ((DrawPicker)DrawPicker.this).mObjectOffset[((DrawPicker)DrawPicker.this).mObjectCount] = DrawPicker.this.mObjectDataUsed;
            ((DrawPicker)DrawPicker.this).mObjectData[((DrawPicker)DrawPicker.this).mObjectDataUsed++] = range;
            if (x1 > x2) {
                t = x1;
                x1 = x2;
                x2 = t;
            }
            if (y1 > y2) {
                t = y1;
                y1 = y2;
                y2 = t;
            }
            ((DrawPicker)DrawPicker.this).mObjectData[((DrawPicker)DrawPicker.this).mObjectDataUsed++] = x1;
            ((DrawPicker)DrawPicker.this).mObjectData[((DrawPicker)DrawPicker.this).mObjectDataUsed++] = y1;
            ((DrawPicker)DrawPicker.this).mObjectData[((DrawPicker)DrawPicker.this).mObjectDataUsed++] = x2;
            ((DrawPicker)DrawPicker.this).mObjectData[((DrawPicker)DrawPicker.this).mObjectDataUsed++] = y2;
            this.addRect(x1 - range, y1 - range, x2 + range, y2 + range);
            ((DrawPicker)DrawPicker.this).mObjects[((DrawPicker)DrawPicker.this).mObjectCount] = select;
            ((DrawPicker)DrawPicker.this).mTypes[((DrawPicker)DrawPicker.this).mObjectCount] = 3;
            DrawPicker.this.mObjectCount++;
        }

        @Override
        protected boolean inRange() {
            double y2;
            double x2;
            double y1;
            double range = DrawPicker.this.mObjectData[this.mDataOffset];
            double x1 = DrawPicker.this.mObjectData[this.mDataOffset + 1];
            if (DrawPicker.inRect(this.mMouseX, this.mMouseY, x1, y1 = DrawPicker.this.mObjectData[this.mDataOffset + 2], x2 = DrawPicker.this.mObjectData[this.mDataOffset + 3], y2 = DrawPicker.this.mObjectData[this.mDataOffset + 4])) {
                this.mDistance = 0.0;
                return true;
            }
            if ((double)this.mMouseX > x1 && (double)this.mMouseX < x2) {
                if ((double)this.mMouseY < y1) {
                    this.mDistance = y1 - (double)this.mMouseY;
                    return this.mDistance < range;
                }
                if ((double)this.mMouseY > y2) {
                    this.mDistance = (double)this.mMouseY - y2;
                    return this.mDistance < range;
                }
            }
            if ((double)this.mMouseY > y1 && (double)this.mMouseY < y2) {
                if ((double)this.mMouseX < x1) {
                    this.mDistance = x1 - (double)this.mMouseX;
                    return this.mDistance < range;
                }
                if ((double)this.mMouseX > x2) {
                    this.mDistance = (double)this.mMouseX - x2;
                    return this.mDistance < range;
                }
            }
            return false;
        }

        @Override
        double distance() {
            return 0.0;
        }
    }

    class LineSelectionEngine
    extends SelectionEngine {
        double mDistance;

        LineSelectionEngine() {
        }

        public void add(Object select, int range, int x1, int y1, int x2, int y2) {
            int t;
            DrawPicker.this.resizeTables();
            ((DrawPicker)DrawPicker.this).mObjectOffset[((DrawPicker)DrawPicker.this).mObjectCount] = DrawPicker.this.mObjectDataUsed;
            ((DrawPicker)DrawPicker.this).mObjectData[((DrawPicker)DrawPicker.this).mObjectDataUsed++] = range;
            ((DrawPicker)DrawPicker.this).mObjectData[((DrawPicker)DrawPicker.this).mObjectDataUsed++] = (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
            ((DrawPicker)DrawPicker.this).mObjectData[((DrawPicker)DrawPicker.this).mObjectDataUsed++] = x1;
            ((DrawPicker)DrawPicker.this).mObjectData[((DrawPicker)DrawPicker.this).mObjectDataUsed++] = y1;
            ((DrawPicker)DrawPicker.this).mObjectData[((DrawPicker)DrawPicker.this).mObjectDataUsed++] = x2;
            ((DrawPicker)DrawPicker.this).mObjectData[((DrawPicker)DrawPicker.this).mObjectDataUsed++] = y2;
            if (x1 > x2) {
                t = x1;
                x1 = x2;
                x2 = t;
            }
            if (y1 > y2) {
                t = y1;
                y1 = y2;
                y2 = t;
            }
            this.addRect(x1 - range, y1 - range, x2 + range, y2 + range);
            ((DrawPicker)DrawPicker.this).mObjects[((DrawPicker)DrawPicker.this).mObjectCount] = select;
            ((DrawPicker)DrawPicker.this).mTypes[((DrawPicker)DrawPicker.this).mObjectCount] = 0;
            DrawPicker.this.mObjectCount++;
        }

        @Override
        protected boolean inRange() {
            double range = DrawPicker.this.mObjectData[this.mDataOffset];
            double lineLengthSq = DrawPicker.this.mObjectData[this.mDataOffset + 1];
            double x1 = DrawPicker.this.mObjectData[this.mDataOffset + 2];
            double y1 = DrawPicker.this.mObjectData[this.mDataOffset + 3];
            double x2 = DrawPicker.this.mObjectData[this.mDataOffset + 4];
            double y2 = DrawPicker.this.mObjectData[this.mDataOffset + 5];
            if (lineLengthSq < 1.0E-5) {
                this.mDistance = Math.hypot(x1 - (double)this.mMouseX, y1 - (double)this.mMouseY);
                return this.mDistance <= range;
            }
            double t = (((double)this.mMouseX - x1) * (x2 - x1) + ((double)this.mMouseY - y1) * (y2 - y1)) / lineLengthSq;
            t = Math.max(0.0, Math.min(1.0, t));
            double tx = x1 + t * (x2 - x1);
            double ty = y1 + t * (y2 - y1);
            this.mDistance = Math.hypot(tx - (double)this.mMouseX, ty - (double)this.mMouseY);
            return this.mDistance <= range;
        }

        @Override
        double distance() {
            return this.mDistance;
        }
    }

    class PointSelectionEngine
    extends SelectionEngine {
        double mDistance;

        PointSelectionEngine() {
        }

        public void add(Object select, int range, int x1, int y1) {
            DrawPicker.this.resizeTables();
            ((DrawPicker)DrawPicker.this).mTypes[((DrawPicker)DrawPicker.this).mObjectCount] = 1;
            ((DrawPicker)DrawPicker.this).mObjectOffset[((DrawPicker)DrawPicker.this).mObjectCount] = DrawPicker.this.mObjectDataUsed;
            ((DrawPicker)DrawPicker.this).mObjectData[((DrawPicker)DrawPicker.this).mObjectDataUsed++] = range;
            ((DrawPicker)DrawPicker.this).mObjectData[((DrawPicker)DrawPicker.this).mObjectDataUsed++] = x1;
            ((DrawPicker)DrawPicker.this).mObjectData[((DrawPicker)DrawPicker.this).mObjectDataUsed++] = y1;
            ((DrawPicker)DrawPicker.this).mObjects[((DrawPicker)DrawPicker.this).mObjectCount] = select;
            this.addRect(x1 - range, y1 - range, x1 + range, y1 + range);
            DrawPicker.this.mObjectCount++;
        }

        @Override
        protected boolean inRange() {
            double range = DrawPicker.this.mObjectData[this.mDataOffset];
            double x = DrawPicker.this.mObjectData[this.mDataOffset + 1];
            double y = DrawPicker.this.mObjectData[this.mDataOffset + 2];
            this.mDistance = Math.hypot(x - (double)this.mMouseX, y - (double)this.mMouseY);
            return this.mDistance < range;
        }

        @Override
        double distance() {
            return this.mDistance;
        }
    }

    private abstract class SelectionEngine {
        protected int mObject;
        protected int mMouseX;
        protected int mMouseY;
        protected int mDataOffset;

        private SelectionEngine() {
        }

        protected void addRect(int x1, int y1, int x2, int y2) {
            int off = DrawPicker.this.mObjectCount * 4;
            ((DrawPicker)DrawPicker.this).mRect[off++] = x1;
            ((DrawPicker)DrawPicker.this).mRect[off++] = y1;
            ((DrawPicker)DrawPicker.this).mRect[off++] = x2;
            ((DrawPicker)DrawPicker.this).mRect[off] = y2;
        }

        boolean inRange(int object, int x, int y) {
            this.mObject = object;
            this.mDataOffset = DrawPicker.this.mObjectOffset[this.mObject];
            this.mMouseX = x;
            this.mMouseY = y;
            return this.inRange();
        }

        protected abstract boolean inRange();

        abstract double distance();
    }

    public static interface HitElementListener {
        public void over(Object var1, double var2);
    }
}

