/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy;

import com.intellij.ide.FileIconProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.ElementBase;
import icons.JetgroovyIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptTypeDetector;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.util.GrFileIndexUtil;

public class GroovyFileIconProvider
implements FileIconProvider {
    @Nullable
    public Icon getIcon(@NotNull VirtualFile virtualFile, @Iconable.IconFlags int flags, @Nullable Project project) {
        GrTypeDefinition[] typeDefinitions;
        if (virtualFile == null) {
            GroovyFileIconProvider.$$$reportNull$$$0(0);
        }
        if (project == null || virtualFile.getFileType() != GroovyFileType.GROOVY_FILE_TYPE) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (!(psiFile instanceof GroovyFile)) {
            return null;
        }
        GroovyFile file = (GroovyFile)psiFile;
        Icon icon = file.isScript() ? GroovyScriptTypeDetector.getIcon(file) : (GrFileIndexUtil.isGroovySourceFile(file) ? ((typeDefinitions = file.getTypeDefinitions()).length > 0 ? typeDefinitions[0].getIcon(flags) : JetgroovyIcons.Groovy.GroovyFile) : JetgroovyIcons.Groovy.Groovy_outsideSources);
        return ElementBase.createLayeredIcon((Iconable)psiFile, (Icon)icon, (int)ElementBase.transformFlags((PsiElement)psiFile, (int)flags));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "org/jetbrains/plugins/groovy/GroovyFileIconProvider", "getIcon"));
    }
}

