/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.checkers;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.GrRemoveAnnotationIntention;
import org.jetbrains.plugins.groovy.annotator.checkers.CustomAnnotationChecker;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrAnnotationCollector;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class AnnotationChecker {
    private final AnnotationHolder myHolder;

    public AnnotationChecker(@NotNull AnnotationHolder holder) {
        if (holder == null) {
            AnnotationChecker.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    public void checkApplicability(@NotNull GrAnnotation annotation, @Nullable PsiAnnotationOwner owner) {
        GrCodeReferenceElement ref;
        PsiElement resolved;
        if (annotation == null) {
            AnnotationChecker.$$$reportNull$$$0(1);
        }
        if ((resolved = (ref = annotation.getClassReference()).resolve()) == null) {
            return;
        }
        assert (resolved instanceof PsiClass);
        PsiClass anno = (PsiClass)resolved;
        String qname = anno.getQualifiedName();
        if (!anno.isAnnotationType() && GrAnnotationCollector.findAnnotationCollector(anno) == null) {
            if (qname != null) {
                this.myHolder.createErrorAnnotation((PsiElement)ref, GroovyBundle.message("class.is.not.annotation", qname));
            }
            return;
        }
        for (CustomAnnotationChecker checker : (CustomAnnotationChecker[])CustomAnnotationChecker.EP_NAME.getExtensions()) {
            if (!checker.checkApplicability(this.myHolder, annotation)) continue;
            return;
        }
        String description = CustomAnnotationChecker.isAnnotationApplicable(annotation, owner);
        if (description != null) {
            this.myHolder.createErrorAnnotation((PsiElement)ref, description).registerFix((IntentionAction)new GrRemoveAnnotationIntention());
        }
    }

    public void checkAnnotationArgumentList(@NotNull GrAnnotation annotation) {
        PsiClass anno;
        if (annotation == null) {
            AnnotationChecker.$$$reportNull$$$0(2);
        }
        if ((anno = ResolveUtil.resolveAnnotation(annotation)) == null) {
            return;
        }
        for (CustomAnnotationChecker checker : (CustomAnnotationChecker[])CustomAnnotationChecker.EP_NAME.getExtensions()) {
            if (!checker.checkArgumentList(this.myHolder, annotation)) continue;
            return;
        }
        CustomAnnotationChecker.checkAnnotationArguments(this.myHolder, anno, annotation.getClassReference(), annotation.getParameterList().getAttributes(), true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/checkers/AnnotationChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkApplicability";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAnnotationArgumentList";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

