/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.dynamic;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PointersKt;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicManager;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicPropertyFix;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui.DynamicDialog;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui.DynamicElementSettings;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui.DynamicPropertyDialog;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;

public class DynamicPropertyFromLabelFix
extends DynamicPropertyFix {
    private final SmartPsiElementPointer<GrArgumentLabel> myLabelPointer;
    private final SmartPsiElementPointer<PsiClass> myTargetClassPointer;

    public DynamicPropertyFromLabelFix(@NotNull GrArgumentLabel argumentLabel, @NotNull PsiClass targetClass) {
        if (argumentLabel == null) {
            DynamicPropertyFromLabelFix.$$$reportNull$$$0(0);
        }
        if (targetClass == null) {
            DynamicPropertyFromLabelFix.$$$reportNull$$$0(1);
        }
        this.myLabelPointer = PointersKt.createSmartPointer((PsiElement)argumentLabel);
        this.myTargetClassPointer = PointersKt.createSmartPointer((PsiElement)targetClass);
    }

    @Override
    @Nullable
    protected String getRefName() {
        GrArgumentLabel namedArgument = (GrArgumentLabel)this.myLabelPointer.getElement();
        return namedArgument == null ? null : namedArgument.getName();
    }

    @Override
    @NotNull
    protected DynamicDialog createDialog() {
        DynamicPropertyDialog dynamicPropertyDialog = new DynamicPropertyDialog((GrArgumentLabel)this.myLabelPointer.getElement(), (PsiClass)this.myTargetClassPointer.getElement());
        if (dynamicPropertyDialog == null) {
            DynamicPropertyFromLabelFix.$$$reportNull$$$0(2);
        }
        return dynamicPropertyDialog;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            DynamicPropertyFromLabelFix.$$$reportNull$$$0(3);
        }
        return this.myLabelPointer.getElement() != null && this.myTargetClassPointer.getElement() != null;
    }

    @Override
    public void invoke(Project project) throws IncorrectOperationException {
        GrArgumentLabel argumentLabel = (GrArgumentLabel)this.myLabelPointer.getElement();
        if (argumentLabel == null) {
            return;
        }
        PsiClass targetClass = (PsiClass)this.myTargetClassPointer.getElement();
        if (targetClass == null) {
            return;
        }
        DynamicElementSettings settings = QuickfixUtil.createSettings(argumentLabel, targetClass);
        DynamicManager.getInstance(project).addProperty(settings);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentLabel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/annotator/intentions/dynamic/DynamicPropertyFromLabelFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/dynamic/DynamicPropertyFromLabelFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

