/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.elements;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.actions.ActionRequest;
import com.intellij.lang.jvm.actions.CreateFieldRequest;
import com.intellij.lang.jvm.actions.CreateMethodRequest;
import com.intellij.lang.jvm.actions.CreatePropertyActionGroup;
import com.intellij.lang.jvm.actions.CreateReadOnlyPropertyActionGroup;
import com.intellij.lang.jvm.actions.ExpectedParameter;
import com.intellij.lang.jvm.actions.ExpectedType;
import com.intellij.lang.jvm.actions.JvmActionGroup;
import com.intellij.lang.jvm.actions.JvmGroupIntentionAction;
import com.intellij.lang.jvm.types.JvmSubstitutor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JvmPsiConversionHelper;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.CreateFieldAction;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.CreateMemberAction;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.CreatePropertyAction$WhenMappings;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.JvmPsiUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PropertyUtilKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001#B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u000eH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u000eH\u0016J%\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0096\u0002J$\u0010\"\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006$"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/elements/CreatePropertyAction;", "Lorg/jetbrains/plugins/groovy/annotator/intentions/elements/CreateMemberAction;", "Lcom/intellij/lang/jvm/actions/JvmGroupIntentionAction;", "target", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "request", "Lcom/intellij/lang/jvm/actions/CreateMethodRequest;", "readOnly", "", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;Lcom/intellij/lang/jvm/actions/CreateMethodRequest;Z)V", "project", "Lcom/intellij/openapi/project/Project;", "propertyInfo", "Lkotlin/Pair;", "", "Lcom/intellij/lang/java/beans/PropertyKind;", "getPropertyInfo", "()Lkotlin/Pair;", "getRequest", "()Lcom/intellij/lang/jvm/actions/CreateMethodRequest;", "counterPart", "propertyKind", "getActionGroup", "Lcom/intellij/lang/jvm/actions/JvmActionGroup;", "getFamilyName", "getRenderData", "Lcom/intellij/lang/jvm/actions/JvmActionGroup$RenderData;", "getText", "invoke", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "PropertyRequest", "intellij.groovy"})
public final class CreatePropertyAction
extends CreateMemberAction
implements JvmGroupIntentionAction {
    private final Project project;
    @NotNull
    private final CreateMethodRequest request;
    private final boolean readOnly;

    private final Pair<String, PropertyKind> getPropertyInfo() {
        String string = this.getRequest().getMethodName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"request.methodName");
        Pair<String, PropertyKind> pair = PropertyUtilKt.getPropertyNameAndKind(string);
        if (pair == null) {
            String string2 = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        return pair;
    }

    @NotNull
    public JvmActionGroup.RenderData getRenderData() {
        return new JvmActionGroup.RenderData(this){
            final /* synthetic */ CreatePropertyAction this$0;

            @NotNull
            public final String getEntityName() {
                return (String)CreatePropertyAction.access$getPropertyInfo$p(this.this$0).getFirst();
            }
            {
                this.this$0 = createPropertyAction;
            }
        };
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message((String)"create.property.from.usage.family", (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message(\"create.property.from.usage.family\")");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        void propertyName;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (!super.isAvailable(project, editor, file)) {
            return false;
        }
        String string = this.getRequest().getMethodName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"request.methodName");
        Pair<String, PropertyKind> pair = PropertyUtilKt.getPropertyNameAndKind(string);
        if (pair == null) {
            return false;
        }
        Pair<String, PropertyKind> pair2 = pair;
        String string2 = (String)pair2.component1();
        PropertyKind propertyKind = (PropertyKind)pair2.component2();
        if (propertyKind == PropertyKind.SETTER && this.readOnly) {
            return false;
        }
        List list = this.getRequest().getExpectedParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"request.expectedParameters");
        List parameters = list;
        switch (CreatePropertyAction$WhenMappings.$EnumSwitchMapping$0[propertyKind.ordinal()]) {
            case 1: 
            case 2: {
                Collection collection = parameters;
                if (!(!collection.isEmpty())) break;
                return false;
            }
            case 3: {
                if (parameters.size() == 1) break;
                return false;
            }
        }
        String counterAccessorName = PropertyUtilKt.getAccessorName(this.counterPart(propertyKind), (String)propertyName);
        PsiMethod[] psiMethodArray = this.getTarget().findMethodsByName(counterAccessorName, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiMethodArray, (String)"target.findMethodsByName\u2026unterAccessorName, false)");
        PsiMethod[] psiMethodArray2 = psiMethodArray;
        return psiMethodArray2.length == 0;
    }

    private final PropertyKind counterPart(PropertyKind propertyKind) {
        PropertyKind propertyKind2;
        switch (CreatePropertyAction$WhenMappings.$EnumSwitchMapping$1[propertyKind.ordinal()]) {
            case 1: 
            case 2: {
                propertyKind2 = PropertyKind.SETTER;
                break;
            }
            case 3: {
                List list = this.getRequest().getExpectedParameters();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"request.expectedParameters");
                Object object = CollectionsKt.single((List)list);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"request.expectedParameters.single()");
                List list2 = ((ExpectedParameter)object).getExpectedTypes();
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"request.expectedParameters.single().expectedTypes");
                ExpectedType expectedType = (ExpectedType)CollectionsKt.singleOrNull((List)list2);
                if (expectedType != null && Intrinsics.areEqual((Object)PsiType.BOOLEAN, (Object)JvmPsiConversionHelper.getInstance((Project)this.project).convertType(expectedType.getTheType()))) {
                    propertyKind2 = PropertyKind.BOOLEAN_GETTER;
                    break;
                }
                propertyKind2 = PropertyKind.GETTER;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return propertyKind2;
    }

    @NotNull
    public String getText() {
        String string;
        String propertyName = GroovyPropertyUtils.getPropertyNameByAccessorName(this.getRequest().getMethodName());
        String className = ClassPresentationUtil.getNameForClass((PsiClass)this.getTarget(), (boolean)false);
        if (this.readOnly) {
            String string2 = QuickFixBundle.message((String)"create.read.only.property.from.usage.full.text", (Object[])new Object[]{propertyName, className});
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"message(\"create.read.onl\u2026 propertyName, className)");
        } else {
            String string3 = QuickFixBundle.message((String)"create.property.from.usage.full.text", (Object[])new Object[]{propertyName, className});
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"message(\"create.property\u2026 propertyName, className)");
        }
        return string;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        CreateFieldAction createFieldAction;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        CreateFieldAction $receiver = createFieldAction = new CreateFieldAction(this.getTarget(), new PropertyRequest(), false);
        if ($receiver.isAvailable(project, editor, file)) {
            $receiver.invoke(project, editor, file);
        }
    }

    @NotNull
    public JvmActionGroup getActionGroup() {
        return this.readOnly ? (JvmActionGroup)CreateReadOnlyPropertyActionGroup.INSTANCE : (JvmActionGroup)CreatePropertyActionGroup.INSTANCE;
    }

    @NotNull
    protected CreateMethodRequest getRequest() {
        return this.request;
    }

    public CreatePropertyAction(@NotNull GrTypeDefinition target, @NotNull CreateMethodRequest request, boolean readOnly) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        super(target, (ActionRequest)request);
        this.request = request;
        this.readOnly = readOnly;
        Project project = target.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"target.project");
        this.project = project;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0012\u0010\u0005\u001a\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\bH\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0006H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/elements/CreatePropertyAction$PropertyRequest;", "Lcom/intellij/lang/jvm/actions/CreateFieldRequest;", "(Lorg/jetbrains/plugins/groovy/annotator/intentions/elements/CreatePropertyAction;)V", "getFieldName", "", "getFieldType", "", "Lcom/intellij/lang/jvm/actions/ExpectedType;", "Lcom/intellij/lang/jvm/actions/ExpectedTypes;", "getModifiers", "Lcom/intellij/lang/jvm/JvmModifier;", "getTargetSubstitutor", "Lcom/intellij/lang/jvm/types/JvmSubstitutor;", "isConstant", "", "isValid", "intellij.groovy"})
    public final class PropertyRequest
    implements CreateFieldRequest {
        public boolean isValid() {
            return true;
        }

        @NotNull
        public List<JvmModifier> getModifiers() {
            return CreatePropertyAction.this.readOnly ? CollectionsKt.listOf((Object)JvmModifier.FINAL) : CollectionsKt.emptyList();
        }

        @NotNull
        public String getFieldName() {
            return (String)CreatePropertyAction.this.getPropertyInfo().getFirst();
        }

        @NotNull
        public List<ExpectedType> getFieldType() {
            return JvmPsiUtilKt.createPropertyTypeConstraints(CreatePropertyAction.this.getRequest(), (PropertyKind)CreatePropertyAction.this.getPropertyInfo().getSecond());
        }

        @NotNull
        public JvmSubstitutor getTargetSubstitutor() {
            JvmSubstitutor jvmSubstitutor = CreatePropertyAction.this.getRequest().getTargetSubstitutor();
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmSubstitutor, (String)"request.targetSubstitutor");
            return jvmSubstitutor;
        }

        public boolean isConstant() {
            return false;
        }
    }
}

