/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;

public class GroovyIfStatementWithTooManyBranchesInspectionBase
extends BaseInspection {
    private static final int DEFAULT_BRANCH_LIMIT = 3;
    public int m_limit = 3;

    private static int calculateNumBranches(GrIfStatement statement) {
        GrStatement branch = statement.getElseBranch();
        if (branch == null) {
            return 1;
        }
        if (!(branch instanceof GrIfStatement)) {
            return 2;
        }
        return 1 + GroovyIfStatementWithTooManyBranchesInspectionBase.calculateNumBranches((GrIfStatement)branch);
    }

    @NotNull
    public String getDisplayName() {
        if ("If statement with too many branches" == null) {
            GroovyIfStatementWithTooManyBranchesInspectionBase.$$$reportNull$$$0(0);
        }
        return "If statement with too many branches";
    }

    private int getLimit() {
        return this.m_limit;
    }

    @Override
    protected String buildErrorString(Object ... args) {
        GrIfStatement statement = (GrIfStatement)args[0];
        int branches = GroovyIfStatementWithTooManyBranchesInspectionBase.calculateNumBranches(statement);
        return "'#ref' statement with too many branches (" + branches + ") #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor2 = new Visitor();
        if (visitor2 == null) {
            GroovyIfStatementWithTooManyBranchesInspectionBase.$$$reportNull$$$0(1);
        }
        return visitor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyIfStatementWithTooManyBranchesInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitIfStatement(@NotNull GrIfStatement statement) {
            GrIfStatement parentStatement;
            GrStatement elseBranch;
            if (statement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitIfStatement(statement);
            PsiElement parent = statement.getParent();
            if (parent instanceof GrIfStatement && statement.equals(elseBranch = (parentStatement = (GrIfStatement)parent).getElseBranch())) {
                return;
            }
            int branches = GroovyIfStatementWithTooManyBranchesInspectionBase.calculateNumBranches(statement);
            if (branches <= GroovyIfStatementWithTooManyBranchesInspectionBase.this.getLimit()) {
                return;
            }
            this.registerStatementError(statement, statement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyIfStatementWithTooManyBranchesInspectionBase$Visitor", "visitIfStatement"));
        }
    }
}

