/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeStyle;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.fields.IntegerField;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.codeStyle.GroovyCodeStyleSettings;

public class GroovyLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    private static final Map<LanguageCodeStyleSettingsProvider.SettingsType, String> SAMPLES;

    @NotNull
    public Language getLanguage() {
        GroovyLanguage groovyLanguage = GroovyLanguage.INSTANCE;
        if (groovyLanguage == null) {
            GroovyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        return groovyLanguage;
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            GroovyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        if (settingsType == null) {
            GroovyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            consumer.showStandardOptions(new String[]{"RIGHT_MARGIN", "WRAP_ON_TYPING", "KEEP_LINE_BREAKS", "KEEP_FIRST_COLUMN_COMMENT", "KEEP_CONTROL_STATEMENT_IN_ONE_LINE", "KEEP_MULTIPLE_EXPRESSIONS_IN_ONE_LINE", "KEEP_SIMPLE_BLOCKS_IN_ONE_LINE", "KEEP_SIMPLE_METHODS_IN_ONE_LINE", "KEEP_SIMPLE_CLASSES_IN_ONE_LINE", "WRAP_LONG_LINES", "CLASS_BRACE_STYLE", "METHOD_BRACE_STYLE", "BRACE_STYLE", "EXTENDS_LIST_WRAP", "ALIGN_MULTILINE_EXTENDS_LIST", "EXTENDS_KEYWORD_WRAP", "THROWS_LIST_WRAP", "ALIGN_MULTILINE_THROWS_LIST", "ALIGN_THROWS_KEYWORD", "THROWS_KEYWORD_WRAP", "METHOD_PARAMETERS_WRAP", "ALIGN_MULTILINE_PARAMETERS", "METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE", "METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE", "CALL_PARAMETERS_WRAP", "ALIGN_MULTILINE_PARAMETERS_IN_CALLS", "PREFER_PARAMETERS_WRAP", "CALL_PARAMETERS_LPAREN_ON_NEXT_LINE", "CALL_PARAMETERS_RPAREN_ON_NEXT_LINE", "ALIGN_MULTILINE_METHOD_BRACKETS", "METHOD_CALL_CHAIN_WRAP", "ALIGN_MULTILINE_CHAINED_METHODS", "ALIGN_GROUP_FIELD_DECLARATIONS", "IF_BRACE_FORCE", "ELSE_ON_NEW_LINE", "SPECIAL_ELSE_IF_TREATMENT", "FOR_STATEMENT_WRAP", "ALIGN_MULTILINE_FOR", "FOR_STATEMENT_LPAREN_ON_NEXT_LINE", "FOR_STATEMENT_RPAREN_ON_NEXT_LINE", "FOR_BRACE_FORCE", "WHILE_BRACE_FORCE", "DOWHILE_BRACE_FORCE", "WHILE_ON_NEW_LINE", "INDENT_CASE_FROM_SWITCH", "RESOURCE_LIST_WRAP", "ALIGN_MULTILINE_RESOURCES", "RESOURCE_LIST_LPAREN_ON_NEXT_LINE", "RESOURCE_LIST_RPAREN_ON_NEXT_LINE", "CATCH_ON_NEW_LINE", "FINALLY_ON_NEW_LINE", "BINARY_OPERATION_WRAP", "ALIGN_MULTILINE_BINARY_OPERATION", "PARENTHESES_EXPRESSION_LPAREN_WRAP", "PARENTHESES_EXPRESSION_RPAREN_WRAP", "ASSIGNMENT_WRAP", "ALIGN_MULTILINE_ASSIGNMENT", "TERNARY_OPERATION_WRAP", "ALIGN_MULTILINE_TERNARY_OPERATION", "ARRAY_INITIALIZER_WRAP", "ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION", "ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE", "ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE", "MODIFIER_LIST_WRAP", "ASSERT_STATEMENT_WRAP", "CLASS_ANNOTATION_WRAP", "METHOD_ANNOTATION_WRAP", "FIELD_ANNOTATION_WRAP", "PARAMETER_ANNOTATION_WRAP", "VARIABLE_ANNOTATION_WRAP", "ENUM_CONSTANTS_WRAP"});
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "USE_FLYING_GEESE_BRACES", "Use flying geese braces", CodeStyleSettingsCustomizable.WRAPPING_BRACES, new Object[0]);
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "ALIGN_MULTILINE_LIST_OR_MAP", "Align when multiple", "List and map literals", new Object[0]);
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "ALIGN_NAMED_ARGS_IN_MAP", "Align multiline named arguments", "List and map literals", new Object[0]);
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "IMPORT_ANNOTATION_WRAP", "Import annotations", null, CodeStyleSettingsCustomizable.OptionAnchor.AFTER, "VARIABLE_ANNOTATION_WRAP", new Object[]{CodeStyleSettingsCustomizable.WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
            return;
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            consumer.showStandardOptions(new String[]{"INSERT_FIRST_SPACE_IN_LINE", "SPACE_AROUND_ASSIGNMENT_OPERATORS", "SPACE_AROUND_LOGICAL_OPERATORS", "SPACE_AROUND_EQUALITY_OPERATORS", "SPACE_AROUND_RELATIONAL_OPERATORS", "SPACE_AROUND_BITWISE_OPERATORS", "SPACE_AROUND_ADDITIVE_OPERATORS", "SPACE_AROUND_MULTIPLICATIVE_OPERATORS", "SPACE_AROUND_SHIFT_OPERATORS", "SPACE_AFTER_COMMA", "SPACE_AFTER_COMMA_IN_TYPE_ARGUMENTS", "SPACE_BEFORE_COMMA", "SPACE_AFTER_SEMICOLON", "SPACE_BEFORE_SEMICOLON", "SPACE_WITHIN_PARENTHESES", "SPACE_WITHIN_EMPTY_METHOD_CALL_PARENTHESES", "SPACE_WITHIN_METHOD_CALL_PARENTHESES", "SPACE_WITHIN_METHOD_PARENTHESES", "SPACE_WITHIN_IF_PARENTHESES", "SPACE_WITHIN_WHILE_PARENTHESES", "SPACE_WITHIN_FOR_PARENTHESES", "SPACE_WITHIN_TRY_PARENTHESES", "SPACE_WITHIN_CATCH_PARENTHESES", "SPACE_WITHIN_SWITCH_PARENTHESES", "SPACE_WITHIN_SYNCHRONIZED_PARENTHESES", "SPACE_WITHIN_CAST_PARENTHESES", "SPACE_WITHIN_BRACKETS", "SPACE_WITHIN_BRACES", "SPACE_WITHIN_ARRAY_INITIALIZER_BRACES", "SPACE_WITHIN_EMPTY_ARRAY_INITIALIZER_BRACES", "SPACE_AFTER_TYPE_CAST", "SPACE_BEFORE_METHOD_CALL_PARENTHESES", "SPACE_BEFORE_METHOD_PARENTHESES", "SPACE_BEFORE_IF_PARENTHESES", "SPACE_BEFORE_WHILE_PARENTHESES", "SPACE_BEFORE_FOR_PARENTHESES", "SPACE_BEFORE_TRY_PARENTHESES", "SPACE_BEFORE_CATCH_PARENTHESES", "SPACE_BEFORE_SWITCH_PARENTHESES", "SPACE_BEFORE_SYNCHRONIZED_PARENTHESES", "SPACE_BEFORE_CLASS_LBRACE", "SPACE_BEFORE_METHOD_LBRACE", "SPACE_BEFORE_IF_LBRACE", "SPACE_BEFORE_ELSE_LBRACE", "SPACE_BEFORE_WHILE_LBRACE", "SPACE_BEFORE_FOR_LBRACE", "SPACE_BEFORE_DO_LBRACE", "SPACE_BEFORE_SWITCH_LBRACE", "SPACE_BEFORE_TRY_LBRACE", "SPACE_BEFORE_CATCH_LBRACE", "SPACE_BEFORE_FINALLY_LBRACE", "SPACE_BEFORE_SYNCHRONIZED_LBRACE", "SPACE_BEFORE_ARRAY_INITIALIZER_LBRACE", "SPACE_BEFORE_ELSE_KEYWORD", "SPACE_BEFORE_WHILE_KEYWORD", "SPACE_BEFORE_CATCH_KEYWORD", "SPACE_BEFORE_FINALLY_KEYWORD", "SPACE_BEFORE_QUEST", "SPACE_AFTER_QUEST", "SPACE_BEFORE_COLON", "SPACE_AFTER_COLON", "SPACE_BEFORE_ANOTATION_PARAMETER_LIST", "SPACE_WITHIN_ANNOTATION_PARENTHESES"});
            consumer.renameStandardOption("SPACE_AROUND_RELATIONAL_OPERATORS", "Relational operators (<, >, <=, >=, <=>)");
            consumer.renameStandardOption("SPACE_AROUND_UNARY_OPERATOR", "Unary operators (!, -, +, ++, --, *)");
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "SPACE_IN_NAMED_ARGUMENT_BEFORE_COLON", "In named argument before ':'", CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "SPACE_IN_NAMED_ARGUMENT", "In named argument after ':'", CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "SPACE_WITHIN_LIST_OR_MAP", "List and maps literals", CodeStyleSettingsCustomizable.SPACES_WITHIN, new Object[0]);
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "SPACE_BEFORE_CLOSURE_LBRACE", "Closure left brace in method calls", CodeStyleSettingsCustomizable.SPACES_BEFORE_LEFT_BRACE, new Object[0]);
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "SPACE_WITHIN_GSTRING_INJECTION_BRACES", "GString injection braces", CodeStyleSettingsCustomizable.SPACES_WITHIN, new Object[0]);
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "SPACE_WITHIN_TUPLE_EXPRESSION", "Tuple assignment expression", CodeStyleSettingsCustomizable.SPACES_WITHIN, new Object[0]);
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "SPACE_AROUND_REGEX_OPERATORS", "Regexp expression (==~, =~)", CodeStyleSettingsCustomizable.SPACES_AROUND_OPERATORS, new Object[0]);
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "SPACE_BEFORE_ASSERT_SEPARATOR", "Before 'assert' separator", CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "SPACE_AFTER_ASSERT_SEPARATOR", "After 'assert' separator", CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            return;
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS) {
            consumer.showStandardOptions(new String[]{"KEEP_BLANK_LINES_IN_DECLARATIONS", "KEEP_BLANK_LINES_IN_CODE", "KEEP_BLANK_LINES_BEFORE_RBRACE", "BLANK_LINES_BEFORE_PACKAGE", "BLANK_LINES_AFTER_PACKAGE", "BLANK_LINES_BEFORE_IMPORTS", "BLANK_LINES_AFTER_IMPORTS", "BLANK_LINES_AROUND_CLASS", "BLANK_LINES_AFTER_CLASS_HEADER", "BLANK_LINES_AROUND_FIELD_IN_INTERFACE", "BLANK_LINES_AROUND_FIELD", "BLANK_LINES_AROUND_METHOD_IN_INTERFACE", "BLANK_LINES_AROUND_METHOD", "BLANK_LINES_BEFORE_METHOD_BODY"});
            return;
        }
        consumer.showAllStandardOptions();
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (commonSettings == null) {
            GroovyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        if (indentOptions == null) {
            GroovyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(4);
        }
        commonSettings.SPACE_WITHIN_BRACES = true;
        commonSettings.KEEP_SIMPLE_CLASSES_IN_ONE_LINE = true;
        commonSettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE = true;
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            GroovyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(5);
        }
        return SAMPLES.get(settingsType);
    }

    private static String loadSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            GroovyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(6);
        }
        String name = "/samples/" + settingsType.name() + ".txt";
        try {
            return StreamUtil.readText((InputStream)GroovyLanguageCodeStyleSettingsProvider.class.getResourceAsStream(name), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new SmartIndentOptionsEditor(){
            private JLabel myLabelIndentLabel;
            private IntegerField myLabelIndent;
            private JBLabel myStyleLabel;
            private JComboBox<LabelIndentStyle> myLabelIndentStyle;

            protected void addComponents() {
                super.addComponents();
                this.myLabelIndentLabel = new JLabel(ApplicationBundle.message((String)"editbox.indent.label.indent", (Object[])new Object[0]));
                this.myLabelIndent = new IntegerField("label indent size", 0, Integer.MAX_VALUE);
                this.add(this.myLabelIndentLabel, (JComponent)this.myLabelIndent);
                this.myStyleLabel = new JBLabel("Label indent style:");
                this.myLabelIndentStyle = new ComboBox((ComboBoxModel)new EnumComboBoxModel(LabelIndentStyle.class));
                this.add((JComponent)this.myStyleLabel, this.myLabelIndentStyle);
            }

            public boolean isModified(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options) {
                return super.isModified(settings, options) || this.myLabelIndent.getValue() != options.LABEL_INDENT_SIZE || this.isLabelStyleModified(options.LABEL_INDENT_ABSOLUTE, ((GroovyCodeStyleSettings)settings.getCustomSettings(GroovyCodeStyleSettings.class)).INDENT_LABEL_BLOCKS);
            }

            private boolean isLabelStyleModified(boolean absolute, boolean relative) {
                Object selectedStyle = this.myLabelIndentStyle.getSelectedItem();
                if (absolute) {
                    return selectedStyle != LabelIndentStyle.ABSOLUTE;
                }
                if (relative) {
                    return selectedStyle != LabelIndentStyle.RELATIVE;
                }
                return selectedStyle != LabelIndentStyle.RELATIVE_REVERSED;
            }

            public void apply(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options) {
                super.apply(settings, options);
                options.LABEL_INDENT_SIZE = this.myLabelIndent.getValue();
                LabelIndentStyle labelIndentStyle = (LabelIndentStyle)((Object)this.myLabelIndentStyle.getSelectedItem());
                options.LABEL_INDENT_ABSOLUTE = labelIndentStyle == LabelIndentStyle.ABSOLUTE;
                ((GroovyCodeStyleSettings)settings.getCustomSettings(GroovyCodeStyleSettings.class)).INDENT_LABEL_BLOCKS = labelIndentStyle == LabelIndentStyle.RELATIVE;
            }

            public void reset(@NotNull CodeStyleSettings settings, @NotNull CommonCodeStyleSettings.IndentOptions options) {
                if (settings == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (options == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.reset(settings, options);
                this.myLabelIndent.setValue(Integer.valueOf(options.LABEL_INDENT_SIZE));
                if (options.LABEL_INDENT_ABSOLUTE) {
                    this.myLabelIndentStyle.setSelectedItem((Object)LabelIndentStyle.ABSOLUTE);
                } else if (((GroovyCodeStyleSettings)settings.getCustomSettings(GroovyCodeStyleSettings.class)).INDENT_LABEL_BLOCKS) {
                    this.myLabelIndentStyle.setSelectedItem((Object)LabelIndentStyle.RELATIVE);
                } else {
                    this.myLabelIndentStyle.setSelectedItem((Object)LabelIndentStyle.RELATIVE_REVERSED);
                }
            }

            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                this.myLabelIndent.setEnabled(enabled);
                this.myLabelIndentLabel.setEnabled(enabled);
                this.myStyleLabel.setEnabled(enabled);
                this.myLabelIndentStyle.setEnabled(enabled);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "settings";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "options";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/groovy/codeStyle/GroovyLanguageCodeStyleSettingsProvider$1";
                objectArray[2] = "reset";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    static {
        EnumMap<LanguageCodeStyleSettingsProvider.SettingsType, String> samples = new EnumMap<LanguageCodeStyleSettingsProvider.SettingsType, String>(LanguageCodeStyleSettingsProvider.SettingsType.class);
        for (LanguageCodeStyleSettingsProvider.SettingsType type : new LanguageCodeStyleSettingsProvider.SettingsType[]{LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS, LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS, LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS, LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS}) {
            samples.put(type, GroovyLanguageCodeStyleSettingsProvider.loadSample(type));
        }
        SAMPLES = samples;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeStyle/GroovyLanguageCodeStyleSettingsProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeStyle/GroovyLanguageCodeStyleSettingsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "customizeDefaults";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadSample";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum LabelIndentStyle {
        ABSOLUTE("Absolute"),
        RELATIVE("Indent statements after label"),
        RELATIVE_REVERSED("Indent labels");

        private final String description;

        private LabelIndentStyle(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

