/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.compiler;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.compiler.impl.ProjectCompileScope;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.groovy.GroovyResourceChecker;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.plugins.groovy.compiler.GroovyTargetScopeProvider;

public abstract class CheckResourcesAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CheckResourcesAction.$$$reportNull$$$0(0);
        }
        CheckResourcesAction.checkResources(e.getProject(), null, this instanceof Rebuild);
    }

    @VisibleForTesting
    public static void checkResources(Project project, @Nullable CompileStatusNotification callback, boolean rebuild) {
        ProjectCompileScope scope = new ProjectCompileScope(project);
        scope.putUserData(GroovyResourceChecker.CHECKING_RESOURCES_REBUILD, (Object)rebuild);
        CompilerManager.getInstance((Project)project).make((CompileScope)scope, callback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/groovy/compiler/CheckResourcesAction", "actionPerformed"));
    }

    public static class Rebuild
    extends CheckResourcesAction {
    }

    public static class Make
    extends CheckResourcesAction {
    }

    public static class Group
    extends DefaultActionGroup {
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                Group.$$$reportNull$$$0(0);
            }
            Project project = e.getProject();
            e.getPresentation().setEnabledAndVisible(project != null && Group.containsGroovyResources(project));
        }

        private static boolean containsGroovyResources(Project project) {
            return (Boolean)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> CachedValueProvider.Result.create((Object)Group.calcContainsGroovyResources(project), (Object[])new Object[]{ProjectRootModificationTracker.getInstance((Project)project), VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS}));
        }

        private static boolean calcContainsGroovyResources(Project project) {
            return ContainerUtil.exists((Object[])ModuleManager.getInstance((Project)project).getModules(), module -> GroovyTargetScopeProvider.containsGroovyResources(JavaResourceRootType.RESOURCE, module) || GroovyTargetScopeProvider.containsGroovyResources(JavaResourceRootType.TEST_RESOURCE, module));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/groovy/compiler/CheckResourcesAction$Group", "update"));
        }
    }
}

