/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.codeInsight.highlighting.ChooseClassAndDoHighlightRunnable;
import com.intellij.codeInsight.highlighting.HighlightOverridingMethodsHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collections;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public class GrHighlightOverridingMethodsHandler
extends HighlightOverridingMethodsHandler {
    private final PsiElement myTarget;
    private final GrTypeDefinition myClass;

    public GrHighlightOverridingMethodsHandler(Editor editor, PsiFile file, PsiElement target, GrTypeDefinition psiClass) {
        super(editor, file, target, (PsiClass)psiClass);
        this.myTarget = target;
        this.myClass = psiClass;
    }

    public List<PsiClass> getTargets() {
        GrReferenceList list;
        GrReferenceList grReferenceList = list = GroovyTokenTypes.kEXTENDS == this.myTarget.getNode().getElementType() ? this.myClass.getExtendsClause() : this.myClass.getImplementsClause();
        if (list == null) {
            return Collections.emptyList();
        }
        PsiClassType[] classTypes = list.getReferencedTypes();
        return ChooseClassAndDoHighlightRunnable.resolveClasses((PsiClassType[])classTypes);
    }
}

