/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.MutablyNamedIntention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.control.ComparisonPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ComparisonUtils;

public class FlipComparisonIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        String flippedComparison;
        GrBinaryExpression binaryExpression = (GrBinaryExpression)element;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        String comparison = ComparisonUtils.getStringForComparison(tokenType);
        if (comparison.equals(flippedComparison = ComparisonUtils.getFlippedComparison(tokenType))) {
            return GroovyIntentionsBundle.message("flip.smth.intention.name", comparison);
        }
        return GroovyIntentionsBundle.message("flip.comparison.intention.name", comparison, flippedComparison);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ComparisonPredicate comparisonPredicate = new ComparisonPredicate();
        if (comparisonPredicate == null) {
            FlipComparisonIntention.$$$reportNull$$$0(0);
        }
        return comparisonPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            FlipComparisonIntention.$$$reportNull$$$0(1);
        }
        if (project == null) {
            FlipComparisonIntention.$$$reportNull$$$0(2);
        }
        GrBinaryExpression exp = (GrBinaryExpression)element;
        IElementType tokenType = exp.getOperationTokenType();
        GrExpression lhs = exp.getLeftOperand();
        String lhsText = lhs.getText();
        GrExpression rhs = exp.getRightOperand();
        String rhsText = rhs.getText();
        String flippedComparison = ComparisonUtils.getFlippedComparison(tokenType);
        String newExpression = rhsText + flippedComparison + lhsText;
        PsiImplUtil.replaceExpression(newExpression, exp);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/intentions/control/FlipComparisonIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/control/FlipComparisonIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

