/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;

public class FlipIfIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            FlipIfIntention.$$$reportNull$$$0(0);
        }
        if (project == null) {
            FlipIfIntention.$$$reportNull$$$0(1);
        }
        GrIfStatement ifStatement = (GrIfStatement)element.getParent();
        GrIfStatement elseIf = FlipIfIntention.getElseIf(ifStatement);
        GrIfStatement elseIfCopy = (GrIfStatement)elseIf.copy();
        elseIf.getCondition().replaceWithExpression(ifStatement.getCondition(), true);
        elseIf.getThenBranch().replaceWithStatement(ifStatement.getThenBranch());
        ifStatement.getCondition().replaceWithExpression(elseIfCopy.getCondition(), true);
        ifStatement.getThenBranch().replaceWithStatement(elseIfCopy.getThenBranch());
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!element.getNode().getElementType().equals(GroovyTokenTypes.kIF)) {
                    return false;
                }
                PsiElement parent = element.getParent();
                if (!(parent instanceof GrIfStatement)) {
                    return false;
                }
                GrIfStatement ifStatement = (GrIfStatement)parent;
                GrIfStatement elseIf = FlipIfIntention.getElseIf(ifStatement);
                return elseIf != null && FlipIfIntention.checkIf(ifStatement) && FlipIfIntention.checkIf(elseIf);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/control/FlipIfIntention$1", "satisfiedBy"));
            }
        };
        if (psiElementPredicate == null) {
            FlipIfIntention.$$$reportNull$$$0(2);
        }
        return psiElementPredicate;
    }

    private static GrIfStatement getElseIf(GrIfStatement ifStatement) {
        GrStatement elseBranch = ifStatement.getElseBranch();
        if (elseBranch == null) {
            return null;
        }
        if (elseBranch instanceof GrIfStatement) {
            return (GrIfStatement)elseBranch;
        }
        return null;
    }

    private static boolean checkIf(GrIfStatement ifStatement) {
        return ifStatement.getCondition() != null && ifStatement.getThenBranch() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/intentions/control/FlipIfIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/control/FlipIfIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

