/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.MixinTypeInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ConditionInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.InstructionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class ArgumentInstruction
extends InstructionImpl
implements MixinTypeInstruction {
    private static final Logger LOG = Logger.getInstance(ArgumentInstruction.class);

    public ArgumentInstruction(@NotNull GrReferenceExpression ref) {
        if (ref == null) {
            ArgumentInstruction.$$$reportNull$$$0(0);
        }
        super(ref);
    }

    @Override
    @Nullable
    public PsiType inferMixinType() {
        PsiElement element = this.getElement();
        assert (element != null);
        GrCall call = ArgumentInstruction.findCall(element);
        Object[] arguments = call.getExpressionArguments();
        boolean hasNamed = PsiImplUtil.hasNamedArguments(call.getArgumentList());
        int index = ArrayUtil.indexOf((Object[])arguments, (Object)element) + (hasNamed ? 1 : 0);
        GroovyResolveResult[] variants = call.getCallVariants((GrReferenceExpression)element);
        PsiType result2 = null;
        for (GroovyResolveResult variant : variants) {
            GrClosureSignature signature = GrClosureSignatureUtil.createSignature(variant);
            if (signature == null) continue;
            if (GrClosureSignatureUtil.mapParametersToArguments(signature, call) != null && !ArgumentInstruction.haveNullParameters(call)) {
                return null;
            }
            GrClosureParameter[] parameters = signature.getParameters();
            if (index >= parameters.length) continue;
            result2 = TypesUtil.getLeastUpperBoundNullable(result2, parameters[index].getType(), element.getManager());
        }
        return result2;
    }

    private static boolean haveNullParameters(GrCall call) {
        for (GrExpression argument : call.getExpressionArguments()) {
            if (argument.getType() != null) continue;
            return true;
        }
        return false;
    }

    private static GrCall findCall(@NotNull PsiElement element) {
        PsiElement parent;
        PsiElement pParent;
        if (element == null) {
            ArgumentInstruction.$$$reportNull$$$0(1);
        }
        PsiElement psiElement = pParent = (parent = element.getParent()) == null ? null : parent.getParent();
        if (!(pParent instanceof GrCall)) {
            LOG.error("elemText: " + element.getText() + "\nisValid = " + element.isValid() + "\nParent = " + (parent == null ? "null" : parent.getClass()) + "\nPParent = " + (pParent == null ? "null" : pParent.getClass()));
        }
        return (GrCall)pParent;
    }

    @Override
    @Nullable
    public ReadWriteVariableInstruction getInstructionToMixin(Instruction[] flow) {
        Instruction instruction = ControlFlowUtils.findInstruction(this.getElement(), flow);
        if (instruction instanceof ReadWriteVariableInstruction) {
            return (ReadWriteVariableInstruction)instruction;
        }
        return null;
    }

    @Override
    @Nullable
    public String getVariableName() {
        return ((GrReferenceExpression)this.getElement()).getReferenceName();
    }

    @Override
    @Nullable
    public ConditionInstruction getConditionInstruction() {
        return null;
    }

    @Override
    @NotNull
    protected String getElementPresentation() {
        String string = "ARGUMENT " + super.getElementPresentation();
        if (string == null) {
            ArgumentInstruction.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ArgumentInstruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ArgumentInstruction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findCall";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

