/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifiableCodeBlock;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyCodeStyleManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileBaseImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrFileStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrPackageDefinitionStub;
import org.jetbrains.plugins.groovy.lang.resolve.MethodTypeInferencer;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.bindings.BindingsKt;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyFileImports;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyImports;

public class GroovyFileImpl
extends GroovyFileBaseImpl
implements GroovyFile,
PsiModifiableCodeBlock {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileImpl");
    private static final String SYNTHETIC_PARAMETER_NAME = "args";
    private volatile Boolean myScript;
    private volatile GroovyScriptClass myScriptClass;
    private volatile GrParameter mySyntheticArgsParameter;
    private volatile PsiElement myContext;

    public GroovyFileImpl(FileViewProvider viewProvider) {
        super(viewProvider, GroovyLanguage.INSTANCE);
    }

    @Override
    @NotNull
    public String getPackageName() {
        String name;
        GrPackageDefinition packageDef = this.getPackageDefinition();
        if (packageDef != null && (name = packageDef.getPackageName()) != null) {
            String string = name;
            if (string == null) {
                GroovyFileImpl.$$$reportNull$$$0(0);
            }
            return string;
        }
        if ("" == null) {
            GroovyFileImpl.$$$reportNull$$$0(1);
        }
        return "";
    }

    @Override
    public GrPackageDefinition getPackageDefinition() {
        StubElement stub = this.getStub();
        if (stub != null) {
            for (StubElement element : stub.getChildrenStubs()) {
                if (!(element instanceof GrPackageDefinitionStub)) continue;
                return (GrPackageDefinition)element.getPsi();
            }
            return null;
        }
        ASTNode node = this.calcTreeElement().findChildByType((IElementType)GroovyElementTypes.PACKAGE_DEFINITION);
        return node != null ? (GrPackageDefinition)node.getPsi() : null;
    }

    private GrParameter getSyntheticArgsParameter() {
        GrParameter parameter = this.mySyntheticArgsParameter;
        if (parameter == null) {
            PsiType psiType = JavaPsiFacade.getElementFactory((Project)this.getProject()).createTypeFromText("java.lang.String[]", (PsiElement)this);
            this.mySyntheticArgsParameter = parameter = new GrLightParameter(SYNTHETIC_PARAMETER_NAME, psiType, this);
        }
        return parameter;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            GroovyFileImpl.$$$reportNull$$$0(2);
        }
        if (state == null) {
            GroovyFileImpl.$$$reportNull$$$0(3);
        }
        if (place == null) {
            GroovyFileImpl.$$$reportNull$$$0(4);
        }
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        if (this.getStub() == null) {
            if (!(lastParent instanceof GrMember) && !ResolveUtilKt.processLocals(this, processor, state, lastParent, place)) {
                return false;
            }
            if (!BindingsKt.processBindings(this, processor, state, lastParent, place)) {
                return false;
            }
        }
        if (this.myContext != null) {
            return true;
        }
        GroovyScriptClass scriptClass = this.getScriptClass();
        if (scriptClass != null && !(lastParent instanceof GrTypeDefinition) && !ResolveUtil.processClassDeclarations(scriptClass, processor, state, lastParent, place)) {
            return false;
        }
        if (!super.processDeclarations(processor, state, lastParent, place)) {
            return false;
        }
        return !ResolveUtil.shouldProcessProperties(classHint) || lastParent == null || lastParent instanceof GrTypeDefinition || scriptClass == null || ResolveUtil.processElement(processor, (PsiNamedElement)this.getSyntheticArgsParameter(), state);
    }

    @Override
    public boolean isTopControlFlowOwner() {
        return true;
    }

    @Override
    public GrImportStatement[] getImportStatements() {
        StubElement stub = this.getStub();
        if (stub != null) {
            return (GrImportStatement[])stub.getChildrenByType((IElementType)GroovyElementTypes.IMPORT_STATEMENT, GrImportStatement.ARRAY_FACTORY);
        }
        return (GrImportStatement[])this.calcTreeElement().getChildrenAsPsiElements((IElementType)GroovyElementTypes.IMPORT_STATEMENT, GrImportStatement.ARRAY_FACTORY);
    }

    @Override
    public GrImportStatement addImportForClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            GroovyFileImpl.$$$reportNull$$$0(5);
        }
        try {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
            String qname = aClass.getQualifiedName();
            if (qname != null) {
                GrImportStatement importStatement = factory.createImportStatementFromText(qname, false, false, null);
                return this.addImport(importStatement);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    @Override
    @NotNull
    public GrImportStatement addImport(@NotNull GrImportStatement statement) throws IncorrectOperationException {
        if (statement == null) {
            GroovyFileImpl.$$$reportNull$$$0(6);
        }
        GrImportStatement grImportStatement = GroovyCodeStyleManager.getInstance(this.getProject()).addImport(this, statement);
        if (grImportStatement == null) {
            GroovyFileImpl.$$$reportNull$$$0(7);
        }
        return grImportStatement;
    }

    @Override
    public boolean isScript() {
        StubElement stub = this.getStub();
        if (stub instanceof GrFileStub) {
            return ((GrFileStub)stub).isScript();
        }
        Boolean isScript = this.myScript;
        if (isScript == null) {
            this.myScript = isScript = Boolean.valueOf(this.checkIsScript());
        }
        return isScript;
    }

    private boolean checkIsScript() {
        GrTopStatement[] topStatements = (GrTopStatement[])this.findChildrenByClass(GrTopStatement.class);
        boolean hasClassDefinitions = false;
        boolean hasTopStatements = false;
        for (GrTopStatement st : topStatements) {
            if (st instanceof GrTypeDefinition) {
                hasClassDefinitions = true;
                continue;
            }
            if (st instanceof GrImportStatement || st instanceof GrPackageDefinition) continue;
            hasTopStatements = true;
            break;
        }
        return hasTopStatements || !hasClassDefinitions;
    }

    public void subtreeChanged() {
        this.myScript = null;
        super.subtreeChanged();
    }

    @Override
    public GroovyScriptClass getScriptClass() {
        if (!this.isScript()) {
            return null;
        }
        GroovyScriptClass aClass = this.myScriptClass;
        if (aClass == null) {
            this.myScriptClass = aClass = new GroovyScriptClass(this);
        }
        return aClass;
    }

    @Override
    public void setPackageName(String packageName) {
        GrCodeReferenceElement packageReference;
        FileASTNode fileNode = this.getNode();
        GrPackageDefinition currentPackage = this.getPackageDefinition();
        if (packageName == null || packageName.isEmpty()) {
            if (currentPackage != null) {
                ASTNode currNode = currentPackage.getNode();
                fileNode.removeChild(currNode);
            }
            return;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
        GrPackageDefinition newPackage = (GrPackageDefinition)factory.createTopElementFromText("package " + packageName);
        if (currentPackage != null && (packageReference = currentPackage.getPackageReference()) != null) {
            GrCodeReferenceElement ref = newPackage.getPackageReference();
            if (ref != null) {
                packageReference.replace(ref);
            }
            return;
        }
        ASTNode newNode = newPackage.getNode();
        if (currentPackage != null) {
            ASTNode currNode = currentPackage.getNode();
            fileNode.replaceChild(currNode, newNode);
        } else {
            ASTNode anchor = fileNode.getFirstChildNode();
            if (anchor != null && anchor.getElementType() == GroovyTokenTypes.mSH_COMMENT) {
                anchor = anchor.getTreeNext();
                fileNode.addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", anchor);
            }
            fileNode.addChild(newNode, anchor);
            if (anchor != null && !anchor.getText().startsWith("\n\n")) {
                fileNode.addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", anchor);
            }
        }
    }

    @Override
    @Nullable
    public GrPackageDefinition setPackage(@Nullable GrPackageDefinition newPackage) {
        GrPackageDefinition oldPackage = this.getPackageDefinition();
        if (oldPackage == null) {
            if (newPackage != null) {
                GrPackageDefinition result2 = (GrPackageDefinition)this.addAfter(newPackage, null);
                this.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", result2.getNode().getTreeNext());
                return result2;
            }
        } else {
            if (newPackage != null) {
                return (GrPackageDefinition)oldPackage.replace(newPackage);
            }
            oldPackage.delete();
        }
        return null;
    }

    @Override
    public PsiType getInferredScriptReturnType() {
        return (PsiType)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)GroovyPsiManager.inferType(this, new MethodTypeInferencer(this)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myScriptClass = null;
        this.mySyntheticArgsParameter = null;
    }

    public PsiElement getContext() {
        return this.myContext != null && this.myContext.isValid() ? this.myContext : super.getContext();
    }

    protected GroovyFileImpl clone() {
        GroovyFileImpl clone = (GroovyFileImpl)super.clone();
        clone.myContext = this.myContext;
        return clone;
    }

    public void setContext(PsiElement context) {
        if (context != null) {
            this.myContext = context;
        }
    }

    public void setContextNullable(PsiElement context) {
        this.myContext = context;
    }

    @Override
    @NotNull
    public PsiClass[] getClasses() {
        PsiClass[] declaredDefs = super.getClasses();
        if (!this.isScript()) {
            if (declaredDefs == null) {
                GroovyFileImpl.$$$reportNull$$$0(8);
            }
            return declaredDefs;
        }
        GroovyScriptClass scriptClass = this.getScriptClass();
        PsiClass[] result2 = new PsiClass[declaredDefs.length + 1];
        result2[result2.length - 1] = scriptClass;
        System.arraycopy(declaredDefs, 0, result2, 0, declaredDefs.length);
        if (result2 == null) {
            GroovyFileImpl.$$$reportNull$$$0(9);
        }
        return result2;
    }

    public PsiElement getOriginalElement() {
        PsiElement originalElement;
        GroovyScriptClass scriptClass = this.getScriptClass();
        if (scriptClass != null && (originalElement = scriptClass.getOriginalElement()) != scriptClass && originalElement != null) {
            return originalElement.getContainingFile();
        }
        return this;
    }

    @Override
    @NotNull
    public GrVariableDeclaration[] getScriptDeclarations(boolean topLevelOnly) {
        GrVariableDeclaration[] grVariableDeclarationArray = PsiImplUtilKt.getScriptDeclarations(this, topLevelOnly);
        if (grVariableDeclarationArray == null) {
            GroovyFileImpl.$$$reportNull$$$0(10);
        }
        return grVariableDeclarationArray;
    }

    public boolean shouldChangeModificationCount(PsiElement place) {
        if (!this.isContentsLoaded()) {
            return true;
        }
        return !this.isScript() || PsiTreeUtil.getParentOfType((PsiElement)place, (Class[])new Class[]{GrTypeDefinition.class, GrVariableDeclaration.class}) != null;
    }

    @Override
    @NotNull
    public GroovyFileImports getImports() {
        GroovyFileImports groovyFileImports = GroovyImports.getFileImports(this);
        if (groovyFileImports == null) {
            GroovyFileImpl.$$$reportNull$$$0(11);
        }
        return groovyFileImports;
    }

    @Override
    public String toString() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return super.toString();
        }
        return "GroovyFileImpl:" + this.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "addImport";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptDeclarations";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getImports";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addImportForClass";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addImport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

