/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.blocks;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.blocks.GrBlockImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.params.GrParameterListImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.ClosureSyntheticParameter;
import org.jetbrains.plugins.groovy.lang.resolve.MethodTypeInferencer;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.DelegatesToInfo;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.GrDelegatesToUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;

public class GrClosableBlockImpl
extends GrBlockImpl
implements GrClosableBlock {
    private final AtomicReference<GrParameter[]> mySyntheticItParameter;
    private static final Function<GrClosableBlock, PsiType> ourTypesCalculator = block -> GroovyPsiManager.inferType(block, new MethodTypeInferencer((GrStatementOwner)block));

    public GrClosableBlockImpl(@NotNull IElementType type, CharSequence buffer) {
        if (type == null) {
            GrClosableBlockImpl.$$$reportNull$$$0(0);
        }
        super(type, buffer);
        this.mySyntheticItParameter = new AtomicReference();
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        if (visitor2 == null) {
            GrClosableBlockImpl.$$$reportNull$$$0(1);
        }
        visitor2.visitClosure(this);
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.mySyntheticItParameter.set(null);
    }

    @Override
    public boolean processClosureDeclarations(@NotNull PsiScopeProcessor plainProcessor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (plainProcessor == null) {
            GrClosableBlockImpl.$$$reportNull$$$0(2);
        }
        if (state == null) {
            GrClosableBlockImpl.$$$reportNull$$$0(3);
        }
        if (place == null) {
            GrClosableBlockImpl.$$$reportNull$$$0(4);
        }
        if (!this.processDeclarations(plainProcessor, state, lastParent, place)) {
            return false;
        }
        return this.processOwnerAndDelegate(plainProcessor, state, place);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            GrClosableBlockImpl.$$$reportNull$$$0(5);
        }
        if (state == null) {
            GrClosableBlockImpl.$$$reportNull$$$0(6);
        }
        if (place == null) {
            GrClosableBlockImpl.$$$reportNull$$$0(7);
        }
        if (lastParent == null) {
            return true;
        }
        if (!super.processDeclarations(processor, state, lastParent, place)) {
            return false;
        }
        if (!this.processParameters(processor, state, place)) {
            return false;
        }
        return this.processClosureClassMembers(processor, state, lastParent, place);
    }

    private boolean processOwnerAndDelegate(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        Boolean result2;
        if (processor == null) {
            GrClosableBlockImpl.$$$reportNull$$$0(8);
        }
        if (state == null) {
            GrClosableBlockImpl.$$$reportNull$$$0(9);
        }
        if (place == null) {
            GrClosableBlockImpl.$$$reportNull$$$0(10);
        }
        if ((result2 = this.processDelegatesTo(processor, state, place)) != null) {
            return result2;
        }
        return this.processOwner(processor, state, place);
    }

    @Nullable
    private Boolean processDelegatesTo(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        DelegatesToInfo info;
        if (processor == null) {
            GrClosableBlockImpl.$$$reportNull$$$0(11);
        }
        if (state == null) {
            GrClosableBlockImpl.$$$reportNull$$$0(12);
        }
        if (place == null) {
            GrClosableBlockImpl.$$$reportNull$$$0(13);
        }
        if ((info = GrDelegatesToUtilKt.getDelegatesToInfo(this)) == null) {
            return null;
        }
        switch (info.getStrategy()) {
            case 0: {
                if (!this.processOwner(processor, state, place)) {
                    return false;
                }
                if (!this.processDelegate(processor, state, place, info.getTypeToDelegate())) {
                    return false;
                }
                return true;
            }
            case 1: {
                if (!this.processDelegate(processor, state, place, info.getTypeToDelegate())) {
                    return false;
                }
                if (!this.processOwner(processor, state, place)) {
                    return false;
                }
                return true;
            }
            case 2: {
                if (!this.processOwner(processor, state, place)) {
                    return false;
                }
                return true;
            }
            case 3: {
                if (!this.processDelegate(processor, state, place, info.getTypeToDelegate())) {
                    return false;
                }
                return true;
            }
            case 4: {
                return true;
            }
        }
        return null;
    }

    private boolean processDelegate(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place, @Nullable PsiType classToDelegate) {
        if (processor == null) {
            GrClosableBlockImpl.$$$reportNull$$$0(14);
        }
        if (state == null) {
            GrClosableBlockImpl.$$$reportNull$$$0(15);
        }
        if (place == null) {
            GrClosableBlockImpl.$$$reportNull$$$0(16);
        }
        if (classToDelegate == null) {
            return true;
        }
        ResolveState delegateState = state.put(ClassHint.THIS_TYPE, (Object)classToDelegate).put(ClassHint.RESOLVE_CONTEXT, (Object)this);
        return ResolveUtil.processAllDeclarations(classToDelegate, processor, delegateState, place);
    }

    private boolean processClosureClassMembers(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        PsiClass closureClass;
        if (processor == null) {
            GrClosableBlockImpl.$$$reportNull$$$0(17);
        }
        if (state == null) {
            GrClosableBlockImpl.$$$reportNull$$$0(18);
        }
        if (place == null) {
            GrClosableBlockImpl.$$$reportNull$$$0(19);
        }
        if ((closureClass = JavaPsiFacade.getInstance((Project)this.getProject()).findClass("groovy.lang.Closure", this.getResolveScope())) == null) {
            return true;
        }
        return ResolveUtil.processClassDeclarations(closureClass, processor, state.put(ClassHint.RESOLVE_CONTEXT, (Object)this), lastParent, place);
    }

    private boolean processParameters(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        GrParameter[] synth;
        if (processor == null) {
            GrClosableBlockImpl.$$$reportNull$$$0(20);
        }
        if (state == null) {
            GrClosableBlockImpl.$$$reportNull$$$0(21);
        }
        if (place == null) {
            GrClosableBlockImpl.$$$reportNull$$$0(22);
        }
        if (!ResolveUtilKt.shouldProcessLocals(processor)) {
            return true;
        }
        if (this.hasParametersSection()) {
            for (GrParameter parameter : this.getParameters()) {
                if (ResolveUtil.processElement(processor, (PsiNamedElement)parameter, state)) continue;
                return false;
            }
        } else if (!this.isItAlreadyDeclared(place) && (synth = this.getSyntheticItParameter()).length > 0 && !ResolveUtil.processElement(processor, (PsiNamedElement)synth[0], state.put(ClassHint.RESOLVE_CONTEXT, (Object)this))) {
            return false;
        }
        return true;
    }

    private boolean processOwner(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        PsiElement parent;
        if (processor == null) {
            GrClosableBlockImpl.$$$reportNull$$$0(23);
        }
        if (state == null) {
            GrClosableBlockImpl.$$$reportNull$$$0(24);
        }
        if (place == null) {
            GrClosableBlockImpl.$$$reportNull$$$0(25);
        }
        if ((parent = this.getParent()) == null) {
            return true;
        }
        if (!ResolveUtil.processStaticImports(processor, this.getContainingFile(), state, place)) {
            return false;
        }
        return ResolveUtil.treeWalkUp(parent, place, processor, state);
    }

    private boolean isItAlreadyDeclared(@Nullable PsiElement place) {
        while (place != this && place != null) {
            if (place instanceof GrClosableBlock && !((GrClosableBlock)place).hasParametersSection() && !(place.getParent() instanceof GrStringInjection)) {
                return true;
            }
            place = place.getParent();
        }
        return false;
    }

    public String toString() {
        return "Closable block";
    }

    @Override
    @NotNull
    public GrParameter[] getParameters() {
        if (this.hasParametersSection()) {
            GrParameterListImpl parameterList = this.getParameterList();
            GrParameter[] grParameterArray = parameterList.getParameters();
            if (grParameterArray == null) {
                GrClosableBlockImpl.$$$reportNull$$$0(26);
            }
            return grParameterArray;
        }
        if (GrParameter.EMPTY_ARRAY == null) {
            GrClosableBlockImpl.$$$reportNull$$$0(27);
        }
        return GrParameter.EMPTY_ARRAY;
    }

    @Override
    public GrParameter[] getAllParameters() {
        if (this.getParent() instanceof GrStringInjection) {
            return GrParameter.EMPTY_ARRAY;
        }
        if (this.hasParametersSection()) {
            return this.getParameters();
        }
        return this.getSyntheticItParameter();
    }

    @Override
    @Nullable
    public PsiElement getArrow() {
        return this.findPsiChildByType(GroovyTokenTypes.mCLOSABLE_BLOCK_OP);
    }

    @Override
    public boolean isVarArgs() {
        return PsiImplUtil.isVarArgs(this.getParameters());
    }

    @Override
    @NotNull
    public GrParameterListImpl getParameterList() {
        GrParameterListImpl childByClass = (GrParameterListImpl)this.findChildByClass(GrParameterListImpl.class);
        assert (childByClass != null);
        GrParameterListImpl grParameterListImpl = childByClass;
        if (grParameterListImpl == null) {
            GrClosableBlockImpl.$$$reportNull$$$0(28);
        }
        return grParameterListImpl;
    }

    @Override
    public GrParameter addParameter(GrParameter parameter) {
        GrParameterListImpl parameterList = this.getParameterList();
        if (this.getArrow() == null) {
            GrParameterList newParamList = (GrParameterList)this.addAfter(parameterList, this.getLBrace());
            parameterList.delete();
            ASTNode next = newParamList.getNode().getTreeNext();
            this.getNode().addLeaf(GroovyTokenTypes.mCLOSABLE_BLOCK_OP, (CharSequence)"->", next);
            return (GrParameter)newParamList.add(parameter);
        }
        return (GrParameter)parameterList.add(parameter);
    }

    @Override
    public boolean hasParametersSection() {
        return this.getArrow() != null;
    }

    @Override
    public PsiType getType() {
        return GrClosureType.create(this, true);
    }

    @Override
    @Nullable
    public PsiType getNominalType() {
        return this.getType();
    }

    public GrParameter[] getSyntheticItParameter() {
        if (this.getParent() instanceof GrStringInjection) {
            return GrParameter.EMPTY_ARRAY;
        }
        return this.mySyntheticItParameter.updateAndGet(value -> {
            GrParameter[] grParameterArray;
            if (value == null) {
                GrParameter[] grParameterArray2 = new GrParameter[1];
                grParameterArray = grParameterArray2;
                grParameterArray2[0] = new ClosureSyntheticParameter(this, true);
            } else {
                grParameterArray = value;
            }
            return grParameterArray;
        });
    }

    @Override
    @Nullable
    public PsiType getOwnerType() {
        return (PsiType)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.doGetOwnerType(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private PsiType doGetOwnerType() {
        PsiClass scriptClass;
        GroovyPsiElement context = (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)this, (Class[])new Class[]{GrTypeDefinition.class, GrClosableBlock.class, GroovyFile.class});
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
        if (context instanceof GrTypeDefinition) {
            return factory.createType((PsiClass)context);
        }
        if (context instanceof GrClosableBlock) {
            return ((GrClosableBlock)context).getType();
        }
        if (context instanceof GroovyFile && (scriptClass = ((GroovyFile)context).getScriptClass()) != null && GroovyNamesUtil.isIdentifier(scriptClass.getName())) {
            return factory.createType(scriptClass);
        }
        return null;
    }

    @Override
    public GrExpression replaceWithExpression(@NotNull GrExpression newExpr, boolean removeUnnecessaryParentheses) {
        if (newExpr == null) {
            GrClosableBlockImpl.$$$reportNull$$$0(29);
        }
        return PsiImplUtil.replaceExpression(this, newExpr, removeUnnecessaryParentheses);
    }

    @Override
    @Nullable
    public PsiType getReturnType() {
        return TypeInferenceHelper.getCurrentContext().getExpressionType(this, ourTypesCalculator);
    }

    @Override
    public void removeStatement() throws IncorrectOperationException {
        GroovyPsiElementImpl.removeStatement(this);
    }

    @Override
    public boolean isTopControlFlowOwner() {
        return !(this.getParent() instanceof GrStringInjection);
    }

    @Override
    @NotNull
    public PsiElement getLBrace() {
        PsiElement psiElement = Objects.requireNonNull(super.getLBrace());
        if (psiElement == null) {
            GrClosableBlockImpl.$$$reportNull$$$0(30);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plainProcessor";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/blocks/GrClosableBlockImpl";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/blocks/GrClosableBlockImpl";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterList";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getLBrace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processClosureDeclarations";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processOwnerAndDelegate";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processDelegatesTo";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processDelegate";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processClosureClassMembers";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processParameters";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processOwner";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

