/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyImportHelper;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyUnusedImportUtil;

public class GroovyImportUtil {
    public static void processFile(final @Nullable PsiFile file, final @Nullable Set<? super String> importedClasses, final @Nullable Set<? super String> staticallyImportedMembers, final @Nullable Set<? super GrImportStatement> usedImports, @Nullable Set<? super GrImportStatement> unresolvedOnDemandImports, final @Nullable Set<? super String> implicitlyImported, final @Nullable Set<? super String> innerClasses, final @Nullable Map<String, String> aliased, final @Nullable Map<String, String> annotations2) {
        if (!(file instanceof GroovyFile)) {
            return;
        }
        final LinkedHashSet unresolvedReferenceNames = ContainerUtil.newLinkedHashSet();
        file.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (!(element instanceof GrImportStatement) && !(element instanceof GrPackageDefinition)) {
                    super.visitElement(element);
                }
                if (element instanceof GrReferenceElement) {
                    this.visitRefElement((GrReferenceElement)element);
                }
            }

            private void visitRefElement(GrReferenceElement refElement) {
                if (refElement.isQualified()) {
                    return;
                }
                String refName = refElement.getReferenceName();
                if ("super".equals(refName)) {
                    return;
                }
                GroovyResolveResult[] resolveResults = refElement.multiResolve(false);
                if (resolveResults.length == 0 && refName != null && PsiTreeUtil.getParentOfType((PsiElement)refElement, GrImportStatement.class) == null) {
                    unresolvedReferenceNames.add(refName);
                }
                for (GroovyResolveResult resolveResult : resolveResults) {
                    PsiElement context = resolveResult.getCurrentFileResolveContext();
                    PsiElement resolved = resolveResult.getElement();
                    if (resolved == null) {
                        return;
                    }
                    if (context instanceof GrImportStatement) {
                        GrImportStatement importStatement = (GrImportStatement)context;
                        if (usedImports != null) {
                            usedImports.add(importStatement);
                        }
                        if (GroovyImportHelper.isImplicitlyImported(resolved, refName, (GroovyFile)file)) {
                            this.addImplicitClass(resolved);
                        }
                        if (importStatement.isAliasedImport() || GroovyImportUtil.isAnnotatedImport(importStatement)) continue;
                        String importedName = null;
                        if (importStatement.isOnDemand()) {
                            if (importStatement.isStatic()) {
                                String name;
                                String classQName;
                                PsiMember member;
                                PsiClass clazz;
                                if (resolved instanceof PsiMember && (clazz = (member = (PsiMember)resolved).getContainingClass()) != null && (classQName = clazz.getQualifiedName()) != null && (name = member.getName()) != null) {
                                    importedName = classQName + "." + name;
                                }
                            } else {
                                importedName = GroovyImportUtil.getTargetQualifiedName(resolved);
                            }
                        } else {
                            importedName = importStatement.getImportFqn();
                        }
                        if (importedName == null) {
                            return;
                        }
                        String importRef = importStatement.getImportFqn();
                        if (importStatement.isAliasedImport()) {
                            if (aliased != null) {
                                aliased.put(importRef, importedName);
                            }
                            return;
                        }
                        if (importStatement.isStatic()) {
                            if (staticallyImportedMembers == null) continue;
                            staticallyImportedMembers.add(importedName);
                            continue;
                        }
                        if (importedClasses != null) {
                            importedClasses.add(importedName);
                        }
                        if (!(resolved instanceof PsiClass) || ((PsiClass)resolved).getContainingClass() == null || innerClasses == null) continue;
                        innerClasses.add(importedName);
                        continue;
                    }
                    if (context != null || refElement.getParent() instanceof GrImportStatement || refElement.getQualifier() != null || resolved instanceof PsiClass && ((PsiClass)resolved).getContainingClass() != null) continue;
                    this.addImplicitClass(resolved);
                }
            }

            private void addImplicitClass(PsiElement element) {
                String qname = GroovyImportUtil.getTargetQualifiedName(element);
                if (qname != null) {
                    if (implicitlyImported != null) {
                        implicitlyImported.add(qname);
                    }
                    if (importedClasses != null) {
                        importedClasses.add(qname);
                    }
                }
            }
        });
        LinkedHashSet importsToCheck = ContainerUtil.newLinkedHashSet(PsiUtil.getValidImportStatements((GroovyFile)file));
        for (GrImportStatement anImport : importsToCheck) {
            if (usedImports != null && usedImports.contains(anImport)) continue;
            GrCodeReferenceElement ref = anImport.getImportReference();
            assert (ref != null) : "invalid import!";
            if (ref.resolve() != null) continue;
            if (anImport.isOnDemand()) {
                if (usedImports != null) {
                    usedImports.add(anImport);
                }
                if (unresolvedOnDemandImports == null) continue;
                unresolvedOnDemandImports.add(anImport);
                continue;
            }
            String importedName = anImport.getImportedName();
            if (importedName == null || !unresolvedReferenceNames.contains(importedName)) continue;
            if (usedImports != null) {
                usedImports.add(anImport);
            }
            String symbolName = anImport.getImportFqn();
            if (anImport.isAliasedImport()) {
                if (aliased == null) continue;
                aliased.put(symbolName, importedName);
                continue;
            }
            if (anImport.isStatic()) {
                if (staticallyImportedMembers == null) continue;
                staticallyImportedMembers.add(symbolName);
                continue;
            }
            if (importedClasses == null) continue;
            importedClasses.add(symbolName);
        }
        if (annotations2 != null) {
            ((GroovyFile)file).acceptChildren(new GroovyElementVisitor(){

                @Override
                public void visitImportStatement(@NotNull GrImportStatement importStatement) {
                    String annotationText;
                    if (importStatement == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (!StringUtil.isEmptyOrSpaces((String)(annotationText = importStatement.getAnnotationList().getText()))) {
                        String importRef = importStatement.getImportFqn();
                        annotations2.put(importRef, annotationText);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importStatement", "org/jetbrains/plugins/groovy/lang/psi/util/GroovyImportUtil$2", "visitImportStatement"));
                }
            });
        }
        if (usedImports != null) {
            usedImports.removeAll(GroovyUnusedImportUtil.unusedImports((GroovyFile)file));
        }
    }

    @Nullable
    private static String getTargetQualifiedName(PsiElement element) {
        PsiClass aClass;
        if (element instanceof PsiClass) {
            return ((PsiClass)element).getQualifiedName();
        }
        if (element instanceof PsiMethod && ((PsiMethod)element).isConstructor() && (aClass = ((PsiMethod)element).getContainingClass()) != null) {
            return aClass.getQualifiedName();
        }
        return null;
    }

    public static boolean isAnnotatedImport(GrImportStatement anImport) {
        return !StringUtil.isEmptyOrSpaces((String)anImport.getAnnotationList().getText());
    }
}

