/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.ProjectTopics;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.GuiUtils;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.mvc.MvcConsole;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;
import org.jetbrains.plugins.groovy.mvc.MvcModuleStructureUtil;
import org.jetbrains.plugins.groovy.mvc.MvcWatchedRootProvider;
import org.jetbrains.plugins.groovy.mvc.projectView.MvcToolWindowDescriptor;

public class MvcModuleStructureSynchronizer
implements ProjectComponent {
    private static final ExecutorService ourExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"MvcModuleStructureSynchronizer Pool");
    private final Set<Pair<Object, SyncAction>> myOrders = new LinkedHashSet<Pair<Object, SyncAction>>();
    private final Project myProject;
    private Set<VirtualFile> myPluginRoots = Collections.emptySet();
    private boolean myOutOfModuleDirectoryCreatedActionAdded;
    public static boolean ourGrailsTestFlag;
    private final SimpleModificationTracker myModificationTracker = new SimpleModificationTracker();

    public MvcModuleStructureSynchronizer(Project project) {
        this.myProject = project;
    }

    public SimpleModificationTracker getFileAndRootsModificationTracker() {
        return this.myModificationTracker;
    }

    public void initComponent() {
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                MvcModuleStructureSynchronizer.this.myModificationTracker.incModificationCount();
                MvcModuleStructureSynchronizer.this.queue(SyncAction.SyncLibrariesInPluginsModule, MvcModuleStructureSynchronizer.this.myProject);
                MvcModuleStructureSynchronizer.this.queue(SyncAction.UpgradeFramework, MvcModuleStructureSynchronizer.this.myProject);
                MvcModuleStructureSynchronizer.this.queue(SyncAction.CreateAppStructureIfNeeded, MvcModuleStructureSynchronizer.this.myProject);
                MvcModuleStructureSynchronizer.this.queue(SyncAction.UpdateProjectStructure, MvcModuleStructureSynchronizer.this.myProject);
                MvcModuleStructureSynchronizer.this.queue(SyncAction.EnsureRunConfigurationExists, MvcModuleStructureSynchronizer.this.myProject);
                MvcModuleStructureSynchronizer.this.updateProjectViewVisibility();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/groovy/mvc/MvcModuleStructureSynchronizer$1", "rootsChanged"));
            }
        });
        connection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void moduleAdded(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (module == null) {
                    2.$$$reportNull$$$0(1);
                }
                MvcModuleStructureSynchronizer.this.queue(SyncAction.UpdateProjectStructure, module);
                MvcModuleStructureSynchronizer.this.queue(SyncAction.CreateAppStructureIfNeeded, module);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "module";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/groovy/mvc/MvcModuleStructureSynchronizer$2";
                objectArray[2] = "moduleAdded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter(new VirtualFileListener(){
            final ProjectFileIndex myFileIndex;
            {
                this.myFileIndex = ProjectFileIndex.getInstance((Project)MvcModuleStructureSynchronizer.this.myProject);
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                VirtualFile file;
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!this.myFileIndex.isInContent(file = event.getFile())) {
                    return;
                }
                MvcModuleStructureSynchronizer.this.myModificationTracker.incModificationCount();
                String fileName = event.getFileName();
                if ("application.properties".equals(fileName) || MvcModuleStructureSynchronizer.isApplicationDirectoryName(fileName)) {
                    MvcModuleStructureSynchronizer.this.queue(SyncAction.UpdateProjectStructure, file);
                    MvcModuleStructureSynchronizer.this.queue(SyncAction.EnsureRunConfigurationExists, file);
                } else if (MvcModuleStructureSynchronizer.isLibDirectory(file) || MvcModuleStructureSynchronizer.isLibDirectory(event.getParent())) {
                    MvcModuleStructureSynchronizer.this.queue(SyncAction.UpdateProjectStructure, file);
                } else {
                    if (!MvcModuleStructureSynchronizer.this.myProject.isInitialized()) {
                        return;
                    }
                    Module module = ProjectRootManager.getInstance((Project)MvcModuleStructureSynchronizer.this.myProject).getFileIndex().getModuleForFile(file);
                    if (module == null) {
                        if (file.isDirectory()) {
                            if (MvcModuleStructureSynchronizer.this.myPluginRoots.contains(file.getParent())) {
                                MvcModuleStructureSynchronizer.this.queue(SyncAction.UpdateProjectStructure, MvcModuleStructureSynchronizer.this.myProject);
                                return;
                            }
                            if (!MvcModuleStructureSynchronizer.this.myOutOfModuleDirectoryCreatedActionAdded) {
                                MvcModuleStructureSynchronizer.this.queue(SyncAction.OutOfModuleDirectoryCreated, MvcModuleStructureSynchronizer.this.myProject);
                                MvcModuleStructureSynchronizer.this.myOutOfModuleDirectoryCreatedActionAdded = true;
                            }
                        }
                        return;
                    }
                    if (!MvcConsole.isUpdatingVfsByConsoleProcess(module)) {
                        return;
                    }
                    MvcFramework framework = MvcFramework.getInstance(module);
                    if (framework == null) {
                        return;
                    }
                    if (framework.isToReformatOnCreation(file) || file.isDirectory()) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (!file.isValid()) {
                                return;
                            }
                            if (!framework.hasSupport(module)) {
                                return;
                            }
                            ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
                            if (file.isDirectory()) {
                                ModuleRootManager.getInstance((Module)module).getFileIndex().iterateContentUnderDirectory(file, fileOrDir -> {
                                    if (!fileOrDir.isDirectory() && framework.isToReformatOnCreation(fileOrDir)) {
                                        files.add(file);
                                    }
                                    return true;
                                });
                            } else {
                                files.add(file);
                            }
                            PsiManager manager = PsiManager.getInstance((Project)MvcModuleStructureSynchronizer.this.myProject);
                            for (VirtualFile virtualFile : files) {
                                PsiFile psiFile = manager.findFile(virtualFile);
                                if (psiFile == null) continue;
                                new ReformatCodeProcessor(MvcModuleStructureSynchronizer.this.myProject, psiFile, null, false).run();
                            }
                        }, module.getDisposed());
                    }
                }
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(1);
                }
                VirtualFile file = event.getFile();
                MvcModuleStructureSynchronizer.this.myModificationTracker.incModificationCount();
                if (MvcModuleStructureSynchronizer.isLibDirectory(file) || MvcModuleStructureSynchronizer.isLibDirectory(event.getParent())) {
                    MvcModuleStructureSynchronizer.this.queue(SyncAction.UpdateProjectStructure, file);
                }
            }

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                VirtualFile file;
                if (event == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (!this.myFileIndex.isInContent(file = event.getFile())) {
                    return;
                }
                String fileName = event.getFileName();
                if ("application.properties".equals(fileName)) {
                    MvcModuleStructureSynchronizer.this.queue(SyncAction.UpdateProjectStructure, file);
                }
            }

            public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(3);
                }
                if (!this.myFileIndex.isInContent(event.getFile())) {
                    return;
                }
                MvcModuleStructureSynchronizer.this.myModificationTracker.incModificationCount();
            }

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(4);
                }
                if (!this.myFileIndex.isInContent(event.getFile())) {
                    return;
                }
                if ("name".equals(event.getPropertyName())) {
                    MvcModuleStructureSynchronizer.this.myModificationTracker.incModificationCount();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "org/jetbrains/plugins/groovy/mvc/MvcModuleStructureSynchronizer$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileCreated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileDeleted";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentsChanged";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileMoved";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "propertyChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }));
    }

    public static MvcModuleStructureSynchronizer getInstance(Project project) {
        return (MvcModuleStructureSynchronizer)project.getComponent(MvcModuleStructureSynchronizer.class);
    }

    private static boolean isApplicationDirectoryName(String fileName) {
        for (MvcFramework framework : (MvcFramework[])MvcFramework.EP_NAME.getExtensions()) {
            if (!framework.getApplicationDirectoryName().equals(fileName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isLibDirectory(@Nullable VirtualFile file) {
        return file != null && "lib".equals(file.getName());
    }

    public void projectOpened() {
        this.queue(SyncAction.UpdateProjectStructure, this.myProject);
        this.queue(SyncAction.EnsureRunConfigurationExists, this.myProject);
        this.queue(SyncAction.UpgradeFramework, this.myProject);
        this.queue(SyncAction.CreateAppStructureIfNeeded, this.myProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(SyncAction action, Object on) {
        boolean shouldSchedule;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed()) {
            return;
        }
        Set<Pair<Object, SyncAction>> set = this.myOrders;
        synchronized (set) {
            shouldSchedule = this.myOrders.isEmpty();
            this.myOrders.add((Pair<Object, SyncAction>)Pair.create((Object)on, (Object)((Object)action)));
        }
        if (shouldSchedule) {
            StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized((Runnable)((DumbAwareRunnable)() -> this.scheduleRunActions()));
        }
    }

    private void scheduleRunActions() {
        if (this.myProject.isDisposed()) {
            return;
        }
        Application app = ApplicationManager.getApplication();
        if (app.isUnitTestMode()) {
            if (ourGrailsTestFlag && !this.myProject.isInitialized()) {
                this.runActions(this.computeRawActions(this.takeOrderSnapshot()));
            }
            return;
        }
        final LinkedHashSet<Pair<Object, SyncAction>> orderSnapshot = this.takeOrderSnapshot();
        ReadTask task = new ReadTask(){

            @NotNull
            public ReadTask.Continuation performInReadAction(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                Set actions = this.isUpToDate() ? MvcModuleStructureSynchronizer.this.computeRawActions(orderSnapshot) : Collections.emptySet();
                ReadTask.Continuation continuation = new ReadTask.Continuation(() -> {
                    if (indicator == null) {
                        4.$$$reportNull$$$0(3);
                    }
                    if (this.isUpToDate()) {
                        MvcModuleStructureSynchronizer.this.runActions(actions);
                    } else if (!indicator.isCanceled()) {
                        MvcModuleStructureSynchronizer.this.scheduleRunActions();
                    }
                }, ModalityState.NON_MODAL);
                if (continuation == null) {
                    4.$$$reportNull$$$0(1);
                }
                return continuation;
            }

            public void onCanceled(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(2);
                }
                MvcModuleStructureSynchronizer.this.scheduleRunActions();
            }

            private boolean isUpToDate() {
                return !MvcModuleStructureSynchronizer.this.myProject.isDisposed() && orderSnapshot.equals(MvcModuleStructureSynchronizer.this.takeOrderSnapshot());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/groovy/mvc/MvcModuleStructureSynchronizer$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/groovy/mvc/MvcModuleStructureSynchronizer$4";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "performInReadAction";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "performInReadAction";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "onCanceled";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$performInReadAction$0";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        GuiUtils.invokeLaterIfNeeded(() -> ProgressIndicatorUtils.scheduleWithWriteActionPriority((Executor)ourExecutor, (ReadTask)task), (ModalityState)ModalityState.NON_MODAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedHashSet<Pair<Object, SyncAction>> takeOrderSnapshot() {
        Set<Pair<Object, SyncAction>> set = this.myOrders;
        synchronized (set) {
            return new LinkedHashSet<Pair<Object, SyncAction>>(this.myOrders);
        }
    }

    @NotNull
    private List<Module> determineModuleBySyncActionObject(Object o) {
        VirtualFile file;
        if (o instanceof Module) {
            List<Module> list = Collections.singletonList((Module)o);
            if (list == null) {
                MvcModuleStructureSynchronizer.$$$reportNull$$$0(0);
            }
            return list;
        }
        if (o instanceof Project) {
            List<Module> list = Arrays.asList(ModuleManager.getInstance((Project)((Project)o)).getModules());
            if (list == null) {
                MvcModuleStructureSynchronizer.$$$reportNull$$$0(1);
            }
            return list;
        }
        if (o instanceof VirtualFile && (file = (VirtualFile)o).isValid()) {
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)this.myProject);
            if (module == null) {
                List<Module> list = Collections.emptyList();
                if (list == null) {
                    MvcModuleStructureSynchronizer.$$$reportNull$$$0(2);
                }
                return list;
            }
            List<Module> list = Collections.singletonList(module);
            if (list == null) {
                MvcModuleStructureSynchronizer.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<Module> list = Collections.emptyList();
        if (list == null) {
            MvcModuleStructureSynchronizer.$$$reportNull$$$0(4);
        }
        return list;
    }

    public static void forceUpdateProject(Project project) {
        MvcModuleStructureSynchronizer instance = (MvcModuleStructureSynchronizer)project.getComponent(MvcModuleStructureSynchronizer.class);
        instance.getFileAndRootsModificationTracker().incModificationCount();
        instance.runActions(instance.computeRawActions(instance.takeOrderSnapshot()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runActions(Set<Trinity<Module, SyncAction, MvcFramework>> actions) {
        try {
            boolean isProjectStructureUpdated = false;
            for (Trinity<Module, SyncAction, MvcFramework> rawAction : actions) {
                Module module = (Module)rawAction.first;
                if (module.isDisposed()) continue;
                if (rawAction.second == SyncAction.UpdateProjectStructure && ((MvcFramework)rawAction.third).updatesWholeProject()) {
                    if (isProjectStructureUpdated) continue;
                    isProjectStructureUpdated = true;
                }
                ((SyncAction)((Object)rawAction.second)).doAction(module, (MvcFramework)rawAction.third);
            }
        }
        finally {
            Set<Pair<Object, SyncAction>> set = this.myOrders;
            synchronized (set) {
                this.myOrders.clear();
            }
        }
    }

    private Set<Trinity<Module, SyncAction, MvcFramework>> computeRawActions(Set<Pair<Object, SyncAction>> actions) {
        LinkedHashSet<Trinity<Module, SyncAction, MvcFramework>> rawActions = new LinkedHashSet<Trinity<Module, SyncAction, MvcFramework>>();
        for (Pair<Object, SyncAction> pair : actions) {
            for (Module module : this.determineModuleBySyncActionObject(pair.first)) {
                MvcFramework framework;
                if (module.isDisposed() || (framework = pair.second == SyncAction.CreateAppStructureIfNeeded ? MvcFramework.getInstanceBySdk(module) : MvcFramework.getInstance(module)) == null || framework.isAuxModule(module)) continue;
                rawActions.add((Trinity<Module, SyncAction, MvcFramework>)Trinity.create((Object)module, (Object)pair.second, (Object)framework));
            }
        }
        return rawActions;
    }

    private void updateProjectViewVisibility() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized((Runnable)((DumbAwareRunnable)() -> ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            for (ToolWindowEP ep : (ToolWindowEP[])ToolWindowEP.EP_NAME.getExtensions()) {
                if (!MvcToolWindowDescriptor.class.isAssignableFrom(ep.getFactoryClass())) continue;
                MvcToolWindowDescriptor descriptor2 = (MvcToolWindowDescriptor)ep.getToolWindowFactory();
                String id = descriptor2.getToolWindowId();
                boolean shouldShow = descriptor2.value(this.myProject);
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
                ToolWindow toolWindow = toolWindowManager.getToolWindow(id);
                if (shouldShow && toolWindow == null) {
                    toolWindow = toolWindowManager.registerToolWindow(id, true, ToolWindowAnchor.LEFT, (Disposable)this.myProject, true);
                    toolWindow.setIcon(descriptor2.getFramework().getToolWindowIcon());
                    descriptor2.createToolWindowContent(this.myProject, toolWindow);
                    continue;
                }
                if (shouldShow || toolWindow == null) continue;
                toolWindowManager.unregisterToolWindow(id);
                Disposer.dispose((Disposable)toolWindow.getContentManager());
            }
        })));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/mvc/MvcModuleStructureSynchronizer", "determineModuleBySyncActionObject"));
    }

    public static enum SyncAction {
        SyncLibrariesInPluginsModule{

            @Override
            void doAction(Module module, MvcFramework framework) {
                if (MvcModuleStructureUtil.isEnabledStructureUpdate()) {
                    framework.syncSdkAndLibrariesInPluginsModule(module);
                }
            }
        }
        ,
        UpgradeFramework{

            @Override
            void doAction(Module module, MvcFramework framework) {
                framework.upgradeFramework(module);
            }
        }
        ,
        CreateAppStructureIfNeeded{

            @Override
            void doAction(Module module, MvcFramework framework) {
                framework.createApplicationIfNeeded(module);
            }
        }
        ,
        UpdateProjectStructure{

            @Override
            void doAction(Module module, MvcFramework framework) {
                framework.updateProjectStructure(module);
            }
        }
        ,
        EnsureRunConfigurationExists{

            @Override
            void doAction(Module module, MvcFramework framework) {
                framework.ensureRunConfigurationExists(module);
            }
        }
        ,
        OutOfModuleDirectoryCreated{

            @Override
            void doAction(Module module, MvcFramework framework) {
                Project project = module.getProject();
                MvcModuleStructureSynchronizer mvcModuleStructureSynchronizer = MvcModuleStructureSynchronizer.getInstance(project);
                if (mvcModuleStructureSynchronizer.myOutOfModuleDirectoryCreatedActionAdded) {
                    mvcModuleStructureSynchronizer.myOutOfModuleDirectoryCreatedActionAdded = false;
                    HashSet roots = new HashSet();
                    for (String rootPath : MvcWatchedRootProvider.getRootsToWatch(project)) {
                        ContainerUtil.addIfNotNull(roots, (Object)LocalFileSystem.getInstance().findFileByPath(rootPath));
                    }
                    if (!roots.equals(mvcModuleStructureSynchronizer.myPluginRoots)) {
                        mvcModuleStructureSynchronizer.myPluginRoots = roots;
                        ApplicationManager.getApplication().invokeLater(() -> mvcModuleStructureSynchronizer.queue(UpdateProjectStructure, project));
                    }
                }
            }
        };


        abstract void doAction(Module var1, MvcFramework var2);
    }
}

